/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.enums;

import com.tplink.cdd.radius.common.enums.AuthProtocol;
import java.util.ArrayList;
import java.util.List;

public enum TlsTunnelProtocolEnum {
    EAP_MD5("EAP-MD5", 0),
    PAP("PAP", 1),
    EAP_MSCHAP_V2("EAP-MSCHAPV2", 2);

    private String name;
    private Integer index;

    private TlsTunnelProtocolEnum(String name, Integer index) {
        this.name = name;
        this.index = index;
    }

    public static TlsTunnelProtocolEnum of(Integer index) {
        for (TlsTunnelProtocolEnum tlsTunnelProtocolEnum : TlsTunnelProtocolEnum.values()) {
            if (!tlsTunnelProtocolEnum.index.equals(index)) continue;
            return tlsTunnelProtocolEnum;
        }
        return null;
    }

    public static TlsTunnelProtocolEnum mapperAuthProtocol(AuthProtocol authProtocol) {
        switch (authProtocol) {
            case EAP_MD5: {
                return EAP_MD5;
            }
            case PAP: {
                return PAP;
            }
            case MS_CHAP_V2: {
                return EAP_MSCHAP_V2;
            }
        }
        return null;
    }

    public boolean isEapProtocol() {
        return EAP_MD5 == this || EAP_MSCHAP_V2 == this;
    }

    public static List<TlsTunnelProtocolEnum> eapProtocol() {
        ArrayList<TlsTunnelProtocolEnum> eapProtocol = new ArrayList<TlsTunnelProtocolEnum>();
        eapProtocol.add(EAP_MD5);
        eapProtocol.add(EAP_MSCHAP_V2);
        return eapProtocol;
    }

    public static List<TlsTunnelProtocolEnum> ttlsAllTunnelProtocol() {
        ArrayList<TlsTunnelProtocolEnum> tlsTunnelProtocolEnums = new ArrayList<TlsTunnelProtocolEnum>();
        for (TlsTunnelProtocolEnum tlsTunnelProtocolEnum : TlsTunnelProtocolEnum.values()) {
            tlsTunnelProtocolEnums.add(tlsTunnelProtocolEnum);
        }
        return tlsTunnelProtocolEnums;
    }

    public static List<TlsTunnelProtocolEnum> peapAllTunnelProtocol() {
        ArrayList<TlsTunnelProtocolEnum> peapTunnelProtocolEnums = new ArrayList<TlsTunnelProtocolEnum>();
        peapTunnelProtocolEnums.add(EAP_MD5);
        peapTunnelProtocolEnums.add(EAP_MSCHAP_V2);
        return peapTunnelProtocolEnums;
    }

    public String getName() {
        return this.name;
    }

    public Integer getIndex() {
        return this.index;
    }
}

