/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.enums;

import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.State;
import com.tplink.cdd.component.aaa.server.utils.AccessRequestUtil;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CurrentState {
    DEFAULT_STATE(State.DEFAULT),
    EAP_MD5_STATE_READY(State.of(AuthProtocol.EAP_MD5, 0)),
    EAP_MD5_STATE_AUTH_SUCCESS(State.of(AuthProtocol.EAP_MD5, 1)),
    EAP_TLS_STATE_READY(State.of(AuthProtocol.EAP_TLS, 0)),
    EAP_TLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING(State.of(AuthProtocol.EAP_TLS, 1)),
    EAP_TLS_STATE_WAIT_CLIENT_KEY(State.of(AuthProtocol.EAP_TLS, 2)),
    EAP_TLS_STATE_WAIT_CLIENT_KEY_NEXT_FRAGMENT(State.of(AuthProtocol.EAP_TLS, 3)),
    EAP_TLS_STATE_WAIT_TLS_ACK(State.of(AuthProtocol.EAP_TLS, 4)),
    EAP_TLS_STATE_AUTH_SUCCESS(State.of(AuthProtocol.EAP_TLS, 5)),
    EAP_TTLS_STATE_READY(State.of(AuthProtocol.EAP_TTLS, 0)),
    EAP_TTLS_STATE_SERVER_HELLO_SEND_FRAGMENT_ING(State.of(AuthProtocol.EAP_TTLS, 1)),
    EAP_TTLS_STATE_WAIT_CLIENT_KEY(State.of(AuthProtocol.EAP_TTLS, 2)),
    EAP_TTLS_STATE_WAIT_TUNNEL_AUTHENTICATION(State.of(AuthProtocol.EAP_TTLS, 3)),
    EAP_TTLS_STATE_AUTH_SUCCESS(State.of(AuthProtocol.EAP_TTLS, 4)),
    EAP_TTLS_STATE_WAIT_EAP_MD5_CHALLENGE(State.of(AuthProtocol.EAP_TTLS, 5)),
    EAP_TTLS_STATE_WAIT_EAPMSCHAPV2_RESPONSE(State.of(AuthProtocol.EAP_TTLS, 6)),
    EAP_TTLS_STATE_WAIT_EAPMSCHAPV2_VERIFIED_RESPONSE(State.of(AuthProtocol.EAP_TTLS, 7)),
    PEAP_STATE_READY(State.of(AuthProtocol.PEAP, 0)),
    PEAP_STATE_SERVER_HELLO_SEND_FRAGMENT_ING(State.of(AuthProtocol.PEAP, 1)),
    PEAP_STATE_WAIT_CLIENT_KEY(State.of(AuthProtocol.PEAP, 2)),
    PEAP_STATE_WAIT_TLS_ACK(State.of(AuthProtocol.PEAP, 3)),
    PEAP_STATE_WAIT_TUNNEL_AUTHENTICATION(State.of(AuthProtocol.PEAP, 4)),
    PEAP_STATE_TUNNEL_FINISH(State.of(AuthProtocol.PEAP, 5)),
    PEAP_STATE_AUTH_SUCCESS(State.of(AuthProtocol.PEAP, 6)),
    PEAP_STATE_WAIT_MSCHAPV2_RESPONSE(State.of(AuthProtocol.PEAP, 7)),
    PEAP_STATE_WAIT_MSCHAPV2_VERIFIED_RESPONSE(State.of(AuthProtocol.PEAP, 8)),
    PEAP_STATE_WAIT_MD5_CHALLENGE(State.of(AuthProtocol.PEAP, 9));

    private static final Logger log;
    public static final Set<CurrentState> ALL_STATE;
    private final State state;

    private CurrentState(State state) {
        this.state = state;
    }

    public static Set<CurrentState> buildSet(CurrentState ... currentStateList) {
        return new HashSet<CurrentState>(Arrays.asList(currentStateList));
    }

    public static CurrentState afterTlsClientKey(DataType dataType) {
        switch (dataType) {
            case EAP_TLS: {
                return EAP_TLS_STATE_WAIT_TLS_ACK;
            }
            case EAP_TTLS: {
                return EAP_TTLS_STATE_WAIT_TUNNEL_AUTHENTICATION;
            }
            case PEAP: {
                return PEAP_STATE_WAIT_TLS_ACK;
            }
        }
        log.warn("Invalid data type [{}] for TLS client key", (Object)dataType);
        return null;
    }

    public static CurrentState afterTunnelAuth(AuthReq authReq) {
        EapResponse eapResponse = AccessRequestUtil.findEapResponse(authReq.getAccessRequest());
        DataType dataType = eapResponse.getDataType();
        switch (dataType) {
            case EAP_TTLS: {
                return EAP_TTLS_STATE_AUTH_SUCCESS;
            }
            case PEAP: {
                return PEAP_STATE_AUTH_SUCCESS;
            }
        }
        log.warn("Invalid data type [{}] for tunnel auth", (Object)dataType);
        return null;
    }

    public State getState() {
        return this.state;
    }

    static {
        log = LoggerFactory.getLogger(CurrentState.class);
        ALL_STATE = Arrays.stream(CurrentState.values()).collect(Collectors.toSet());
    }
}

