/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.config;

import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.core.authentication.eap.config.ActionBucketMethod;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.ActionCategory;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.TriggerEvent;
import com.tplink.cdd.component.aaa.core.authentication.utils.EapPacketUtil;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequestEap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ActionProxy {
    private static final Logger log = LoggerFactory.getLogger(ActionProxy.class);
    @Autowired
    @Qualifier(value="eapActionDispatcher")
    private Map<ActionCategory, ActionBucketMethod> actionDispatcher;

    public EapPacket action(CurrentState currentState, TriggerEvent triggerEvent, AuthReq authReq) {
        ActionCategory actionCategory = ActionCategory.of(currentState, triggerEvent);
        if (Objects.isNull((Object)actionCategory)) {
            return EapPacketUtil.failure((AccessRequestEap)authReq.getAccessRequest());
        }
        ActionBucketMethod actionBucketMethod = this.actionDispatcher.get((Object)actionCategory);
        if (Objects.isNull(actionBucketMethod)) {
            log.debug("Unsupported protocol , action category: {}", (Object)actionCategory.name());
            return EapPacketUtil.failure((AccessRequestEap)authReq.getAccessRequest());
        }
        try {
            return (EapPacket)actionBucketMethod.getMethod().invoke((Object)actionBucketMethod.getActionBucket(), authReq);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke action method = {}", (Object)actionBucketMethod, (Object)e);
            return EapPacketUtil.failure((AccessRequestEap)authReq.getAccessRequest());
        }
    }
}

