/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap.config;

import com.tplink.cdd.component.aaa.core.authentication.eap.annotation.Action;
import com.tplink.cdd.component.aaa.core.authentication.eap.config.ActionBucketMethod;
import com.tplink.cdd.component.aaa.core.authentication.eap.enums.ActionCategory;
import com.tplink.cdd.component.aaa.core.authentication.eap.service.ActionBucket;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy(value=false)
public class ActionConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ActionConfig.class);
    private ApplicationContext applicationContext;

    @Bean(value={"eapActionDispatcher"})
    public Map<ActionCategory, ActionBucketMethod> initEapActionDispatcher() {
        ConcurrentHashMap<ActionCategory, ActionBucketMethod> invokes = new ConcurrentHashMap<ActionCategory, ActionBucketMethod>();
        Map actionBucketMap = this.applicationContext.getBeansOfType(ActionBucket.class);
        for (Map.Entry entry : actionBucketMap.entrySet()) {
            Method[] methods;
            ActionBucket actionBucket = (ActionBucket)entry.getValue();
            for (Method method : methods = actionBucket.getClass().getDeclaredMethods()) {
                Action actionAnnotation = method.getAnnotation(Action.class);
                if (!Objects.nonNull(actionAnnotation)) continue;
                invokes.put(actionAnnotation.value(), new ActionBucketMethod(actionBucket, method));
            }
        }
        log.info("Success to init eap action dispatcher, num = {}, invokes = {}", (Object)invokes.size(), invokes);
        return invokes;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        this.applicationContext = applicationContext;
    }
}

