/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.eap;

import cn.hutool.core.util.PrimitiveArrayUtil;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.dictionary.Dictionary;
import com.tplink.cdd.radius.common.eap.enums.DataType;
import com.tplink.cdd.radius.common.eap.packet.EapResponse;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.TlsPacket;
import com.tplink.cdd.radius.common.tls.enums.TlsVersion;
import com.tplink.cdd.radius.common.tls.recordlayer.ApplicationData;
import com.tplink.cdd.radius.common.ttls.DiameterFormat;
import com.tplink.cdd.radius.common.utils.CipherUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EapAuthHelper {
    private static final Logger log = LoggerFactory.getLogger(EapAuthHelper.class);
    private static final String MASTER_SECRET_LABEL = "master secret";
    private static final int MASTER_SECRET_SIZE = 48;
    private static final String SERVER_FINISHED_LABEL = "server finished";
    private static final int SERVER_FINISHED_SIZE = 12;
    private static final String CLIENT_FINISHED_LABEL = "client finished";
    private static final int CLIENT_FINISHED_SIZE = 12;
    private static final int FINISHED_WITH_HEADER_START_INDEX = 0;
    private static final int FINISHED_WITH_HEADER_END_INDEX = 16;
    private static final int FINISHED_VERIFY_DATA_START_INDEX = 4;
    private static final int FINISHED_VERIFY_DATA_END_INDEX = 16;

    public AuthProtocol parseNakDesiredAuthProtocol(EapResponse eapResponse) {
        return this.parseNakDesiredAuthProtocol(eapResponse.getDataValue());
    }

    public AuthProtocol parseNakDesiredAuthProtocol(ByteBuf dataValue) {
        byte desiredAuthType = dataValue.getByte(0);
        DataType desiredDataType = DataType.fromIndex((byte)desiredAuthType);
        if (Objects.isNull(desiredDataType)) {
            log.warn("Current version can not support NAK({})", (Object)desiredAuthType);
            return null;
        }
        return desiredDataType.getAuthProtocol();
    }

    public byte[] computeEapMd5CheckValue(byte eapRequestId, String password, byte[] challenge) {
        MessageDigest messageDigest = DigestUtils.getMd5Digest();
        messageDigest.update(eapRequestId);
        messageDigest.update(password.getBytes(StandardCharsets.UTF_8));
        messageDigest.update(challenge);
        return messageDigest.digest();
    }

    public boolean tlsPacketIsNeedSplit(TlsPacket tlsPacket) {
        return tlsPacket.toByteBuf().readableBytes() > 1024;
    }

    public ByteBuf splitTlsPacketAndFindFirst(TlsPacket tlsPacket, UserEapCacheInfo.EapTlsInfo eapTlsInfo) {
        ByteBuf tlsByteBuf = tlsPacket.toByteBuf();
        ArrayList<ByteBuf> tlsPacketByteBufList = new ArrayList<ByteBuf>();
        while (tlsByteBuf.readableBytes() != 0) {
            tlsPacketByteBufList.add(tlsByteBuf.readBytes(Math.min(tlsByteBuf.readableBytes(), 1024)));
        }
        ByteBuf firstFragment = (ByteBuf)tlsPacketByteBufList.remove(0);
        eapTlsInfo.setReqFragmentList(tlsPacketByteBufList);
        return firstFragment;
    }

    public byte[] decryptByCertificatePublicKey(byte[] data, PublicKey publicKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public byte[] decryptByCertificatePrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public byte[] messageHash(byte[] data) {
        byte[] md5HashMsg = DigestUtils.md5((byte[])data);
        byte[] sha1HashMsg = DigestUtils.sha1((byte[])data);
        return CipherUtil.concat((byte[])md5HashMsg, (byte[])sha1HashMsg);
    }

    public byte[] messageHashV1_2(byte[] data) {
        return DigestUtils.sha256((byte[])data);
    }

    public byte[] buildMasterSecret(byte[] randomSeed, byte[] preMaster, TlsVersion tlsVersion) {
        if (tlsVersion == TlsVersion.V1_0 || tlsVersion == TlsVersion.V1_1) {
            return CipherUtil.PRF((byte[])preMaster, (String)MASTER_SECRET_LABEL, (byte[])randomSeed, (int)48);
        }
        return CipherUtil.PRF_SHA256((byte[])preMaster, (String)MASTER_SECRET_LABEL, (byte[])randomSeed, (int)48);
    }

    public byte[] buildServerFinishedVerifyData(byte[] masterSecret, ByteBuf toCheckHsData, TlsVersion tlsVersion) {
        if (tlsVersion == TlsVersion.V1_0 || tlsVersion == TlsVersion.V1_1) {
            return CipherUtil.PRF((byte[])masterSecret, (String)SERVER_FINISHED_LABEL, (byte[])this.messageHash(ByteBufUtil.getBytes((ByteBuf)toCheckHsData)), (int)12);
        }
        return CipherUtil.PRF_SHA256((byte[])masterSecret, (String)SERVER_FINISHED_LABEL, (byte[])this.messageHashV1_2(ByteBufUtil.getBytes((ByteBuf)toCheckHsData)), (int)12);
    }

    public byte[] buildClientFinishedVerifyData(byte[] masterSecret, ByteBuf toCheckHsData, TlsVersion tlsVersion) {
        if (tlsVersion == TlsVersion.V1_0 || tlsVersion == TlsVersion.V1_1) {
            return CipherUtil.PRF((byte[])masterSecret, (String)CLIENT_FINISHED_LABEL, (byte[])this.messageHash(ByteBufUtil.getBytes((ByteBuf)toCheckHsData)), (int)12);
        }
        return CipherUtil.PRF_SHA256((byte[])masterSecret, (String)CLIENT_FINISHED_LABEL, (byte[])this.messageHashV1_2(ByteBufUtil.getBytes((ByteBuf)toCheckHsData)), (int)12);
    }

    public byte[] getClientFinished(byte[] finished) {
        return Arrays.copyOfRange(finished, 0, 16);
    }

    public byte[] getClientVerifyData(byte[] finished) {
        return Arrays.copyOfRange(finished, 4, 16);
    }

    public List<RadiusAttribute> appDataList2AvpList(Dictionary dictionary, List<ApplicationData> appDataList) {
        List<byte[]> bytes = appDataList.stream().map(ApplicationData::getPlainText).filter(PrimitiveArrayUtil::isNotEmpty).collect(Collectors.toList());
        ArrayList<RadiusAttribute> avpList = new ArrayList<RadiusAttribute>();
        bytes.forEach(bs -> avpList.addAll(DiameterFormat.byteArray2RadiusAttribute((Dictionary)dictionary, (byte[])bs)));
        return avpList;
    }

    public ApplicationData avpList2AppData(List<RadiusAttribute> attributeList, TlsCipher tlsCipher) {
        byte[] plainText = DiameterFormat.radiusAttribute2ByteArray(attributeList);
        return new ApplicationData(plainText, tlsCipher);
    }
}

