/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.dto;

import com.tplink.cdd.component.aaa.core.authentication.dto.AuthReq;
import com.tplink.cdd.component.aaa.server.utils.AccessResponseUtil;
import com.tplink.cdd.radius.common.attribute.type.RadiusAttribute;
import com.tplink.cdd.radius.common.eap.packet.EapPacket;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.response.AccessResponse;
import java.util.List;

public class AuthResp {
    private Boolean success;
    private AccessResponse accessResponse;
    private String ppskUserName;
    private String ppskPassword;

    public static AuthResp accept(AccessRequest accessRequest) {
        return AuthResp.of(AccessResponseUtil.accept(accessRequest));
    }

    public static AuthResp reject(AccessRequest accessRequest) {
        return AuthResp.of(AccessResponseUtil.reject(accessRequest));
    }

    public static AuthResp acceptWithAttrs(AccessRequest accessRequest, List<RadiusAttribute> attributeList) {
        return AuthResp.of(AccessResponseUtil.accept(accessRequest, attributeList));
    }

    public static AuthResp acceptPpskunbound(AccessRequest accessRequest, List<RadiusAttribute> attributeList, String ppskUserName, String ppskPassword) {
        AuthResp authResp = AuthResp.of(AccessResponseUtil.accept(accessRequest, attributeList));
        authResp.setPpskUserName(ppskUserName);
        authResp.setPpskPassword(ppskPassword);
        return authResp;
    }

    public static AuthResp fromEapPacket(EapPacket eapPacket, AuthReq authReq) {
        return AuthResp.of(AccessResponseUtil.fromEapPacket(authReq.getAccessRequest(), eapPacket, authReq));
    }

    public static AuthResp of(AccessResponse accessResponse) {
        Boolean success = Boolean.TRUE;
        if (accessResponse instanceof AccessResponse.Reject) {
            success = Boolean.FALSE;
        }
        return AuthResp.builder().success(success).accessResponse(accessResponse).build();
    }

    public static AuthRespBuilder builder() {
        return new AuthRespBuilder();
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public AccessResponse getAccessResponse() {
        return this.accessResponse;
    }

    public String getPpskUserName() {
        return this.ppskUserName;
    }

    public String getPpskPassword() {
        return this.ppskPassword;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setAccessResponse(AccessResponse accessResponse) {
        this.accessResponse = accessResponse;
    }

    public void setPpskUserName(String ppskUserName) {
        this.ppskUserName = ppskUserName;
    }

    public void setPpskPassword(String ppskPassword) {
        this.ppskPassword = ppskPassword;
    }

    public AuthResp() {
    }

    public AuthResp(Boolean success, AccessResponse accessResponse, String ppskUserName, String ppskPassword) {
        this.success = success;
        this.accessResponse = accessResponse;
        this.ppskUserName = ppskUserName;
        this.ppskPassword = ppskPassword;
    }

    public static class AuthRespBuilder {
        private Boolean success;
        private AccessResponse accessResponse;
        private String ppskUserName;
        private String ppskPassword;

        AuthRespBuilder() {
        }

        public AuthRespBuilder success(Boolean success) {
            this.success = success;
            return this;
        }

        public AuthRespBuilder accessResponse(AccessResponse accessResponse) {
            this.accessResponse = accessResponse;
            return this;
        }

        public AuthRespBuilder ppskUserName(String ppskUserName) {
            this.ppskUserName = ppskUserName;
            return this;
        }

        public AuthRespBuilder ppskPassword(String ppskPassword) {
            this.ppskPassword = ppskPassword;
            return this;
        }

        public AuthResp build() {
            return new AuthResp(this.success, this.accessResponse, this.ppskUserName, this.ppskPassword);
        }

        public String toString() {
            return "AuthResp.AuthRespBuilder(success=" + this.success + ", accessResponse=" + this.accessResponse + ", ppskUserName=" + this.ppskUserName + ", ppskPassword=" + this.ppskPassword + ")";
        }
    }
}

