/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.dto;

import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.server.io.RequestCtx;
import com.tplink.cdd.radius.common.eap.packet.data.EapTlsPacket;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.packet.request.AccessRequest;
import com.tplink.cdd.radius.common.packet.request.RadiusRequest;
import com.tplink.cdd.radius.common.utils.RadiusAttributeUtil;
import java.net.InetSocketAddress;
import java.util.Objects;

public class AuthReq {
    private AuthType authType;
    private AuthProtocol authProtocol;
    private RequestCtx msg;
    private UserEapCacheInfo userEapCacheInfo;
    private AuthProtocol nakAuthProtocol;
    private EapTlsPacket eapTlsPacket;

    public AccessRequest getAccessRequest() {
        return (AccessRequest)this.msg.getRequest();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.msg.getEndpoint().getAddress();
    }

    public String getRadiusKey() {
        return this.msg.getRadiusKey();
    }

    public byte[] getAuthenticator() {
        AccessRequest accessRequest = (AccessRequest)this.msg.getRequest();
        if (Objects.isNull(accessRequest)) {
            return new byte[0];
        }
        return accessRequest.getAuthenticator();
    }

    public String getUsername() {
        return RadiusAttributeUtil.username((RadiusRequest)this.msg.getRequest());
    }

    public String getNasMac() {
        return RadiusAttributeUtil.nasMac((RadiusRequest)this.msg.getRequest());
    }

    public static AuthReqBuilder builder() {
        return new AuthReqBuilder();
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public AuthProtocol getAuthProtocol() {
        return this.authProtocol;
    }

    public RequestCtx getMsg() {
        return this.msg;
    }

    public UserEapCacheInfo getUserEapCacheInfo() {
        return this.userEapCacheInfo;
    }

    public AuthProtocol getNakAuthProtocol() {
        return this.nakAuthProtocol;
    }

    public EapTlsPacket getEapTlsPacket() {
        return this.eapTlsPacket;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public void setAuthProtocol(AuthProtocol authProtocol) {
        this.authProtocol = authProtocol;
    }

    public void setMsg(RequestCtx msg) {
        this.msg = msg;
    }

    public void setUserEapCacheInfo(UserEapCacheInfo userEapCacheInfo) {
        this.userEapCacheInfo = userEapCacheInfo;
    }

    public void setNakAuthProtocol(AuthProtocol nakAuthProtocol) {
        this.nakAuthProtocol = nakAuthProtocol;
    }

    public void setEapTlsPacket(EapTlsPacket eapTlsPacket) {
        this.eapTlsPacket = eapTlsPacket;
    }

    public AuthReq() {
    }

    public AuthReq(AuthType authType, AuthProtocol authProtocol, RequestCtx msg, UserEapCacheInfo userEapCacheInfo, AuthProtocol nakAuthProtocol, EapTlsPacket eapTlsPacket) {
        this.authType = authType;
        this.authProtocol = authProtocol;
        this.msg = msg;
        this.userEapCacheInfo = userEapCacheInfo;
        this.nakAuthProtocol = nakAuthProtocol;
        this.eapTlsPacket = eapTlsPacket;
    }

    public static class AuthReqBuilder {
        private AuthType authType;
        private AuthProtocol authProtocol;
        private RequestCtx msg;
        private UserEapCacheInfo userEapCacheInfo;
        private AuthProtocol nakAuthProtocol;
        private EapTlsPacket eapTlsPacket;

        AuthReqBuilder() {
        }

        public AuthReqBuilder authType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public AuthReqBuilder authProtocol(AuthProtocol authProtocol) {
            this.authProtocol = authProtocol;
            return this;
        }

        public AuthReqBuilder msg(RequestCtx msg) {
            this.msg = msg;
            return this;
        }

        public AuthReqBuilder userEapCacheInfo(UserEapCacheInfo userEapCacheInfo) {
            this.userEapCacheInfo = userEapCacheInfo;
            return this;
        }

        public AuthReqBuilder nakAuthProtocol(AuthProtocol nakAuthProtocol) {
            this.nakAuthProtocol = nakAuthProtocol;
            return this;
        }

        public AuthReqBuilder eapTlsPacket(EapTlsPacket eapTlsPacket) {
            this.eapTlsPacket = eapTlsPacket;
            return this;
        }

        public AuthReq build() {
            return new AuthReq(this.authType, this.authProtocol, this.msg, this.userEapCacheInfo, this.nakAuthProtocol, this.eapTlsPacket);
        }

        public String toString() {
            return "AuthReq.AuthReqBuilder(authType=" + this.authType + ", authProtocol=" + this.authProtocol + ", msg=" + this.msg + ", userEapCacheInfo=" + this.userEapCacheInfo + ", nakAuthProtocol=" + this.nakAuthProtocol + ", eapTlsPacket=" + this.eapTlsPacket + ")";
        }
    }
}

