/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.config;

import com.tplink.cdd.component.aaa.core.authentication.annotation.EapAuth;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.EapAuthHandler;
import com.tplink.cdd.radius.common.enums.AuthProtocol;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy(value=false)
public class EapAuthConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EapAuthConfig.class);
    private ApplicationContext applicationContext;

    @Bean(value={"eapAuthDispatcher"})
    public Map<AuthProtocol, EapAuthHandler> initEapAuthDispatcher() {
        ConcurrentHashMap<AuthProtocol, EapAuthHandler> invokes = new ConcurrentHashMap<AuthProtocol, EapAuthHandler>();
        Map eapAuthHandlerMap = this.applicationContext.getBeansWithAnnotation(EapAuth.class);
        for (Map.Entry entry : eapAuthHandlerMap.entrySet()) {
            EapAuthHandler eapAuthHandler = (EapAuthHandler)entry.getValue();
            EapAuth authAnnotation = eapAuthHandler.getClass().getAnnotation(EapAuth.class);
            AuthProtocol eapAuthProtocol = authAnnotation.eapAuthProtocol();
            invokes.put(eapAuthProtocol, eapAuthHandler);
        }
        log.info("Success to init eap auth dispatcher, num = {}, invokes = {}", (Object)invokes.size(), invokes);
        return invokes;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        this.applicationContext = applicationContext;
    }
}

