/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.config;

import com.tplink.cdd.radius.common.utils.FileUtil;
import com.tplink.cdd.radius.common.utils.TwoTuple;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy
public class CertificateConfig {
    private static final Logger log = LoggerFactory.getLogger(CertificateConfig.class);
    private static final String CERTIFICATE_X509 = "X.509";
    private static final String CERTIFICATE_P12 = "PKCS12";
    @Value(value="${aaa.certificate.ca.path}")
    private String caCertificatePath;
    @Value(value="${aaa.certificate.server.path}")
    private String serverCertificatePath;
    @Value(value="${aaa.certificate.server.store-pass}")
    private String serverCertificateStorePass;
    @Value(value="${aaa.certificate.server.key-pass}")
    private String serverCertificateKeyPass;

    @Bean(value={"caCertificatePublicKey"})
    public byte[] initCACertificatePublicKey() {
        return this.parseX509Certificate(this.caCertificatePath);
    }

    @Bean(value={"caCertificate"})
    public X509Certificate initCACertificate() {
        return this.parseX509Certification(this.caCertificatePath);
    }

    @Bean(value={"serverCertificate"})
    public TwoTuple<byte[], PrivateKey> initServerCertificate() {
        try {
            KeyStore ks = KeyStore.getInstance(CERTIFICATE_P12);
            ks.load(FileUtil.getInputStream((String)this.serverCertificatePath), this.serverCertificateStorePass.toCharArray());
            if (ks.aliases().hasMoreElements()) {
                String alias = ks.aliases().nextElement();
                Certificate certificate = ks.getCertificate(alias);
                PrivateKey privateKey = (PrivateKey)ks.getKey(alias, this.serverCertificateKeyPass.toCharArray());
                return new TwoTuple((Object)certificate.getEncoded(), (Object)privateKey);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error("catch an unexpected exception : ", (Throwable)e);
        }
        catch (IOException e) {
            log.error("can not find the file", (Throwable)e);
        }
        return null;
    }

    private byte[] parseX509Certificate(String path) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_X509);
            return cf.generateCertificate(FileUtil.getInputStream((String)path)).getEncoded();
        }
        catch (IOException | CertificateException e) {
            log.error("catch an unexpected exception : ", (Throwable)e);
            return null;
        }
    }

    private X509Certificate parseX509Certification(String path) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_X509);
            return (X509Certificate)cf.generateCertificate(FileUtil.getInputStream((String)path));
        }
        catch (IOException | CertificateException e) {
            log.error("catch an unexpected exception : ", (Throwable)e);
            return null;
        }
    }
}

