/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.config;

import com.tplink.cdd.component.aaa.core.authentication.annotation.Auth;
import com.tplink.cdd.component.aaa.core.authentication.service.handler.RadiusAuthHandler;
import com.tplink.cdd.radius.common.enums.AuthType;
import com.tplink.cdd.radius.common.enums.RadiusAuthPacketType;
import com.tplink.cdd.radius.common.enums.UserAuthCategory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Lazy(value=false)
public class AuthConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AuthConfig.class);
    private ApplicationContext applicationContext;

    @Bean(value={"radiusAuthDispatcher"})
    public Map<UserAuthCategory, RadiusAuthHandler> initRadiusAuthDispatcher() {
        ConcurrentHashMap<UserAuthCategory, RadiusAuthHandler> invokes = new ConcurrentHashMap<UserAuthCategory, RadiusAuthHandler>();
        Map radiusAuthHandlerMap = this.applicationContext.getBeansWithAnnotation(Auth.class);
        for (Map.Entry entry : radiusAuthHandlerMap.entrySet()) {
            RadiusAuthHandler radiusAuthHandler = (RadiusAuthHandler)entry.getValue();
            Auth authAnnotation = radiusAuthHandler.getClass().getAnnotation(Auth.class);
            RadiusAuthPacketType radiusAuthPacketType = authAnnotation.radiusAuthPacketType();
            AuthType authType = authAnnotation.authType();
            invokes.put(UserAuthCategory.of((RadiusAuthPacketType)radiusAuthPacketType, (AuthType)authType), radiusAuthHandler);
        }
        log.info("Success to init radius auth dispatcher, num = {}, invokes = {}", (Object)invokes.size(), invokes);
        return invokes;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        this.applicationContext = applicationContext;
    }
}

