/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.cache;

import com.tplink.cdd.component.aaa.core.authentication.eap.enums.CurrentState;
import com.tplink.cdd.component.aaa.core.authentication.eap.tunnel.TunnelAuthenticator;
import com.tplink.cdd.radius.common.tls.CipherSuite.TlsCipher;
import com.tplink.cdd.radius.common.tls.dto.SecurityParameters;
import com.tplink.cdd.radius.common.tls.enums.CipherSuite;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;

public class UserEapCacheInfo {
    private CurrentState currentState;
    private EapMd5Info eapMd5Info;
    private EapTlsInfo eapTlsInfo;
    private TunnelAuthenticator tunnelAuthenticator;
    private String tunnelUsername;
    private String password;
    private String groupId;

    public static UserEapCacheInfoBuilder builder() {
        return new UserEapCacheInfoBuilder();
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    public EapMd5Info getEapMd5Info() {
        return this.eapMd5Info;
    }

    public EapTlsInfo getEapTlsInfo() {
        return this.eapTlsInfo;
    }

    public TunnelAuthenticator getTunnelAuthenticator() {
        return this.tunnelAuthenticator;
    }

    public String getTunnelUsername() {
        return this.tunnelUsername;
    }

    public String getPassword() {
        return this.password;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setCurrentState(CurrentState currentState) {
        this.currentState = currentState;
    }

    public void setEapMd5Info(EapMd5Info eapMd5Info) {
        this.eapMd5Info = eapMd5Info;
    }

    public void setEapTlsInfo(EapTlsInfo eapTlsInfo) {
        this.eapTlsInfo = eapTlsInfo;
    }

    public void setTunnelAuthenticator(TunnelAuthenticator tunnelAuthenticator) {
        this.tunnelAuthenticator = tunnelAuthenticator;
    }

    public void setTunnelUsername(String tunnelUsername) {
        this.tunnelUsername = tunnelUsername;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String toString() {
        return "UserEapCacheInfo(currentState=" + (Object)((Object)this.getCurrentState()) + ", eapMd5Info=" + this.getEapMd5Info() + ", eapTlsInfo=" + this.getEapTlsInfo() + ", tunnelAuthenticator=" + this.getTunnelAuthenticator() + ", tunnelUsername=" + this.getTunnelUsername() + ", password=" + this.getPassword() + ", groupId=" + this.getGroupId() + ")";
    }

    public UserEapCacheInfo() {
    }

    public UserEapCacheInfo(CurrentState currentState, EapMd5Info eapMd5Info, EapTlsInfo eapTlsInfo, TunnelAuthenticator tunnelAuthenticator, String tunnelUsername, String password, String groupId) {
        this.currentState = currentState;
        this.eapMd5Info = eapMd5Info;
        this.eapTlsInfo = eapTlsInfo;
        this.tunnelAuthenticator = tunnelAuthenticator;
        this.tunnelUsername = tunnelUsername;
        this.password = password;
        this.groupId = groupId;
    }

    public static class UserEapCacheInfoBuilder {
        private CurrentState currentState;
        private EapMd5Info eapMd5Info;
        private EapTlsInfo eapTlsInfo;
        private TunnelAuthenticator tunnelAuthenticator;
        private String tunnelUsername;
        private String password;
        private String groupId;

        UserEapCacheInfoBuilder() {
        }

        public UserEapCacheInfoBuilder currentState(CurrentState currentState) {
            this.currentState = currentState;
            return this;
        }

        public UserEapCacheInfoBuilder eapMd5Info(EapMd5Info eapMd5Info) {
            this.eapMd5Info = eapMd5Info;
            return this;
        }

        public UserEapCacheInfoBuilder eapTlsInfo(EapTlsInfo eapTlsInfo) {
            this.eapTlsInfo = eapTlsInfo;
            return this;
        }

        public UserEapCacheInfoBuilder tunnelAuthenticator(TunnelAuthenticator tunnelAuthenticator) {
            this.tunnelAuthenticator = tunnelAuthenticator;
            return this;
        }

        public UserEapCacheInfoBuilder tunnelUsername(String tunnelUsername) {
            this.tunnelUsername = tunnelUsername;
            return this;
        }

        public UserEapCacheInfoBuilder password(String password) {
            this.password = password;
            return this;
        }

        public UserEapCacheInfoBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public UserEapCacheInfo build() {
            return new UserEapCacheInfo(this.currentState, this.eapMd5Info, this.eapTlsInfo, this.tunnelAuthenticator, this.tunnelUsername, this.password, this.groupId);
        }

        public String toString() {
            return "UserEapCacheInfo.UserEapCacheInfoBuilder(currentState=" + (Object)((Object)this.currentState) + ", eapMd5Info=" + this.eapMd5Info + ", eapTlsInfo=" + this.eapTlsInfo + ", tunnelAuthenticator=" + this.tunnelAuthenticator + ", tunnelUsername=" + this.tunnelUsername + ", password=" + this.password + ", groupId=" + this.groupId + ")";
        }
    }

    public static class EapTlsInfo {
        private Integer version;
        private CipherSuite cipherSuite;
        private byte[] sessionId;
        private SecurityParameters securityParameters;
        private List<ByteBuf> respFragmentList;
        private List<ByteBuf> reqFragmentList;
        private ByteBuf clientHelloStageHsData;
        private ByteBuf serverHelloStageHsData;
        private TlsCipher tlsCipher;
        private Integer serverHelloLength;

        public static EapTlsInfoBuilder builder() {
            return new EapTlsInfoBuilder();
        }

        public Integer getVersion() {
            return this.version;
        }

        public CipherSuite getCipherSuite() {
            return this.cipherSuite;
        }

        public byte[] getSessionId() {
            return this.sessionId;
        }

        public SecurityParameters getSecurityParameters() {
            return this.securityParameters;
        }

        public List<ByteBuf> getRespFragmentList() {
            return this.respFragmentList;
        }

        public List<ByteBuf> getReqFragmentList() {
            return this.reqFragmentList;
        }

        public ByteBuf getClientHelloStageHsData() {
            return this.clientHelloStageHsData;
        }

        public ByteBuf getServerHelloStageHsData() {
            return this.serverHelloStageHsData;
        }

        public TlsCipher getTlsCipher() {
            return this.tlsCipher;
        }

        public Integer getServerHelloLength() {
            return this.serverHelloLength;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public void setCipherSuite(CipherSuite cipherSuite) {
            this.cipherSuite = cipherSuite;
        }

        public void setSessionId(byte[] sessionId) {
            this.sessionId = sessionId;
        }

        public void setSecurityParameters(SecurityParameters securityParameters) {
            this.securityParameters = securityParameters;
        }

        public void setRespFragmentList(List<ByteBuf> respFragmentList) {
            this.respFragmentList = respFragmentList;
        }

        public void setReqFragmentList(List<ByteBuf> reqFragmentList) {
            this.reqFragmentList = reqFragmentList;
        }

        public void setClientHelloStageHsData(ByteBuf clientHelloStageHsData) {
            this.clientHelloStageHsData = clientHelloStageHsData;
        }

        public void setServerHelloStageHsData(ByteBuf serverHelloStageHsData) {
            this.serverHelloStageHsData = serverHelloStageHsData;
        }

        public void setTlsCipher(TlsCipher tlsCipher) {
            this.tlsCipher = tlsCipher;
        }

        public void setServerHelloLength(Integer serverHelloLength) {
            this.serverHelloLength = serverHelloLength;
        }

        public String toString() {
            return "UserEapCacheInfo.EapTlsInfo(version=" + this.getVersion() + ", cipherSuite=" + this.getCipherSuite() + ", sessionId=" + Arrays.toString(this.getSessionId()) + ", securityParameters=" + this.getSecurityParameters() + ", respFragmentList=" + this.getRespFragmentList() + ", reqFragmentList=" + this.getReqFragmentList() + ", clientHelloStageHsData=" + this.getClientHelloStageHsData() + ", serverHelloStageHsData=" + this.getServerHelloStageHsData() + ", tlsCipher=" + this.getTlsCipher() + ", serverHelloLength=" + this.getServerHelloLength() + ")";
        }

        public EapTlsInfo() {
        }

        public EapTlsInfo(Integer version, CipherSuite cipherSuite, byte[] sessionId, SecurityParameters securityParameters, List<ByteBuf> respFragmentList, List<ByteBuf> reqFragmentList, ByteBuf clientHelloStageHsData, ByteBuf serverHelloStageHsData, TlsCipher tlsCipher, Integer serverHelloLength) {
            this.version = version;
            this.cipherSuite = cipherSuite;
            this.sessionId = sessionId;
            this.securityParameters = securityParameters;
            this.respFragmentList = respFragmentList;
            this.reqFragmentList = reqFragmentList;
            this.clientHelloStageHsData = clientHelloStageHsData;
            this.serverHelloStageHsData = serverHelloStageHsData;
            this.tlsCipher = tlsCipher;
            this.serverHelloLength = serverHelloLength;
        }

        public static class EapTlsInfoBuilder {
            private Integer version;
            private CipherSuite cipherSuite;
            private byte[] sessionId;
            private SecurityParameters securityParameters;
            private List<ByteBuf> respFragmentList;
            private List<ByteBuf> reqFragmentList;
            private ByteBuf clientHelloStageHsData;
            private ByteBuf serverHelloStageHsData;
            private TlsCipher tlsCipher;
            private Integer serverHelloLength;

            EapTlsInfoBuilder() {
            }

            public EapTlsInfoBuilder version(Integer version) {
                this.version = version;
                return this;
            }

            public EapTlsInfoBuilder cipherSuite(CipherSuite cipherSuite) {
                this.cipherSuite = cipherSuite;
                return this;
            }

            public EapTlsInfoBuilder sessionId(byte[] sessionId) {
                this.sessionId = sessionId;
                return this;
            }

            public EapTlsInfoBuilder securityParameters(SecurityParameters securityParameters) {
                this.securityParameters = securityParameters;
                return this;
            }

            public EapTlsInfoBuilder respFragmentList(List<ByteBuf> respFragmentList) {
                this.respFragmentList = respFragmentList;
                return this;
            }

            public EapTlsInfoBuilder reqFragmentList(List<ByteBuf> reqFragmentList) {
                this.reqFragmentList = reqFragmentList;
                return this;
            }

            public EapTlsInfoBuilder clientHelloStageHsData(ByteBuf clientHelloStageHsData) {
                this.clientHelloStageHsData = clientHelloStageHsData;
                return this;
            }

            public EapTlsInfoBuilder serverHelloStageHsData(ByteBuf serverHelloStageHsData) {
                this.serverHelloStageHsData = serverHelloStageHsData;
                return this;
            }

            public EapTlsInfoBuilder tlsCipher(TlsCipher tlsCipher) {
                this.tlsCipher = tlsCipher;
                return this;
            }

            public EapTlsInfoBuilder serverHelloLength(Integer serverHelloLength) {
                this.serverHelloLength = serverHelloLength;
                return this;
            }

            public EapTlsInfo build() {
                return new EapTlsInfo(this.version, this.cipherSuite, this.sessionId, this.securityParameters, this.respFragmentList, this.reqFragmentList, this.clientHelloStageHsData, this.serverHelloStageHsData, this.tlsCipher, this.serverHelloLength);
            }

            public String toString() {
                return "UserEapCacheInfo.EapTlsInfo.EapTlsInfoBuilder(version=" + this.version + ", cipherSuite=" + this.cipherSuite + ", sessionId=" + Arrays.toString(this.sessionId) + ", securityParameters=" + this.securityParameters + ", respFragmentList=" + this.respFragmentList + ", reqFragmentList=" + this.reqFragmentList + ", clientHelloStageHsData=" + this.clientHelloStageHsData + ", serverHelloStageHsData=" + this.serverHelloStageHsData + ", tlsCipher=" + this.tlsCipher + ", serverHelloLength=" + this.serverHelloLength + ")";
            }
        }
    }

    public static class EapMd5Info {
        private byte[] checkValue;

        public static EapMd5InfoBuilder builder() {
            return new EapMd5InfoBuilder();
        }

        public byte[] getCheckValue() {
            return this.checkValue;
        }

        public void setCheckValue(byte[] checkValue) {
            this.checkValue = checkValue;
        }

        public String toString() {
            return "UserEapCacheInfo.EapMd5Info(checkValue=" + Arrays.toString(this.getCheckValue()) + ")";
        }

        public EapMd5Info() {
        }

        public EapMd5Info(byte[] checkValue) {
            this.checkValue = checkValue;
        }

        public static class EapMd5InfoBuilder {
            private byte[] checkValue;

            EapMd5InfoBuilder() {
            }

            public EapMd5InfoBuilder checkValue(byte[] checkValue) {
                this.checkValue = checkValue;
                return this;
            }

            public EapMd5Info build() {
                return new EapMd5Info(this.checkValue);
            }

            public String toString() {
                return "UserEapCacheInfo.EapMd5Info.EapMd5InfoBuilder(checkValue=" + Arrays.toString(this.checkValue) + ")";
            }
        }
    }
}

