/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.cache;

import com.tplink.cdd.component.aaa.core.authentication.cache.AbstractCacheService;
import com.tplink.cdd.component.aaa.core.authentication.cache.UserEapCacheInfo;
import com.tplink.cdd.component.aaa.server.utils.CustomPIIMaskUtil;
import com.tplink.cdd.component.aaa.utils.StringUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class UserCache
extends AbstractCacheService {
    private static final Logger log = LoggerFactory.getLogger(UserCache.class);
    @Value(value="${aaa.cache.user-eap-cache-info-exp-secs}")
    protected Long userEapCacheInfoExpSecs;
    private static final String AUTH_MODULE_PREFIX = "aaa:authentication";
    private static final String EAP_PREFIX = "eap";
    private static final String AUTH_RULE_PREFIX = "auth-rule";
    private static final String DEFAULT_MAC = "000000000000";

    public UserEapCacheInfo getUserEapCacheInfo(String nasMac, String clientMac) {
        return super.get(this.userEapCacheKey(nasMac, clientMac), UserEapCacheInfo.class);
    }

    public void setUserEapCacheInfo(String nasMac, String clientMac, UserEapCacheInfo userEapCacheInfo) {
        super.set(this.userEapCacheKey(nasMac, clientMac), userEapCacheInfo, this.userEapCacheInfoExpSecs, TimeUnit.SECONDS);
        log.debug("Success to store user eap info into cache, nasMac = {}", (Object)CustomPIIMaskUtil.hash(nasMac));
    }

    public void removeUserEapCacheInfo(String nasMac, String clientMac) {
        super.remove(this.userEapCacheKey(nasMac, clientMac));
        log.debug("Success to remove user eap cache info from cache, nasMac = {}", (Object)CustomPIIMaskUtil.hash(nasMac));
    }

    protected String userEapCacheKey(String nasMac, String clientMac) {
        return StringUtil.isEmpty(clientMac) ? this.generateKey(String.join((CharSequence)":", nasMac, AUTH_MODULE_PREFIX), EAP_PREFIX) : this.generateKey(String.join((CharSequence)":", nasMac, AUTH_MODULE_PREFIX), clientMac, EAP_PREFIX);
    }
}

