/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.authentication.cache;

import com.tplink.smb.component.cache.api.CacheService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractCacheService {
    @Value(value="${aaa.cache.cache-name}")
    private String cacheName;
    protected static final String SEPARATOR = ":";
    @Autowired
    private CacheService cacheService;

    protected String generateKey(String modulePrefix, String ... values) {
        return String.join((CharSequence)SEPARATOR, modulePrefix, String.join((CharSequence)SEPARATOR, values));
    }

    protected <T> T get(String key, Class<T> clazz) {
        return (T)this.cacheService.get(this.cacheName, key, clazz);
    }

    protected <T> void set(String key, T value, Long expireTime, TimeUnit timeUnit) {
        this.cacheService.set(this.cacheName, key, value, expireTime.longValue(), timeUnit);
    }

    protected void remove(String key) {
        this.cacheService.deleteKey(this.cacheName, key);
    }
}

