/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.component.aaa.core.accounting.accounting;

import com.tplink.cdd.component.aaa.core.accounting.annotation.AccountingHandler;
import com.tplink.cdd.component.aaa.core.enums.RadiusAccountingStatusType;
import com.tplink.cdd.component.aaa.server.api.RadiusAccountingHandler;
import com.tplink.nbu.common.utils.JacksonUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@Configuration
public class AccountingConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AccountingConfig.class);
    private ApplicationContext applicationContext;

    @Bean(value={"radiusAccountingHandler"})
    public Map<RadiusAccountingStatusType, RadiusAccountingHandler> initRadiusAccountingHandler() {
        ConcurrentHashMap<RadiusAccountingStatusType, RadiusAccountingHandler> invokes = new ConcurrentHashMap<RadiusAccountingStatusType, RadiusAccountingHandler>();
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(AccountingHandler.class);
        for (Map.Entry entry : beansWithAnnotation.entrySet()) {
            RadiusAccountingHandler handler = (RadiusAccountingHandler)entry.getValue();
            AccountingHandler annotation = handler.getClass().getAnnotation(AccountingHandler.class);
            RadiusAccountingStatusType value = annotation.value();
            invokes.put(value, handler);
        }
        log.info("Success to init radius accounting handler, num = {}, invokes = {}", (Object)invokes.size(), (Object)JacksonUtil.parseToStr(invokes));
        return invokes;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        this.applicationContext = applicationContext;
    }
}

