/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.start.modules;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ScrollBarUI
extends BasicScrollBarUI {
    @Override
    protected void configureScrollBarColors() {
        if (this.scrollbar.getOrientation() == 1) {
            this.trackColor = Color.WHITE;
            this.setThumbBounds(0, 0, 3, 10);
        }
        if (this.scrollbar.getOrientation() == 0) {
            this.trackColor = Color.WHITE;
            this.setThumbBounds(0, 0, 10, 3);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            c.setPreferredSize(new Dimension(6, 0));
        }
        if (this.scrollbar.getOrientation() == 0) {
            c.setPreferredSize(new Dimension(0, 6));
        }
        return super.getPreferredSize(c);
    }

    @Override
    public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint gp = null;
        if (this.scrollbar.getOrientation() == 1) {
            gp = new GradientPaint(0.0f, 0.0f, Color.WHITE, trackBounds.width, 0.0f, Color.WHITE);
        }
        if (this.scrollbar.getOrientation() == 0) {
            gp = new GradientPaint(0.0f, 0.0f, Color.WHITE, trackBounds.width, 0.0f, Color.WHITE);
        }
        g2.setPaint(gp);
        g2.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(g);
        }
        if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(g);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        g.translate(thumbBounds.x, thumbBounds.y);
        g.setColor(new Color(216, 216, 216));
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(rh);
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.scrollbar.getOrientation() == 1) {
            g2.fillRoundRect(0, 0, 40, thumbBounds.height - 1, 5, 5);
        }
        if (this.scrollbar.getOrientation() == 0) {
            g2.fillRoundRect(0, 0, thumbBounds.width - 1, 40, 5, 5);
        }
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setBorder(null);
        return button;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setFocusable(false);
        button.setBorder(null);
        return button;
    }
}

