/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.start.modules;

import com.sun.jna.platform.WindowUtils;
import com.tplink.smb.facade.core.conf.ConfigurationFactory;
import com.tplink.smb.facade.core.constant.MessageStyle;
import com.tplink.smb.facade.start.config.GlobalConfig;
import com.tplink.smb.facade.start.config.MainPanelConfig;
import com.tplink.smb.facade.start.modules.BasicButton;
import com.tplink.smb.facade.start.modules.BasicFrame;
import com.tplink.smb.facade.start.modules.ConfirmPanel;
import com.tplink.smb.facade.start.modules.LaunchFailurePanel;
import com.tplink.smb.facade.start.modules.ProgressUI;
import com.tplink.smb.facade.start.modules.RoundBorder;
import com.tplink.smb.facade.start.modules.RoundButton;
import com.tplink.smb.facade.start.modules.ScrollBarUI;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Shape;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MainPanel
extends BasicFrame {
    private static final Logger log = LoggerFactory.getLogger(MainPanel.class);
    private static final MainPanel INSTANCE = new MainPanel();
    private final JLabel titleImage = new JLabel();
    private final JLabel titleMsg = new JLabel();
    private final JLabel centerImage = new JLabel();
    private final BasicButton miniBtn = new BasicButton();
    private final BasicButton closeBtn = new BasicButton();
    private final JScrollPane jScrollPane = new JScrollPane();
    private final RoundButton launchButton = new RoundButton("Launch", new Color(20, 209, 136), new Color(20, 209, 136));
    private final JProgressBar progressBar = new JProgressBar(){

        @Override
        public void setUI(ProgressBarUI ui) {
            super.setUI(new ProgressUI(this, new Color(0, 168, 112)));
        }
    };
    private final JTextPane detailMsg = new JTextPane();
    private final transient JLabel progressMsg = new JLabel();
    private final Integer WAITING_PROGRESS_VALUE = 90;
    private final transient ExecutorService singleExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private final SimpleAttributeSet defaultSimpleAttributeSet = new SimpleAttributeSet();
    private transient TrayIcon trayIcon;
    private String url;
    private String startedString;
    private String failedString;
    private String titleString;
    private Integer startTotalTime;
    private String fontUrl;
    private String fileName;
    private transient ProgressBarTask progressBarTask;

    private MainPanel() {
    }

    public static MainPanel getInstance() {
        return INSTANCE;
    }

    public void initUI(String fileName) {
        int[] detailMsgPoint;
        String initializingString;
        this.fileName = fileName;
        this.conf = ConfigurationFactory.loadEmbedConfiguration((String)fileName);
        if (Objects.isNull(this.conf)) {
            log.warn("No properties for facade, default properties are going to be applied.");
        }
        this.fontUrl = this.conf == null ? "/font/TP-LinkAktiv.ttf" : Optional.ofNullable(this.conf.getProperty("font.url")).orElse("/font/TP-LinkAktiv.ttf");
        String programName = this.conf == null ? "DPMS" : Optional.ofNullable(this.conf.getProperty("program.name")).orElse("DPMS");
        String programVersion = this.conf == null ? "Version" : Optional.ofNullable(this.conf.getProperty("program.version")).orElse("Version");
        this.setTitle(programName);
        if (this.conf != null) {
            initializingString = Optional.ofNullable(this.conf.getProperty("mainPanel.progressMsg.string.initializing")).orElse("Initializing " + programName + " " + programVersion + " ...");
            this.startedString = Optional.ofNullable(this.conf.getProperty("mainPanel.progressMsg.string.started")).orElse(programName + " " + programVersion + " Started");
            this.failedString = Optional.ofNullable(this.conf.getProperty("mainPanel.progressMsg.string.failed")).orElse(programName + " " + programVersion + " Launch Failed");
            this.titleString = Optional.ofNullable(this.conf.getProperty("mainPanel.titleMsg.string")).orElse(programName + " " + programVersion + " - TP-Link");
        } else {
            initializingString = "Initializing " + programName + " " + programVersion + "...";
            this.startedString = programName + " " + programVersion + " Started";
            this.failedString = programName + " " + programVersion + " Launch Failed";
            this.titleString = programName + " " + programVersion + " - TP-Link";
        }
        this.url = this.conf == null ? "http://localhost:8081/index.html" : Optional.ofNullable(this.conf.getProperty("launch.url")).orElse("http://localhost:8081/index.html");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MainPanel.this.xOld = e.getX();
                MainPanel.this.yOld = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int xOnScreen = e.getXOnScreen();
                int yOnScreen = e.getYOnScreen();
                int xx = xOnScreen - MainPanel.this.xOld;
                int yy = yOnScreen - MainPanel.this.yOld;
                MainPanel.this.setLocation(xx, yy);
            }
        });
        this.jPanel.setLayout(null);
        this.jPanel.setBackground(Color.WHITE);
        try {
            this.startTotalTime = this.conf == null ? GlobalConfig.LAUNCH_TOTAL_TIME : Integer.valueOf(Integer.parseInt(this.conf.getProperty("launch.totalTime")));
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value of launchTotalTime, default value: {} has been adopted", (Object)GlobalConfig.LAUNCH_TOTAL_TIME);
            this.startTotalTime = GlobalConfig.LAUNCH_TOTAL_TIME;
        }
        try {
            ImageIcon imageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/dpms-icon-edit.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("iconImage.url")).orElse("/images/dpms-icon-edit.png"))));
            ImageIcon centerImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/dpms-center.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("mainPanel.centerImage.url")).orElse("/images/dpms-center.png"))));
            ImageIcon closeImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-close.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("mainPanel.closeImage.url")).orElse("/images/window-close.png"))));
            ImageIcon closeImageInIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-in-close.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("mainPanel.closeInImage.url")).orElse("/images/window-in-close.png"))));
            ImageIcon titleImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/tp-link-black.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("mainPanel.titleImage.url")).orElse("/images/tp-link-black.png"))));
            ImageIcon trayImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/dpms-icon-mini-edit.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("trayImage.url")).orElse("/images/dpms-icon-mini-edit.png"))));
            ImageIcon miniImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-mini.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("mainPanel.miniImage.url")).orElse("/images/window-mini.png"))));
            ImageIcon miniImageInIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-in-mini.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("mainPanel.miniInImage.url")).orElse("/images/window-in-mini.png"))));
            this.trayIcon = new TrayIcon(trayImageIcon.getImage());
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            double scaleX = (double)Toolkit.getDefaultToolkit().getScreenSize().width / (double)gd.getDisplayMode().getWidth();
            double scaleY = (double)Toolkit.getDefaultToolkit().getScreenSize().height / (double)gd.getDisplayMode().getHeight();
            double rate = Math.min(scaleX, scaleY);
            log.info("screen rate:{}", (Object)rate);
            log.info("screen size init x:{}, screen size init y;{}", (Object)Toolkit.getDefaultToolkit().getScreenSize().width, (Object)Toolkit.getDefaultToolkit().getScreenSize().height);
            int x = (int)((double)MainPanelConfig.WIDTH.intValue() / rate);
            int y = (int)((double)MainPanelConfig.HEIGHT.intValue() / rate);
            this.setSize(x, y);
            log.info("MainPanel init x:{}, MainPanel init y;{}", (Object)x, (Object)y);
            this.setLocationRelativeTo(null);
            this.setIconImage(imageIcon.getImage());
            this.setProgressBar();
            this.setLaunchButton();
            this.setMiniBtn(miniImageIcon, miniImageInIcon);
            this.setTitleMsg();
            this.setCenterImage(centerImageIcon);
            this.setCloseBtn(closeImageIcon, closeImageInIcon, this.trayIcon);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.setProgressMsg(initializingString);
        this.setDetailMsg();
        int[] nArray = detailMsgPoint = this.conf == null ? this.getParams("50, 330, 440, 100", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.detailMsg.point")).orElse("50, 330, 440, 100"), 4);
        if (detailMsgPoint == null) {
            log.warn("detailMsg' point is invalid format!");
            detailMsgPoint = this.getParams("50, 330, 440, 100", 4);
        }
        this.setJScrollPane(detailMsgPoint);
        try {
            this.setTrayIcon();
        }
        catch (AWTException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        int[] mainPagePoint = this.getParams("0, 0, 540, 460", 4);
        this.jPanel.setBounds(mainPagePoint[0], mainPagePoint[1], mainPagePoint[2], mainPagePoint[3]);
        this.jPanel.add(this.titleImage);
        this.jPanel.add(this.titleMsg);
        this.jPanel.add(this.miniBtn);
        this.jPanel.add(this.closeBtn);
        this.jPanel.add(this.centerImage);
        this.jPanel.add(this.progressMsg);
        this.jPanel.add(this.progressBar);
        this.jPanel.add(this.launchButton);
        this.jPanel.add(this.jScrollPane);
        this.setContentPane(this.jPanel);
        this.setUndecorated(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        RoundRectangle2D.Float mask = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 10.0f, 10.0f);
        WindowUtils.setWindowMask((Window)this, (Shape)mask);
        this.jPanel.setBorder(BorderFactory.createLineBorder(new Color(240, 240, 240)));
    }

    public void writeMessage(String string) {
        this.writeMessage(string, null);
    }

    public void writeMessage(String string, MessageStyle messageStyle) {
        if (StringUtils.isEmpty((Object)string)) {
            log.error("Empty message is not allowed to be displayed in details area.");
            return;
        }
        Document document = this.detailMsg.getDocument();
        if (Objects.isNull(messageStyle)) {
            try {
                document.insertString(document.getLength(), string, this.defaultSimpleAttributeSet);
            }
            catch (BadLocationException e) {
                log.error("BadLocationException: " + e, (Throwable)e);
            }
        } else {
            SimpleAttributeSet simpleAttributeSet = this.getAttributeSet(messageStyle);
            try {
                document.insertString(document.getLength(), string, simpleAttributeSet);
            }
            catch (BadLocationException e) {
                log.error("BadLocationException: " + e, (Throwable)e);
            }
        }
    }

    private void setDefaultAttributeSet() {
        Font font = this.getDefinedFont(0, MainPanelConfig.DETAIL_MSG_FONT_SIZE.intValue(), this.fontUrl);
        StyleConstants.setFontFamily(this.defaultSimpleAttributeSet, font.getFamily());
        StyleConstants.setFontSize(this.defaultSimpleAttributeSet, MainPanelConfig.DETAIL_MSG_FONT_SIZE);
        StyleConstants.setBold(this.defaultSimpleAttributeSet, false);
        StyleConstants.setItalic(this.defaultSimpleAttributeSet, false);
        StyleConstants.setUnderline(this.defaultSimpleAttributeSet, false);
        int[] detailMsgColor = this.conf == null ? this.getParams("116, 116, 116", 3) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.detailMsg.font.color")).orElse("116, 116, 116"), 3);
        StyleConstants.setForeground(this.defaultSimpleAttributeSet, new Color(detailMsgColor[0], detailMsgColor[1], detailMsgColor[2]));
        StyleConstants.setBackground(this.defaultSimpleAttributeSet, Color.WHITE);
        StyleConstants.setAlignment(this.defaultSimpleAttributeSet, 0);
    }

    private SimpleAttributeSet getAttributeSet(MessageStyle messageStyle) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Font font = this.getDefinedFont(0, MainPanelConfig.DETAIL_MSG_FONT_SIZE.intValue(), this.fontUrl);
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, messageStyle.getFontSize());
        StyleConstants.setBold(simpleAttributeSet, messageStyle.getBold());
        StyleConstants.setItalic(simpleAttributeSet, messageStyle.getItalic());
        StyleConstants.setUnderline(simpleAttributeSet, messageStyle.getUnderline());
        StyleConstants.setForeground(simpleAttributeSet, messageStyle.getForeground());
        StyleConstants.setBackground(simpleAttributeSet, messageStyle.getBackground());
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        return simpleAttributeSet;
    }

    private void openUrl(String url) {
        URI uri = URI.create(url);
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uri);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void startProgress(JProgressBar jProgressBar, Integer startTotalTime) {
        if (startTotalTime == 0) {
            this.progressBarTask = new ProgressBarTask(jProgressBar);
        } else {
            int sleepTime = startTotalTime / this.WAITING_PROGRESS_VALUE;
            this.progressBarTask = new ProgressBarTask(sleepTime, jProgressBar);
        }
        this.singleExecutorService.submit(this.progressBarTask);
    }

    private void setMiniBtn(ImageIcon miniImageIcon, ImageIcon miniInImageIcon) {
        this.miniBtn.setIcon(miniImageIcon);
        this.miniBtn.setBackground(new Color(255, 255, 255));
        int[] miniBtnPoint = this.conf == null ? this.getParams("466, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.miniImage.point")).orElse("466, 10, 24, 24"), 4);
        int[] miniInBtnPoint = this.conf == null ? this.getParams("466, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.miniInImage.point")).orElse("466, 10, 24, 24"), 4);
        this.miniBtn.setBounds(miniBtnPoint[0], miniBtnPoint[1], miniBtnPoint[2], miniBtnPoint[3]);
        this.miniBtn.addActionListener(e -> {
            INSTANCE.setExtendedState(1);
            INSTANCE.setVisible(false);
        });
        MouseAdapter miniBtnAdapter = this.getBtnMouseAdapter(this.miniBtn, miniInImageIcon, miniImageIcon, miniInBtnPoint, miniBtnPoint);
        this.miniBtn.addMouseListener(miniBtnAdapter);
    }

    private void setTitleImage(ImageIcon titleImageIcon) {
        this.titleImage.setIcon(titleImageIcon);
        int[] titleImagePoint = this.conf == null ? this.getParams("24, 11, 63, 23", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.titleImage.point")).orElse("24, 11, 63, 23"), 4);
        this.titleImage.setBounds(titleImagePoint[0], titleImagePoint[1], titleImagePoint[2], titleImagePoint[3]);
    }

    private void setCenterImage(ImageIcon centerImageIcon) {
        this.centerImage.setIcon(centerImageIcon);
        int[] centerImagePoint = this.conf == null ? this.getParams("70, 64, 400, 190", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.centerImage.point")).orElse("70, 64, 400, 190"), 4);
        this.centerImage.setBounds(centerImagePoint[0], centerImagePoint[1], centerImagePoint[2], centerImagePoint[3]);
    }

    private void setTitleMsg() {
        this.titleMsg.setText(this.titleString);
        this.titleMsg.setHorizontalAlignment(0);
        this.titleMsg.setVerticalAlignment(0);
        this.titleMsg.setFont(this.getDefinedFont(0, MainPanelConfig.TITLE_MSG_FONT_SIZE.intValue(), this.fontUrl));
        this.titleMsg.setForeground(new Color(0, 0, 0));
        int[] titleMsgPoint = this.conf == null ? this.getParams("103, 11, 165, 21", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.titleMsg.point")).orElse("103, 11, 165, 21"), 4);
        this.titleMsg.setBounds(titleMsgPoint[0], titleMsgPoint[1], titleMsgPoint[2], titleMsgPoint[3]);
    }

    private void setJScrollPane(int[] detailMsgPoint) {
        this.jScrollPane.setBounds(detailMsgPoint[0], detailMsgPoint[1], detailMsgPoint[2], detailMsgPoint[3]);
        this.jScrollPane.setViewportView(this.detailMsg);
        this.jScrollPane.setBorder(null);
        this.jScrollPane.getVerticalScrollBar().setUI(new ScrollBarUI());
        this.jScrollPane.getHorizontalScrollBar().setUI(new ScrollBarUI());
    }

    private void setLaunchButton() {
        int[] launchButtonPoint = this.conf == null ? this.getParams("50, 450, 440, 40", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.launchButton.point")).orElse("50, 450, 440, 40"), 4);
        this.launchButton.setBounds(launchButtonPoint[0], launchButtonPoint[1], launchButtonPoint[2], launchButtonPoint[3]);
        this.launchButton.setBackground(new Color(0, 168, 112, 102));
        this.launchButton.setFont(this.getDefinedFont(1, MainPanelConfig.LAUNCH_BUTTON_FONT_SIZE.intValue(), this.fontUrl));
        this.launchButton.setForeground(new Color(255, 255, 255, 102));
        this.launchButton.setBorder(new RoundBorder(new Color(0, 168, 112, 102)));
        this.launchButton.setEnabled(false);
    }

    private void setProgressBar() {
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        int[] progressBarPoint = this.conf == null ? this.getParams("50, 308, 440, 6", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.progressBar.point")).orElse("50, 308, 440, 6"), 4);
        this.progressBar.setBounds(progressBarPoint[0], progressBarPoint[1], progressBarPoint[2], progressBarPoint[3]);
        this.startProgress(this.progressBar, this.startTotalTime);
    }

    private void setDetailMsg() {
        this.detailMsg.setFont(this.getDefinedFont(0, MainPanelConfig.DETAIL_MSG_FONT_SIZE.intValue(), this.fontUrl));
        this.detailMsg.setEditable(false);
        this.writeMessage("Details:\n");
        this.setDefaultAttributeSet();
    }

    private void setProgressMsg(String initializingString) {
        this.progressMsg.setText(initializingString);
        this.progressMsg.setVerticalAlignment(0);
        this.progressMsg.setHorizontalAlignment(0);
        this.progressMsg.setFont(this.getDefinedFont(0, MainPanelConfig.PROGRESS_MSG_FONT_SIZE.intValue(), this.fontUrl));
        this.progressMsg.setForeground(new Color(0, 0, 0));
        int[] progressMsgPoint = this.conf == null ? this.getParams("146, 274, 233, 22", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.progressMsg.point")).orElse("146, 274, 233, 22"), 4);
        this.progressMsg.setBounds(progressMsgPoint[0], progressMsgPoint[1], progressMsgPoint[2], progressMsgPoint[3]);
    }

    private void setCloseBtn(ImageIcon closeImageIcon, ImageIcon closeInImageIcon, TrayIcon trayIcon) {
        this.closeBtn.setIcon(closeImageIcon);
        this.closeBtn.setBackground(new Color(255, 255, 255));
        this.closeBtn.setBorderPainted(false);
        int[] closeBtnPoint = this.conf == null ? this.getParams("506, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.closeImage.point")).orElse("506, 10, 24, 24"), 4);
        int[] closeInBtnPoint = this.conf == null ? this.getParams("506, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("mainPanel.closeInImage.point")).orElse("506, 10, 24, 24"), 4);
        this.closeBtn.setBounds(closeBtnPoint[0], closeBtnPoint[1], closeBtnPoint[2], closeBtnPoint[3]);
        this.closeBtn.addActionListener(e -> {
            log.info("You have clicked the close process button of the facade component. To be confirmed or cancelled.... ");
            ConfirmPanel confirmPanel = ConfirmPanel.getInstance();
            confirmPanel.init(this.fileName, trayIcon, INSTANCE);
        });
        MouseAdapter closeMouseAdapter = this.getBtnMouseAdapter(this.closeBtn, closeInImageIcon, closeImageIcon, closeInBtnPoint, closeBtnPoint);
        this.closeBtn.addMouseListener(closeMouseAdapter);
    }

    private void setTrayIcon() throws AWTException {
        if (SystemTray.isSupported()) {
            PopupMenu popupMenu = new PopupMenu();
            String programName = this.conf == null ? "DPMS" : Optional.ofNullable(this.conf.getProperty("program.name")).orElse("DPMS");
            MenuItem openItem = new MenuItem("Show " + programName);
            MenuItem exitItem = new MenuItem("Exit");
            openItem.addActionListener(e -> {
                this.setVisible(true);
                this.setExtendedState(0);
            });
            exitItem.addActionListener(e -> {
                log.info("You have clicked the exit button on the facade component tray. To be confirmed or cancelled...");
                ConfirmPanel.getInstance().init(this.fileName, this.trayIcon, INSTANCE);
            });
            popupMenu.add(openItem);
            popupMenu.add(exitItem);
            this.trayIcon.setPopupMenu(popupMenu);
            SystemTray systemTray = SystemTray.getSystemTray();
            this.trayIcon.setToolTip(programName);
            systemTray.add(this.trayIcon);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        MainPanel.this.setExtendedState(0);
                        MainPanel.this.setVisible(true);
                    }
                }
            });
        }
    }

    public void launchFailed(String sentence) {
        this.progressMsg.setText(this.failedString);
        this.progressMsg.setForeground(Color.RED);
        this.progressBarTask.quit();
        this.progressBar.setVisible(false);
        this.singleExecutorService.shutdown();
        LaunchFailurePanel launchFailurePanel = LaunchFailurePanel.getInstance();
        launchFailurePanel.init(this.fileName, sentence);
    }

    public void taskCompleted() {
        this.progressBar.setValue(100);
        this.progressMsg.setText(this.startedString);
        this.launchButton.setEnabled(true);
        this.launchButton.addActionListener(e -> this.openUrl(this.url));
        this.launchButton.setBackground(new Color(0, 168, 112));
        this.launchButton.setForeground(new Color(255, 255, 255));
        this.launchButton.setBorder(new RoundBorder(new Color(0, 168, 112)));
        this.openUrl(this.url);
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    public void setProgressValue(int value) {
        this.progressBarTask.setProgressValue(value);
    }

    public void setLaunchUrl(String url) {
        this.url = url;
    }

    public String getLaunchUrl() {
        return this.url;
    }

    private class ProgressBarTask
    implements Runnable {
        private final int sleepTime;
        private final JProgressBar jProgressBar;
        private Boolean quitFlag = false;

        public ProgressBarTask(int sleepTime, JProgressBar jProgressBar) {
            this.sleepTime = sleepTime;
            this.jProgressBar = jProgressBar;
        }

        public ProgressBarTask(JProgressBar jProgressBar) {
            this.sleepTime = 0;
            this.jProgressBar = jProgressBar;
        }

        @Override
        public void run() {
            if (this.sleepTime != 0) {
                for (int i = 0; i < MainPanel.this.WAITING_PROGRESS_VALUE; ++i) {
                    if (Objects.equals(this.quitFlag, Boolean.TRUE)) {
                        return;
                    }
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (Objects.equals(this.jProgressBar.getValue(), 100)) {
                        return;
                    }
                    this.jProgressBar.setValue(i);
                }
            } else {
                this.jProgressBar.setValue(0);
            }
        }

        public void setProgressValue(int value) {
            this.jProgressBar.setValue(value);
        }

        public void quit() {
            this.quitFlag = true;
        }
    }
}

