/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.start.modules;

import com.sun.jna.platform.WindowUtils;
import com.tplink.smb.facade.core.conf.ConfigurationFactory;
import com.tplink.smb.facade.start.config.LaunchFailurePanelConfig;
import com.tplink.smb.facade.start.modules.BasicButton;
import com.tplink.smb.facade.start.modules.BasicDialog;
import com.tplink.smb.facade.start.modules.MainPanel;
import com.tplink.smb.facade.start.modules.RoundButton;
import com.tplink.smb.facade.start.modules.ScrollBarUI;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchFailurePanel
extends BasicDialog {
    private static final Logger log = LoggerFactory.getLogger(LaunchFailurePanel.class);
    private static final LaunchFailurePanel INSTANCE = new LaunchFailurePanel();
    private final JLabel jLabel = new JLabel();
    private final JTextArea failureMsg = new JTextArea();
    private final JScrollPane jScrollPane = new JScrollPane();
    private final RoundButton okBtn = new RoundButton("OK", new Color(20, 209, 136), new Color(20, 209, 136));
    private final BasicButton closeBtn = new BasicButton();
    private String fontUrl;

    private LaunchFailurePanel() {
    }

    public static LaunchFailurePanel getInstance() {
        return INSTANCE;
    }

    public RoundButton getOkBtn() {
        return this.okBtn;
    }

    public void init(String fileName, String sentence) {
        try {
            int[] detailMsgPoint;
            this.conf = ConfigurationFactory.loadEmbedConfiguration((String)fileName);
            if (Objects.isNull(this.conf)) {
                log.warn("No properties for facade, default properties are going to be applied.");
            }
            this.fontUrl = this.conf == null ? "/font/TP-LinkAktiv.ttf" : Optional.ofNullable(this.conf.getProperty("font.url")).orElse("/font/TP-LinkAktiv.ttf");
            ImageIcon imageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/dpms-icon-edit.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("iconImage.url")).orElse("/images/dpms-icon-edit.png"))));
            ImageIcon closeImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-close.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("launchFailurePanel.closeImage.url")).orElse("/images/window-close.png"))));
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            double scaleX = (double)Toolkit.getDefaultToolkit().getScreenSize().width / (double)gd.getDisplayMode().getWidth();
            double scaleY = (double)Toolkit.getDefaultToolkit().getScreenSize().height / (double)gd.getDisplayMode().getHeight();
            double rate = Math.min(scaleX, scaleY);
            log.info("screen rate:{}", (Object)rate);
            log.info("screen size init x:{}, screen size init y;{}", (Object)Toolkit.getDefaultToolkit().getScreenSize().width, (Object)Toolkit.getDefaultToolkit().getScreenSize().height);
            int x = (int)((double)LaunchFailurePanelConfig.WIDTH.intValue() / rate);
            int y = (int)((double)LaunchFailurePanelConfig.HEIGHT.intValue() / rate);
            this.setSize(x, y);
            log.info("LaunchFailurePanel init x:{}, LaunchFailurePanel init y;{}", (Object)x, (Object)y);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(null);
            this.setModal(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    LaunchFailurePanel.this.xOld = e.getX();
                    LaunchFailurePanel.this.yOld = e.getY();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int xOnScreen = e.getXOnScreen();
                    int yOnScreen = e.getYOnScreen();
                    int xx = xOnScreen - LaunchFailurePanel.this.xOld;
                    int yy = yOnScreen - LaunchFailurePanel.this.yOld;
                    LaunchFailurePanel.this.setLocation(xx, yy);
                }
            });
            this.jPanel.setLayout(null);
            this.jPanel.setBackground(Color.WHITE);
            this.setIconImage(imageIcon.getImage());
            this.setJLabel();
            this.setOkBtn();
            this.setCloseBtn(closeImageIcon);
            this.setFailureMsg(sentence);
            int[] nArray = detailMsgPoint = this.conf == null ? this.getParams("30, 55, 340, 75", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("launchFailurePanel.sentence2.point")).orElse("30, 55, 340, 75"), 4);
            if (detailMsgPoint == null) {
                log.warn("failure Sentence' point is invalid format!");
                detailMsgPoint = this.getParams("30, 55, 340, 75", 4);
            }
            this.setJScrollPane(detailMsgPoint);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        int[] mainPagePoint = this.getParams("0, 0, 400, 189", 4);
        this.jPanel.setBounds(mainPagePoint[0], mainPagePoint[1], mainPagePoint[2], mainPagePoint[3]);
        this.jPanel.add(this.okBtn);
        this.jPanel.add(this.jLabel);
        this.jPanel.add(this.closeBtn);
        this.jPanel.add(this.jScrollPane);
        this.jPanel.setBorder(BorderFactory.createLineBorder(new Color(240, 240, 240)));
        RoundRectangle2D.Float mask = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 10.0f, 10.0f);
        WindowUtils.setWindowMask((Window)this, (Shape)mask);
        this.setContentPane(this.jPanel);
        this.setUndecorated(true);
        this.setVisible(true);
    }

    private void setJLabel() {
        String text = this.conf == null ? "Failed to Launch DPMS!" : Optional.ofNullable(this.conf.getProperty("launchFailurePanel.sentence1.string")).orElse("Failed to Launch DPMS!");
        this.jLabel.setText(text);
        int[] sentencePoint = this.conf == null ? this.getParams("30, 30, 340, 22", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("launchFailurePanel.sentence1.point")).orElse("30, 30, 340, 22"), 4);
        this.jLabel.setBounds(sentencePoint[0], sentencePoint[1], sentencePoint[2], sentencePoint[3]);
        this.jLabel.setFont(this.getDefinedFont(0, LaunchFailurePanelConfig.SENTENCE1_FONT_SIZE.intValue(), this.fontUrl));
    }

    private void setOkBtn() {
        this.okBtn.setText(this.conf == null ? "OK" : Optional.ofNullable(this.conf.getProperty("launchFailurePanel.okBtn.text")).orElse("OK"));
        this.okBtn.setFont(this.getDefinedFont(0, LaunchFailurePanelConfig.OK_BTN_FONT_SIZE.intValue(), this.fontUrl));
        this.okBtn.setForeground(new Color(255, 255, 255));
        this.okBtn.setBackground(new Color(0, 168, 112));
        int[] okBtnPoint = this.conf == null ? this.getParams("32, 136, 62, 32", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("launchFailurePanel.okBtn.point")).orElse("32, 136, 62, 32"), 4);
        this.okBtn.setBounds(okBtnPoint[0], okBtnPoint[1], okBtnPoint[2], okBtnPoint[3]);
        this.okBtn.addActionListener(e -> INSTANCE.dispose());
    }

    private void setCloseBtn(ImageIcon closeImageIcon) {
        this.closeBtn.setIcon(closeImageIcon);
        this.closeBtn.setBackground(new Color(255, 255, 255));
        int[] closeBtnPoint = this.conf == null ? this.getParams("366, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("launchFailurePanel.closeBtn.point")).orElse("366, 10, 24, 24"), 4);
        this.closeBtn.setBounds(closeBtnPoint[0], closeBtnPoint[1], closeBtnPoint[2], closeBtnPoint[3]);
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.addActionListener(e -> INSTANCE.dispose());
        MouseAdapter closeMouseAdapter = this.getBtnMouseAdapter(this.closeBtn);
        this.closeBtn.addMouseListener(closeMouseAdapter);
    }

    private void setJScrollPane(int[] detailMsgPoint) {
        this.jScrollPane.setBounds(detailMsgPoint[0], detailMsgPoint[1], detailMsgPoint[2], detailMsgPoint[3]);
        this.jScrollPane.setViewportView(this.failureMsg);
        this.jScrollPane.setBorder(null);
        this.jScrollPane.getVerticalScrollBar().setUI(new ScrollBarUI());
        this.jScrollPane.getHorizontalScrollBar().setUI(new ScrollBarUI());
    }

    private void setFailureMsg(String sentence) {
        this.failureMsg.append(sentence + "\n");
        String string = this.conf == null ? "Please launch DPMS again after troubleshooting the problem." : Optional.ofNullable(this.conf.getProperty("launchFailurePanel.sentence2.string")).orElse("Please launch DPMS again after troubleshooting the problem.");
        this.failureMsg.append(string);
        this.failureMsg.setFont(this.getDefinedFont(0, LaunchFailurePanelConfig.SENTENCE2_FONT_SIZE.intValue(), this.fontUrl));
        this.failureMsg.setForeground(new Color(116, 116, 116));
        this.failureMsg.setEditable(false);
        this.failureMsg.setLineWrap(true);
        this.failureMsg.setWrapStyleWord(true);
    }
}

