/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.start.modules;

import com.sun.jna.platform.WindowUtils;
import com.tplink.smb.facade.core.conf.ConfigurationFactory;
import com.tplink.smb.facade.start.config.ConfirmPanelConfig;
import com.tplink.smb.facade.start.modules.BasicButton;
import com.tplink.smb.facade.start.modules.BasicDialog;
import com.tplink.smb.facade.start.modules.MainPanel;
import com.tplink.smb.facade.start.modules.RoundBorder;
import com.tplink.smb.facade.start.modules.RoundButton;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmPanel
extends BasicDialog {
    private static final Logger log = LoggerFactory.getLogger(ConfirmPanel.class);
    private static final ConfirmPanel INSTANCE = new ConfirmPanel();
    private final RoundButton minimizeBtn = new RoundButton("Minimize", new Color(235, 247, 254), new Color(216, 239, 253));
    private final RoundButton exitBtn = new RoundButton("Exit", new Color(20, 209, 136), new Color(20, 209, 136));
    private final BasicButton closeBtn = new BasicButton();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private String fontUrl;

    private ConfirmPanel() {
    }

    public static ConfirmPanel getInstance() {
        return INSTANCE;
    }

    public void init(String fileName, TrayIcon trayIcon, JFrame mainJFrame) {
        try {
            this.conf = ConfigurationFactory.loadEmbedConfiguration((String)fileName);
            if (Objects.isNull(this.conf)) {
                log.warn("No properties for facade, default properties are going to be applied.");
            }
            this.fontUrl = this.conf == null ? "/font/TP-LinkAktiv.ttf" : Optional.ofNullable(this.conf.getProperty("font.url")).orElse("/font/TP-LinkAktiv.ttf");
            String sentence1 = this.conf == null ? "Are you sure you want to close the DPMS?" : Optional.ofNullable(this.conf.getProperty("confirmPanel.sentence1.string")).orElse("Are you sure you want to close the DPMS?");
            String sentence2 = this.conf == null ? "Your devices can not be managed if you exit." : Optional.ofNullable(this.conf.getProperty("confirmPanel.sentence2.string")).orElse("Your devices can not be managed if you exit.");
            ImageIcon imageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/dpms-icon-edit.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("iconImage.url")).orElse("/images/dpms-icon-edit.png"))));
            ImageIcon closeImageIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-close.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("confirmPanel.closeImage.url")).orElse("/images/window-close.png"))));
            ImageIcon closeImageInIcon = this.conf == null ? new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream("/images/window-in-close.png"))) : new ImageIcon(ImageIO.read(MainPanel.class.getResourceAsStream(Optional.ofNullable(this.conf.getProperty("confirmPanel.closeInImage.url")).orElse("/images/window-in-close.png"))));
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            double scaleX = (double)Toolkit.getDefaultToolkit().getScreenSize().width / (double)gd.getDisplayMode().getWidth();
            double scaleY = (double)Toolkit.getDefaultToolkit().getScreenSize().height / (double)gd.getDisplayMode().getHeight();
            double rate = Math.min(scaleX, scaleY);
            log.info("screen rate:{}", (Object)rate);
            log.info("screen size init x:{}, screen size init y;{}", (Object)Toolkit.getDefaultToolkit().getScreenSize().width, (Object)Toolkit.getDefaultToolkit().getScreenSize().height);
            int x = (int)((double)ConfirmPanelConfig.WIDTH.intValue() / rate);
            int y = (int)((double)ConfirmPanelConfig.HEIGHT.intValue() / rate);
            this.setSize(x, y);
            log.info("ConfirmPanel init x:{}, ConfirmPanel init y;{}", (Object)x, (Object)y);
            this.setLocationRelativeTo(mainJFrame);
            this.setDefaultCloseOperation(2);
            this.setModal(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ConfirmPanel.this.xOld = e.getX();
                    ConfirmPanel.this.yOld = e.getY();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int xOnScreen = e.getXOnScreen();
                    int yOnScreen = e.getYOnScreen();
                    int xx = xOnScreen - ConfirmPanel.this.xOld;
                    int yy = yOnScreen - ConfirmPanel.this.yOld;
                    ConfirmPanel.this.setLocation(xx, yy);
                }
            });
            this.jPanel.setLayout(null);
            this.jPanel.setBackground(Color.WHITE);
            this.setIconImage(imageIcon.getImage());
            this.setMinimizeBtn(mainJFrame);
            this.setExitBtn(trayIcon);
            this.setCloseBtn(closeImageIcon, closeImageInIcon);
            this.setJLabel1(sentence1);
            this.setJLabel2(sentence2);
            int[] mainPagePoint = this.getParams("0, 0, 400, 189", 4);
            this.jPanel.setBounds(mainPagePoint[0], mainPagePoint[1], mainPagePoint[2], mainPagePoint[3]);
            this.jPanel.add(this.minimizeBtn);
            this.jPanel.add(this.exitBtn);
            this.jPanel.add(this.jLabel1);
            this.jPanel.add(this.jLabel2);
            this.jPanel.add(this.closeBtn);
            this.jPanel.setBorder(BorderFactory.createLineBorder(new Color(240, 240, 240)));
            RoundRectangle2D.Float mask = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 10.0f, 10.0f);
            WindowUtils.setWindowMask((Window)this, (Shape)mask);
            this.setContentPane(this.jPanel);
            this.setUndecorated(true);
            this.setVisible(true);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void setMinimizeBtn(JFrame mainJFrame) {
        this.minimizeBtn.setFont(this.getDefinedFont(0, ConfirmPanelConfig.MINIMIZE_BTN_FONT_SIZE.intValue(), this.fontUrl));
        this.minimizeBtn.setForeground(new Color(0, 168, 112));
        this.minimizeBtn.setBackground(new Color(255, 255, 255));
        this.minimizeBtn.setBorder(new RoundBorder(new Color(0, 168, 112)));
        this.minimizeBtn.setText(this.conf == null ? "Minimize" : Optional.ofNullable(this.conf.getProperty("confirmPanel.minimizeBtn.text")).orElse("Minimize"));
        int[] minimizeBtnPoint = this.conf == null ? this.getParams("116, 121, 89, 32", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("confirmPanel.minimizeBtn.point")).orElse("116, 121, 89, 32"), 4);
        this.minimizeBtn.setBounds(minimizeBtnPoint[0], minimizeBtnPoint[1], minimizeBtnPoint[2], minimizeBtnPoint[3]);
        this.minimizeBtn.addActionListener(e -> {
            INSTANCE.dispose();
            mainJFrame.setExtendedState(1);
            mainJFrame.setVisible(false);
        });
    }

    private void setExitBtn(TrayIcon trayIcon) {
        this.exitBtn.setText(this.conf == null ? "Exit" : Optional.ofNullable(this.conf.getProperty("confirmPanel.exitBtn.text")).orElse("Exit"));
        this.exitBtn.setFont(this.getDefinedFont(0, ConfirmPanelConfig.EXIT_BTN_FONT_SIZE.intValue(), this.fontUrl));
        int[] exitBtnPoint = this.conf == null ? this.getParams("30, 121, 66, 32", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("confirmPanel.exitBtn.point")).orElse("30, 121, 66, 32"), 4);
        this.exitBtn.setBounds(exitBtnPoint[0], exitBtnPoint[1], exitBtnPoint[2], exitBtnPoint[3]);
        SystemTray systemTray = SystemTray.getSystemTray();
        this.exitBtn.addActionListener(e -> {
            log.info("You have confirmed that the omada controller process has been closed... ");
            systemTray.remove(trayIcon);
            System.exit(0);
        });
        this.exitBtn.setBackground(new Color(0, 168, 112));
        this.exitBtn.setForeground(new Color(255, 255, 255));
    }

    private void setCloseBtn(ImageIcon closeImageIcon, ImageIcon closeInImageIcon) {
        this.closeBtn.setIcon(closeImageIcon);
        this.closeBtn.setBackground(new Color(255, 255, 255));
        int[] closeBtnPoint = this.conf == null ? this.getParams("366, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("confirmPanel.closeBtn.point")).orElse("366, 10, 24, 24"), 4);
        int[] closeInBtnPoint = this.conf == null ? this.getParams("366, 10, 24, 24", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("confirmPanel.closeInBtn.point")).orElse("366, 10, 24, 24"), 4);
        this.closeBtn.setBounds(closeBtnPoint[0], closeBtnPoint[1], closeBtnPoint[2], closeBtnPoint[3]);
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.addActionListener(e -> INSTANCE.dispose());
        MouseAdapter closeMouseAdapter = this.getBtnMouseAdapter(this.closeBtn, closeInImageIcon, closeImageIcon, closeInBtnPoint, closeBtnPoint);
        this.closeBtn.addMouseListener(closeMouseAdapter);
    }

    private void setJLabel1(String sentence1) {
        this.jLabel1.setText(sentence1);
        int[] sentence1Point = this.conf == null ? this.getParams("30, 30, 340, 21", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("confirmPanel.sentence1.point")).orElse("30, 30, 340, 21"), 4);
        this.jLabel1.setBounds(sentence1Point[0], sentence1Point[1], sentence1Point[2], sentence1Point[3]);
        this.jLabel1.setFont(this.getDefinedFont(0, ConfirmPanelConfig.SENTENCE1_FONT_SIZE.intValue(), this.fontUrl));
    }

    private void setJLabel2(String sentence2) {
        int[] sentence2Point;
        this.jLabel2.setText(sentence2);
        this.jLabel2.setFont(this.getDefinedFont(0, ConfirmPanelConfig.SENTENCE2_FONT_SIZE.intValue(), this.fontUrl));
        int[] nArray = sentence2Point = this.conf == null ? this.getParams("30, 61, 300, 20", 4) : this.getParams(Optional.ofNullable(this.conf.getProperty("confirmPanel.sentence2.point")).orElse("30, 61, 300, 20"), 4);
        if (sentence2Point == null) {
            log.warn("sentence2' point is invalid format!");
            sentence2Point = this.getParams("30, 61, 300, 20", 4);
        }
        this.jLabel2.setBounds(sentence2Point[0], sentence2Point[1], sentence2Point[2], sentence2Point[3]);
    }
}

