/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.start;

import com.tplink.smb.facade.core.constant.MessageStyle;
import com.tplink.smb.facade.core.model.LaunchMessageTypeEnum;
import com.tplink.smb.facade.start.modules.MainPanel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacadeMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(FacadeMessageHandler.class);
    private final MainPanel mainPanel = MainPanel.getInstance();

    private static String logValue(String logRecord) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return "[" + LocalDateTime.now().format(dateTimeFormatter) + "] " + logRecord + "\n";
    }

    public void handleMessage(LaunchMessageTypeEnum type, String message, MessageStyle messageStyle) {
        switch (type) {
            case MSG: {
                log.info(message);
                this.mainPanel.writeMessage(FacadeMessageHandler.logValue(message), messageStyle);
                break;
            }
            case ERROR: {
                log.error(message);
                this.mainPanel.writeMessage(FacadeMessageHandler.logValue(message), messageStyle);
                this.mainPanel.launchFailed(message);
                break;
            }
            case STARTED: {
                this.mainPanel.writeMessage(FacadeMessageHandler.logValue(message), messageStyle);
                this.mainPanel.taskCompleted();
                break;
            }
        }
    }

    public void handleMessage(LaunchMessageTypeEnum type, String message) {
        this.handleMessage(type, message, null);
    }
}

