/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.start;

import com.tplink.smb.facade.core.FacadeUtils;
import com.tplink.smb.facade.core.model.LaunchMessage;
import com.tplink.smb.facade.core.model.LaunchMessageTypeEnum;
import com.tplink.smb.facade.core.util.StringUtil;
import com.tplink.smb.facade.start.FacadeMessageHandler;
import com.tplink.smb.facade.start.modules.MainPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacadeApplication {
    private static final Logger log = LoggerFactory.getLogger(FacadeApplication.class);
    private static final FacadeMessageHandler MESSAGE_HANDLER = new FacadeMessageHandler();

    private FacadeApplication() {
    }

    public static void start(String fileName) {
        MainPanel.getInstance().initUI(fileName);
        Thread thread = new Thread(() -> {
            FacadeUtils.enableFacadeMsg();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LaunchMessage message = FacadeUtils.getMessage();
                    if (message == null) continue;
                    MESSAGE_HANDLER.handleMessage(message.getType(), message.getMsg(), message.getMessageStyle());
                }
                catch (Exception ex) {
                    log.error("facade-msg-thread get " + ex.getMessage(), (Throwable)ex);
                    MESSAGE_HANDLER.handleMessage(LaunchMessageTypeEnum.ERROR, "facade-msg-thread get " + ex.getMessage());
                    return;
                }
            }
            log.error("facade-msg-thread was interrupted");
            MESSAGE_HANDLER.handleMessage(LaunchMessageTypeEnum.ERROR, "facade-msg-thread was interrupted");
        }, "facade-msg-thread");
        thread.start();
    }

    public static void setProgressValue(int value) {
        if (value < 0 || value > 100) {
            log.warn("progress value is out of range of 0~100, value:{}", (Object)value);
            return;
        }
        if (value < FacadeApplication.getProgressValue()) {
            return;
        }
        MainPanel.getInstance().setProgressValue(value);
    }

    public static int getProgressValue() {
        return MainPanel.getInstance().getProgressValue();
    }

    public static void setLaunchUrl(String url) {
        if (StringUtil.isBlank((Object)url)) {
            log.warn("url is invalid");
            return;
        }
        MainPanel.getInstance().setLaunchUrl(url);
    }

    public static String getLaunchUrl() {
        return MainPanel.getInstance().getLaunchUrl();
    }
}

