/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isNotBlank(Object obj) {
        return !StringUtil.isBlank(obj);
    }

    public static boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        String str = obj.toString().trim();
        return "".equals(str) || "null".equalsIgnoreCase(str);
    }

    public static boolean hasBlank(Object obj) {
        return obj == null || obj.toString().contains(" ");
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static String getNewLine() {
        return System.getProperty("line.separator");
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String trim(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString().trim();
    }

    public static String[] splitToArray(String str, char separator) {
        List<String> result = StringUtil.split(str, separator);
        return result.toArray(new String[0]);
    }

    public static List<String> split(String str, char separator) {
        return StringUtil.split(str, separator, 0);
    }

    public static List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] splitToArray(String str, char separator, int limit) {
        List<String> result = StringUtil.split(str, separator, limit);
        return result.toArray(new String[0]);
    }

    public static String[] split(String str, String delimiter) {
        int i;
        if (str == null) {
            return new String[0];
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String[] split(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }
}

