/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.core.conf;

import com.tplink.smb.facade.core.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private final Properties originalProperties = new Properties();
    private final Map<String, String> resolvedPropertiesMap;
    private boolean isValid = false;

    public Configuration(String propertiesFileName) {
        this.resolvedPropertiesMap = new HashMap<String, String>(16);
        this.loadProperties(propertiesFileName);
    }

    public Configuration(File file) {
        this.resolvedPropertiesMap = new HashMap<String, String>();
        this.loadProperties(file);
    }

    private void loadProperties(String propertiesFileName) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (InputStream inputStream = classloader.getResourceAsStream(propertiesFileName);){
            this.originalProperties.load(inputStream);
            this.resolve();
            this.isValid = true;
        }
        catch (Exception e) {
            logger.error("load {} failed.", (Object)propertiesFileName);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadProperties(File file) {
        try (FileInputStream inpf = new FileInputStream(file);){
            this.originalProperties.load(inpf);
            this.resolve();
            this.isValid = true;
        }
        catch (IOException e) {
            logger.warn("load properties file failed .", (Throwable)e);
        }
    }

    private void resolve() {
        for (Map.Entry<Object, Object> entry : this.originalProperties.entrySet()) {
            String key = (String)entry.getKey();
            String toBeResolved = (String)entry.getValue();
            String resolved = this.resolvePlaceHolder(toBeResolved);
            if (null == resolved) {
                logger.warn("can't get resolve value for key {}", (Object)key);
                continue;
            }
            this.resolvedPropertiesMap.put(key, resolved);
        }
    }

    public String getProperty(String key) {
        String value = this.isValid ? this.resolvedPropertiesMap.get(key) : null;
        return value == null ? System.getProperty(key) : value;
    }

    public boolean getBoolProperty(String key) {
        String valueStr;
        String string = valueStr = this.isValid ? this.resolvedPropertiesMap.get(key) : null;
        if (valueStr != null) {
            return Boolean.parseBoolean(valueStr);
        }
        return false;
    }

    private String resolvePlaceHolder(String toBeResolved) {
        int start = toBeResolved.indexOf(PLACEHOLDER_PREFIX);
        if (start == -1) {
            return toBeResolved;
        }
        StringBuilder result = new StringBuilder(toBeResolved);
        while (start != -1) {
            String replaceContent;
            int end = result.indexOf(PLACEHOLDER_SUFFIX, start);
            String placeholder = result.substring(start + PLACEHOLDER_PREFIX.length(), end);
            String[] placeholderGroup = placeholder.split(":");
            String string = replaceContent = placeholder.trim().isEmpty() ? "" : this.getResolvedValue(placeholderGroup[0]);
            if (placeholderGroup.length > 1 && Objects.equals(placeholderGroup[0], replaceContent)) {
                replaceContent = placeholderGroup[1];
            }
            result.replace(start, end + PLACEHOLDER_SUFFIX.length(), replaceContent);
            start = result.indexOf(PLACEHOLDER_PREFIX, start + replaceContent.length());
        }
        String rtn = result.toString();
        return StringUtil.isEmpty(rtn) ? null : rtn;
    }

    private String getResolvedValue(String resolvedKey) {
        String resolvedValue = this.resolvedPropertiesMap.get(resolvedKey);
        if (null == resolvedValue) {
            resolvedValue = System.getProperty(resolvedKey);
            if (null != resolvedValue) {
                return resolvedValue;
            }
            String parentOriginalValue = (String)this.originalProperties.get(resolvedKey);
            if (null == parentOriginalValue) {
                return resolvedKey;
            }
            resolvedValue = this.resolvePlaceHolder(parentOriginalValue);
        }
        return resolvedValue;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

