/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.facade.core;

import com.tplink.smb.facade.core.constant.MessageStyle;
import com.tplink.smb.facade.core.model.LaunchMessage;
import com.tplink.smb.facade.core.model.LaunchMessageTypeEnum;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacadeUtils {
    private static final Logger log = LoggerFactory.getLogger(FacadeUtils.class);
    private static final int MESSAGE_QUEUE_SIZE = 1000;
    private static volatile LinkedBlockingDeque<LaunchMessage> facadeMsgQueue;
    private static volatile boolean facadeMsgEnable;

    private FacadeUtils() {
    }

    public static void enableFacadeMsg() {
        facadeMsgQueue = new LinkedBlockingDeque(1000);
        facadeMsgEnable = true;
    }

    public static boolean facadeMsgEnabled() {
        return facadeMsgEnable;
    }

    public static void sendMessage(LaunchMessageTypeEnum type, String msg) {
        FacadeUtils.sendMessage(type, msg, null);
    }

    public static void sendMessage(LaunchMessageTypeEnum type, String msg, MessageStyle messageStyle) {
        if (!facadeMsgEnable) {
            log.error("facadeMsgEnable is not enable, msg: {}", (Object)msg);
            return;
        }
        if (facadeMsgQueue == null) {
            log.error("facadeMsgQueue is null while facadeMsgEnable is {}, msg: {}", (Object)facadeMsgEnable, (Object)msg);
            return;
        }
        LaunchMessage message = new LaunchMessage(type, msg, messageStyle);
        boolean added = facadeMsgQueue.offer(message);
        if (!added) {
            log.info("Failed to put launchMessage [{}:\"{}\"] into message queue.", (Object)message.getType(), (Object)message.getMsg());
        }
    }

    public static LaunchMessage getMessage() throws InterruptedException {
        if (!facadeMsgEnable || facadeMsgQueue == null) {
            log.warn("Failed to get facade msg while facadeMsgEnable is {}", (Object)facadeMsgEnable);
            return null;
        }
        return facadeMsgQueue.take();
    }

    static {
        facadeMsgEnable = false;
    }
}

