/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.utils;

import com.tplink.smb.omada.apigateway.openapi.utils.OpenApiGetRequestIpProperties;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriTemplate;

public class OpenApiUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenApiUtils.class);
    public static final String DISPATCHER_ATTRIBUTES = "OMADA_REST_DISPATCHER_ATTRIBUTES";
    private static final String X_FORWARDED_FOR = "x-forwarded-for";
    private static final String COOKIE_HEADER_NAME = "Set-Cookie";
    private static final UriTemplate URI_TEMPLATE = new UriTemplate("/{omadacId}");

    public static RequestEntity<String> getStringRequestEntity(String reqBodyString, @Nonnull HttpServletRequest request) {
        RequestEntity<String> entity = null;
        try {
            entity = OpenApiUtils.getStringRequestEntityThrowException(reqBodyString, request);
        }
        catch (URISyntaxException e2) {
            log.warn(e2.toString(), (Throwable)e2);
        }
        return entity;
    }

    public static RequestEntity<String> getStringRequestEntityThrowException(String reqBodyString, @Nonnull HttpServletRequest request) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        Enumeration e2 = request.getHeaderNames();
        while (e2.hasMoreElements()) {
            String headerName = (String)e2.nextElement();
            headers.put(headerName, EnumerationUtils.toList((Enumeration)request.getHeaders(headerName)));
        }
        String remoteAddress = OpenApiUtils.getRemoteAddress(request);
        if (T.b((String)remoteAddress)) {
            headers.put("Omada-Remote-IP-Address", Collections.singletonList(remoteAddress));
        }
        String accessToken = OpenApiUtils.getAccessToken(request);
        log.debug("getStringRequestEntity by open api, accessToken:{}, request:{}", (Object)accessToken, (Object)request.getHeader("Authorization"));
        if (T.b((String)accessToken)) {
            headers.put("Omada-OpenApi-Access-Token", Collections.singletonList(accessToken));
        }
        RequestEntity entity = null;
        try {
            URI url = request.getQueryString() != null ? new URI(request.getRequestURL().append("?").append(request.getQueryString()).toString()) : new URI(request.getRequestURL().toString());
            entity = new RequestEntity((Object)reqBodyString, (MultiValueMap)headers, HttpMethod.valueOf((String)request.getMethod()), url, String.class);
        }
        catch (URISyntaxException e3) {
            log.warn(e3.toString(), (Throwable)e3);
        }
        return entity;
    }

    public static AttributeRequestEntity<String> getStringAttributeRequestEntityThrowException(String reqBodyString, @Nonnull HttpServletRequest request) throws URISyntaxException {
        return new AttributeRequestEntity(OpenApiUtils.getStringRequestEntityThrowException(reqBodyString, request));
    }

    public static AttributeRequestEntity<String> getStringAttributeRequestEntity(String reqBodyString, @Nonnull HttpServletRequest request) {
        return new AttributeRequestEntity(OpenApiUtils.getStringRequestEntity(reqBodyString, request));
    }

    @Nullable
    public static String getSessionId(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getId();
    }

    public static String getRemoteAddress(HttpServletRequest request) {
        OpenApiGetRequestIpProperties properties = (OpenApiGetRequestIpProperties)com.tplink.smb.omada.common.spring.a.b(OpenApiGetRequestIpProperties.class);
        if (properties != null && properties.isUseNewMethod()) {
            String remoteAddr = request.getRemoteAddr();
            log.debug("get remote addreess with check. ip: {}.", new Supplier[]{() -> a.c((String)remoteAddr)});
            if (Pattern.matches("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", remoteAddr) || Pattern.matches("(^\\S*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\S*$)", remoteAddr)) {
                return remoteAddr;
            }
            log.warn("invalid Ipv4 or Ipv6, ip: {}", (Object)a.c((String)remoteAddr));
            return null;
        }
        if (!OmadacType.s()) {
            return request.getRemoteAddr();
        }
        String ip = request.getHeader(X_FORWARDED_FOR);
        if (T.b((String)ip)) {
            log.trace("Successfully resolved IP from X-Forwarded-For: {}", (Object)ip);
            return ip.split(",")[0];
        }
        String remoteAddr = request.getRemoteAddr();
        log.debug("Failed to get IP from X-Forwarded-For: {}, using RemoteAddr from HTTP Request: {}", (Object)ip, (Object)remoteAddr);
        return remoteAddr;
    }

    public static String getAccessToken(HttpServletRequest request) {
        String accessTokenFromHeader = request.getHeader("Authorization");
        String accessTokenFromRequest = request.getParameter("Authorization");
        if (T.a((String)accessTokenFromHeader) && T.a((String)accessTokenFromRequest)) {
            return null;
        }
        String requestAccessToken = !T.c((String)accessTokenFromHeader) ? accessTokenFromHeader : accessTokenFromRequest;
        String accessToken = null;
        Map<String, String> map = OpenApiUtils.getAttributesByOpenApi(requestAccessToken);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!T.a((String)entry.getKey(), (String)"AccessToken")) continue;
            accessToken = entry.getValue();
        }
        return accessToken;
    }

    private static Map<String, String> getAttributesByOpenApi(String attributes) {
        HashMap<String, String> attr = new HashMap<String, String>();
        Matcher m2 = Pattern.compile("(\\w+)=(.*?)(?=,\\w+=|$)").matcher(attributes);
        while (m2.find()) {
            attr.put(m2.group(1), m2.group(2));
        }
        return attr;
    }

    @Generated
    private OpenApiUtils() {
    }
}

