/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.interceptor;

import com.tplink.smb.omada.apigateway.openapi.interceptor.OpenApiMeters;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.cache.a;
import com.tplink.smb.omada.common.f.b;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.ratelimit.b.d;
import com.tplink.smb.omada.ratelimit.b.e;
import com.tplink.smb.omada.ratelimit.configuration.LimiterRuleConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OpenApiRateLimiterHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiRateLimiterHandler.class);
    @Value(value="${ratelimit.http.switch:false}")
    public boolean isOpen;
    @Value(value="${ratelimit.http.urlSwitch:false}")
    public boolean urlSwitchIsOpen;
    @Value(value="${ratelimit.http.userSwitch:false}")
    public boolean userSwitchIsOpen;
    @Value(value="${ratelimit.http.omadaIdUrlSwitch:false}")
    public boolean omadaIdUrlSwitchIsOpen;
    private static final Pattern SITE_PATTERN = Pattern.compile("/sites/([^/]+)/");
    private static final String SITE_PATTERN_STRING = "/sites/siteId/";
    public static final String PRO_CAT = b.e.a();
    private final d openApiRateLimiter;
    private final d proOpenApiRateLimiter;
    private final OpenApiMeters apiMeters;
    private final com.tplink.smb.omada.manager.configuration.api.internal.omadac.a omadacCategoryApiService;
    @Autowired
    private com.tplink.smb.omada.ratelimit.c.a limiterService;
    @Autowired
    private g identityAccessInternalApiService;
    @Autowired
    private LimiterRuleConfig limiterRuleConfig;
    public static final String ADVANCED_CONTROLLER_COMMON_ID = "advanced.controller.common";

    @Autowired
    public OpenApiRateLimiterHandler(OpenApiMeters apiMeters, com.tplink.smb.omada.manager.configuration.api.internal.omadac.a omadacCategoryApiService, e omadaRateLimiterFactory) {
        this.apiMeters = apiMeters;
        this.omadacCategoryApiService = omadacCategoryApiService;
        this.openApiRateLimiter = omadaRateLimiterFactory.b("open-api");
        this.proOpenApiRateLimiter = omadaRateLimiterFactory.b("pro-open-api");
    }

    public boolean openApiPreHandle(HttpServletRequest httpServletRequest, String omadacId) {
        d omadaRateLimiter;
        String omadacIdToUse;
        boolean isPro = PRO_CAT.equals(this.omadacCategoryApiService.a(omadacId));
        if (isPro) {
            omadacIdToUse = omadacId;
            omadaRateLimiter = this.proOpenApiRateLimiter;
        } else {
            omadacIdToUse = omadacId;
            omadaRateLimiter = this.openApiRateLimiter;
        }
        if (!omadaRateLimiter.a("omadac.id:" + a.a((String)omadacIdToUse))) {
            this.apiMeters.incApiExceedLimit();
            log.warn("Failed to handle {} request for omadacId {} as reached rate limit, rateLimiter {}", new Object[]{httpServletRequest.getRequestURI(), omadacId, omadaRateLimiter});
            return false;
        }
        return true;
    }

    public boolean limitedByUrlOrUser(HttpServletRequest request, String omadacId) {
        try {
            if (!this.isOpen) {
                return false;
            }
            Object urlResourceKey = "";
            if (this.urlSwitchIsOpen) {
                String path = request.getServletPath();
                path = path.replace(omadacId, "omadacId");
                path = this.siteIdConvert(path);
                urlResourceKey = request.getMethod() + path;
                if (this.limiterRuleConfig.getResourceKeySet().contains(urlResourceKey) && this.limiterService.a((String)urlResourceKey)) {
                    log.warn("request too much, urlResourceKey:{}, url: {}", urlResourceKey, (Object)request.getServletPath());
                    return true;
                }
            }
            if (this.omadaIdUrlSwitchIsOpen) {
                String omadacIdUrlResourceKey = omadacId + (String)urlResourceKey;
                if (this.limiterRuleConfig.getResourceKeySet().contains(omadacIdUrlResourceKey) && this.limiterService.a(omadacIdUrlResourceKey)) {
                    log.warn("request too much, urlResourceKey:{}, url: {}", (Object)omadacIdUrlResourceKey, (Object)request.getServletPath());
                    return true;
                }
            }
            if (this.userSwitchIsOpen) {
                String sessionId = request.getSession().getId();
                if (StringUtil.isBlank((CharSequence)sessionId) || StringUtil.isBlank((CharSequence)omadacId)) {
                    return false;
                }
                OperationResponse currentInfo = this.identityAccessInternalApiService.a(new GetCurrentInfoDTO(sessionId, null, omadacId));
                if (Objects.isNull(currentInfo) || currentInfo.getResult() == null) {
                    return false;
                }
                String userResourceKey = ((UserDTO)currentInfo.getResult()).getId();
                if (this.limiterRuleConfig.getResourceKeySet().contains(userResourceKey) && this.limiterService.a(userResourceKey)) {
                    log.warn("request too much,urlResourceKey:{}, url: {}", (Object)userResourceKey, (Object)request.getServletPath());
                    return true;
                }
            }
        }
        catch (Exception e2) {
            log.warn("limiter handler exception", (Throwable)e2);
        }
        return false;
    }

    public String siteIdConvert(String path) {
        return SITE_PATTERN.matcher(path).replaceAll(SITE_PATTERN_STRING);
    }
}

