/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.topology;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyAvailableNetworkOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyClientOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyClientOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyClientsQueryVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyDeviceClientOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyDeviceClientsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyFilterDevicesVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyIsolatedAndPreConfigDeviceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyMultiSiteQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyRootNodeDTO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyRootOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyV3OpenApiNodeVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.topology.vo.TopologyV3OpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Topology")
@RestController
@b(a=44)
public class TopologyOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopologyOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology"})
    @ResponseBody
    @a(a=1)
    @Operation(summary="Get site topology", description="Get topology of the site with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopologyOpenApiVO>> getTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/devices/{mac}/clients"})
    @ResponseBody
    @a(a=2)
    @Operation(summary="Get the clients", description="Get the clients in topology of the device with the given omadacId , siteId and device Mac.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<TopologyClientOpenApiVO>>> getTopologyClients(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="mac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology"})
    @ResponseBody
    @a(a=3)
    @Operation(summary="Refresh site topology", description="Refresh topology of the site with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse> refreshTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/nodes"})
    @ResponseBody
    @a(a=4)
    @Operation(summary="Set site topology top node", description="Set topology top node of the site with the given omadacId, siteId and rootNode. Only three types could be set when there is no gateway\uff1aswitch\u3001olt and other. Otherwise, this method is invalid")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_WRITE, k.SITE_HOME_WRITE, k.DASHBOARD_WRITE}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse> setTopologyNode(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody TopologyRootNodeDTO topologyRootDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)topologyRootDTO), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/nodes"})
    @ResponseBody
    @a(a=5)
    @Operation(summary="Get topology nodes", description="Get the nodes in topology that can be set as topNode with the given omadacId and siteId. Only three types could be set when there is no gateway\uff1aswitch\u3001olt and other. Otherwise, this method will return empty list")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<TopologyRootOpenApiVO>>> getTopologyNodes(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/discovery/status"})
    @ResponseBody
    @a(a=6)
    @Operation(summary="Get topology discovery status", description="Get the status of whether the topology is calculating or not with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse> getTopologyDiscoveryStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(path={"/openapi/v2/{omadacId}/topology/batch"})
    @ResponseBody
    @a(a=7)
    @Operation(summary="Get multiple site topology", description="Get topology of multiple site with the given omadacId and siteIds.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    @com.tplink.smb.omada.common.a.a(a=true)
    public DeferredResult<OperationResponse<List<OperationResponse<TopologyOpenApiVO>>>> getMultiSiteTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody TopologyMultiSiteQueryOpenApiVO siteIdList) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)siteIdList), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v3/{omadacId}/sites/{siteId}/topology"})
    @ResponseBody
    @a(a=8)
    @Operation(summary="Get site topology, version 3", description="Get topology of the site with the given omadacId, siteId and deviceStatus.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.SITE_HOME_READ, k.DASHBOARD_READ, k.SITE_NETWORK_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopologyV3OpenApiVO>> getV3Topology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filters.deviceStatus", description="Filter query parameters, support field device status. 0: connected; 1: disconnected; 0,1: both.") @RequestParam(name="filters.deviceStatus", required=false) String deviceStatus) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/isolated-and-pre-config"})
    @ResponseBody
    @a(a=9)
    @Operation(summary="Get isolated and preconfigured devices", description="Get devices whose status is isolated or pre config with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.DASHBOARD_READ, k.SITE_NETWORK_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopologyIsolatedAndPreConfigDeviceOpenApiVO>> getIsolatedAndPreConfigDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/available-network"})
    @ResponseBody
    @a(a=10)
    @Operation(summary="Get available network", description="Get available wired and wireless network with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopologyAvailableNetworkOpenApiVO>> getAvailableNetworks(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/devices/{mac}/all-clients"})
    @ResponseBody
    @a(a=11)
    @Operation(summary="Get the clients by device", description="Get the clients in topology of the device with the given omadacId , siteId and device Mac.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<TopologyClientOpenApiV2VO>>> getTopologyClientsByDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="mac") String mac, @Parameter(name="filters.type", description="Filter query parameters, support field filter client group type. 0: except ipc; 1: just ipc; 0,1: all client.") @RequestParam(name="filters.type", required=true) String filterType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/devices/all-clients"})
    @ResponseBody
    @a(a=12)
    @Operation(summary="Get the clients by devices.", description="Get the clients in topology of the devices with the given omadacId , siteId and device macs.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DASHBOARD_WRITE}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<TopologyDeviceClientsOpenApiVO>>> getTopologyClientsByDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody TopologyClientsQueryVO deviceMacs) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceMacs), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/devices/{deviceMac}/device-link-topology"})
    @ResponseBody
    @a(a=13)
    @Operation(summary="Get Device Link Topology", description="Get link topology of the device with the given omadacId, siteId and deviceMac.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<TopologyV3OpenApiNodeVO>>> getDeviceLinkTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/msp/{mspId}/customers/{customerId}/sites/{siteId}/devices/{deviceMac}/device-link-topology"})
    @ResponseBody
    @a(a=14)
    @Operation(summary="Get Msp Device Link Topology", description="Get msp link topology of the device with the given mspId, siteId and deviceMac.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.MSP_DEVICES_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<TopologyV3OpenApiNodeVO>>> getMspDeviceLinkTopology(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="customerId", description="Customer ID") @PathVariable(name="customerId") String customerId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="deviceMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/search-device-client"})
    @ResponseBody
    @a(a=15)
    @Operation(summary="Search Device or Client in Topology", description="Search for devices or clients in topology with given omadacId and siteId by mac and name.")
    @com.tplink.smb.omada.common.m.a(b={k.MAP_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<GridVO<TopologyDeviceClientOpenApiVO>>> getGridDeviceClient(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field ") @RequestParam(name="searchKey") String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/ssids/{ssidId}/devices"})
    @ResponseBody
    @a(a=16)
    @Operation(summary="Search Devices of Ssid in Topology", description="Search for devices of ssid in topology with given omadacId and siteId by ssidId.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DASHBOARD_READ, k.DEVICES_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<String>>> getDevicesOfSsid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v2/{omadacId}/sites/{siteId}/topology/{networkId}/vlan/{vlan}/devices"})
    @ResponseBody
    @a(a=17)
    @Operation(summary="Search Devices of Vlan in Topology", description="Search for devices of vlan in topology with given omadacId and siteId by networkId and vlan.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<String>>> getDevicesOfVlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="networkId", description="networkId") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="vlan") @PathVariable(name="vlan") String vlan) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v3/{omadacId}/sites/{siteId}/topology/ssids/{ssidId}/devices"})
    @ResponseBody
    @a(a=18)
    @Operation(summary="Filter Devices of Ssid in Topology", description="Filter devices of ssid in topology with given omadacId and siteId by ssidId.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DASHBOARD_READ, k.DEVICES_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopologyFilterDevicesVO>> getFilterDevicesOfSsid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v3/{omadacId}/sites/{siteId}/topology/{networkId}/vlan/{vlan}/devices"})
    @ResponseBody
    @a(a=19)
    @Operation(summary="Filter Devices of Vlan in Topology", description="Filter devices of vlan in topology with given omadacId and siteId by networkId and vlan.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ, k.DASHBOARD_READ}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY})
    public DeferredResult<OperationResponse<TopologyFilterDevicesVO>> getFilterDevicesOfVlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="networkId", description="networkId") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="vlan") @PathVariable(name="vlan") String vlan) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

