/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting.transmission;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.wirednetwork.DisableNatDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.transmission.wirednetwork.DisableNatOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.AlgOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.OtoNatOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.PortForwardingInfoTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.PortForwardingOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.PortForwardingTemplateOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="NAT (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class NatTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NatTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get site template's port forwarding list", description="Get site template's port forwarding list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/nat/port-forwardings"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<PortForwardingOpenApiGridVO<PortForwardingInfoTemplateOpenApiVO>>> getTemplatePortForwardingList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create site template's new port forwarding", description="Create site template's new port forwarding.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/nat/port-forwardings"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE}, a={b.PF_UNSUPPORT_WAN_IP, b.PF_UNSUPPORT_VIRTUAL_WAN, b.LIMITED_IP_ADDRESS_CONFLICT, b.CONFLICT_PF, b.CONFLICT_PF_EXTERNAL_PORT, b.CONFLICT_PF_EXTERNAL_PORT_AND_WAN_PORT})
    @a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createTemplatePortForwarding(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody PortForwardingTemplateOpenApiVO portForwardingOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portForwardingOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify site template's port forwarding", description="Modify site template's port forwarding.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/nat/port-forwardings/{portForwardingId}"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE}, a={b.PF_UNSUPPORT_WAN_IP, b.PF_UNSUPPORT_VIRTUAL_WAN, b.LIMITED_IP_ADDRESS_CONFLICT, b.CONFLICT_PF, b.CONFLICT_PF_EXTERNAL_PORT, b.CONFLICT_PF_EXTERNAL_PORT_AND_WAN_PORT})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTemplatePortForwarding(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="portForwardingId", description="Port forwarding ID") @PathVariable(name="portForwardingId") String portForwardingId, @RequestBody PortForwardingTemplateOpenApiVO portForwardingOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portForwardingOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete site template's port forwarding", description="Delete site template's port forwarding.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/nat/port-forwardings/{portForwardingId}"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteTemplatePortForwarding(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="portForwardingId", description="Port forwarding ID") @PathVariable(name="portForwardingId") String portForwardingId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get site template's ALG Info", description="Get site template's ALG Info.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/nat/alg"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse<AlgOpenApiVO>> getTemplateAlg(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify site template's ALG setting", description="Modify site template's ALG setting.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/nat/alg"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTemplateAlg(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody AlgOpenApiVO algOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)algOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Create site template's otonat", description="Create site template's otonat.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/transmission/otonats"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> addOtoNatTemplates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody OtoNatOpenApiVO OtoNatOpenApiVO2) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)OtoNatOpenApiVO2), request, response, omadacId);
    }

    @Operation(summary="Get siteTemplate's Disable Nat list", description="Get siteTemplate's Disable Nat list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wired-networks/disable-nat"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<DisableNatDetailOpenApiVO>>> getDisableNatGrid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new siteTemplate's Disable Nat", description="Create new siteTemplate's Disable Nat.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wired-networks/disable-nat"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @a(a=9)
    public DeferredResult<OperationResponseWithoutResult> addDisableNat(@RequestBody DisableNatOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Modify an existing Disable Nat in siteTemplate", description="Modify an existing Disable Nat in siteTemplate.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wired-networks/disable-nat/{disableNatId}"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyDisableNatTemplate(@RequestBody DisableNatOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="disableNatId", description="Disable Nat ID") @PathVariable(name="disableNatId") String disableNatId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Delete an existing Disable Nat in siteTemplate", description="Delete an existing Disable Nat in siteTemplate.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wired-networks/disable-nat/{disableNatId}"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteDisableNat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="disableNatId", description="Disable Nat ID") @PathVariable(name="disableNatId") String disableNatId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

