/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting.security;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.AddAllowListOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.EditAllowListOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.IpsInfoOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="IDS/IPS (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class IpsTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpsTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get site template IDS/IPS config", description="Get site template IDS/IPS config")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/network-security/ips"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<IpsInfoOpenApiVO>> getIpsTemplateConfig(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify site template IDS/IPS config", description="Modify site template IDS/IPS config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/network-security/ips"})
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE}, a={b.IPS_NOT_SUPPORT})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse> modifyIpsTemplateConfig(@RequestBody IpsInfoOpenApiVO ipsVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ipsVO), request, response, omadacId);
    }

    @Operation(summary="Get site template grid ips allow list", description="Obtain site template grid allow list.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/grid/allow-list"})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponse> getTemplateGridAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field IP / Subnet") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create site template's allow list", description="Create site template's allow list.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE}, a={b.ALLOW_LIST_REACHED_LIMIT, b.IPS_NOT_SUPPORT})
    @PostMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/network-security/ips/allow-list"})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponse> createTemplateAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody AddAllowListOpenApiVO addAllowListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)addAllowListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Edit site template's allow list", description="Modify site template's allow list entry.")
    @com.tplink.smb.omada.common.m.a(a={b.IPS_NOT_SUPPORT}, b={k.SITE_TEMPLATE_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/network-security/ips/allow-list"})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponse> editTemplateAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody EditAllowListOpenApiVO editAllowListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)editAllowListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete template allow list", description="Delete template allow List by entry id.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/network-security/ips/allow-list/{entryId}"})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponse> deleteTemplateAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="entryId", description="Allow entry ID") @PathVariable(name="entryId") String entryId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

