/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.CreateSsidOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.CreateWlanGroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidBasicConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidHotspotV2SettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidMacFilterOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidMultiCastOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidRateControlOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidRateLimitOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidWlanScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateWlanGroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.WlanGroupGridOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.WlanGroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.WlanGroupStatusOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Wireless Network (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class WirelessNetworkTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WirelessNetworkTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get WLAN group template list", description="Get WLAN group template list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponse<List<WlanGroupOpenApiVO>>> getWlanGroupListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new WLAN group template", description="Create new WLAN group template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID, b.DUPLICATE_WLAN_GROUP_NAME, b.WLAN_GROUP_NUM_EXCEEDED, b.WLAN_GROUP_NOT_IN_SAME_SITE}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse> createWlanGroupTemplate(@RequestBody CreateWlanGroupOpenApiVO createWlanGroupOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createWlanGroupOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing WLAN group template", description="Modify an existing WLAN group template")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID, b.DUPLICATE_WLAN_GROUP_NAME}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateWlanGroupTemplate(@RequestBody UpdateWlanGroupOpenApiVO updateWlanGroupOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateWlanGroupOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing WLAN group template", description="Delete an existing WLAN group template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}"})
    @a(a={b.DEFAULT_WLAN_GROUP_CANNOT_DELETE}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteWlanGroupTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get SSID template list", description="Get SSID template list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<SsidOpenApiVO>>> getSsidListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get SSID template detail info", description="Get SSID template detail info")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<SsidDetailOpenApiVO>> getSsidDetailTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new SSID template", description="Create new SSID template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID, b.INVALID_SSID_NAME_LEN, b.NAME_CONFLICT, b.VLAN_ID_RANGE_ERROR, b.SSID_SECURITY_MODE_ERROR, b.DUPLICATE_SSID_NAME, b.SSID_NAME_DUPLICATE_WITH_OVERRIDE, b.RADIUS_PROFILE_ONLY_EKMS_SUPPORT_DOMAIN, b.OUI_BASED_VLAN_ENABLED}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse> createSsidTemplate(@RequestBody CreateSsidOpenApiVO createSsidOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createSsidOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template basic config", description="Update SSID template basic config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-basic-config"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID, b.INVALID_SSID_NAME_LEN, b.NAME_CONFLICT, b.VLAN_ID_RANGE_ERROR, b.SSID_SECURITY_MODE_ERROR, b.SSID_NUM_EXCEEDED, b.DUPLICATE_SSID_NAME, b.SSID_NAME_DUPLICATE_WITH_OVERRIDE, b.RADIUS_PROFILE_ONLY_EKMS_SUPPORT_DOMAIN, b.SSID_PPSK_NOT_SUPPORT_WAP3}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidBasicConfigTemplate(@RequestBody UpdateSsidBasicConfigOpenApiVO updateSsidBasicConfigOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidBasicConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template rate limit config", description="Update SSID template rate limit config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-rate-limit"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidRateLimitConfigTemplate(@RequestBody UpdateSsidRateLimitOpenApiVO updateSsidRateLimitOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidRateLimitOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template WLAN schedule config", description="Update SSID template WLAN schedule config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-wlan-schedule"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidWlanScheduleTemplate(@RequestBody UpdateSsidWlanScheduleOpenApiVO updateSsidWlanScheduleOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidWlanScheduleOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template 802.11 rate control config", description="Update SSID template 802.11 rate control config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-rate-control"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=12)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidRateControlConfigTemplate(@RequestBody UpdateSsidRateControlOpenApiVO updateSsidRateControlOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidRateControlOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template mac filter config", description="Update SSID template MAC filter config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-mac-filter"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=13)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidMacFilterConfigTemplate(@RequestBody UpdateSsidMacFilterOpenApiVO updateSsidMacFilterOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidMacFilterOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template Multicast/Broadcast management config", description="Update SSID template Multicast/Broadcast management config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-multicast-config"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidMultiCastConfigTemplate(@RequestBody UpdateSsidMultiCastOpenApiVO updateSsidMultiCastOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidMultiCastOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Update SSID template DHCP option 82 config", description="Update SSID template DHCP option 82 config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-dhcp-option"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidDhcpOptionConfigTemplate(@RequestBody UpdateSsidDhcpOptionOpenApiVO updateSsidDhcpOptionOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidDhcpOptionOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing SSID template", description="Delete an existing SSID template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=16)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteSsidTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @Parameter(name="ssidId", description="SSID ID") @PathVariable(name="ssidId") String ssidId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Check if the number of WLAN groups is out of limit", description="Check if the number of WLAN groups is out of limit. The value of \"wlanGroupNum\" indicates number of wlan group and the value of \"exceeded\" indicates whether the number of WLANs exceeds the limit ")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/cmd/countWlans"})
    @a(a={b.INVALID_SITE_ID}, b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponse<WlanGroupStatusOpenApiVO>> countWlansTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Update SSID template Hotspot2.0 config", description="Update SSID template Hotspot2.0 config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans/{wlanId}/ssids/{ssidId}/update-hotspotv2"})
    @a(a={b.INVALID_SITE_ID, b.SSID_HOTSPOTV2_NOT_SUPPORT}, b={k.NETWORK_WRITE})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSsidHotspotV2SettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="wlanId", description="WLAN ID") @PathVariable(name="wlanId") String wlanId, @RequestBody UpdateSsidHotspotV2SettingOpenApiVO updateSsidHotspotV2SettingOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateSsidHotspotV2SettingOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get WLAN group template list paging query", description="Get WLAN group template list paging query")
    @GetMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/wireless-network/wlans"})
    @a(a={b.INVALID_SITE_TEMPLATE_ID}, b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=19)
    @ResponseBody
    public DeferredResult<OperationResponse<WlanGroupGridOpenApiVO>> getGridWlanGroupTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

