/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.ResponseDataVO;
import com.tplink.smb.omada.common.access.ResponseIdVO;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.CreateVlanParamOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.DeviceTemplateForVlanVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.LanNetworkOpenApiV3GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.LanNetworkOpenApiV3VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.LanNetworkQueryOpenApiV3VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.LanNetworkTemplateQueryOpenApiV3VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.ModifyVlanParamOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.network.lan.vlan.VlanPreConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ouiBasedVlan.LanNetworkVlansOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.CheckWanLanStatusOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.LanProfileConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.LanProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.VlanOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.BatchIsolateInterfaceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.InterfaceForBatchIsolateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.InternetBaseConfigTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.InternetBaseInfoTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.InternetOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanDnsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkOpenApiV2GridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkQueryOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.LanNetworkTemplateQueryOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.UseProfileOswOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.WanLoadBalanceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanAvailablesOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanGridOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanIdUsedOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.virtualwan.VirtualWanStatusOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.wan.AvailableWanResultOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.wan.WanMaxSpeedOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.wirednetwork.wan.WanPortsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.AutoEffectDevicesForVlanVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.AutoSelectDevicesForVlanVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.SelectDeviceForVlanTemplateVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.SelectMacsWithVlanVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.SelectPortBindingVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.VlanNetworkAffectingDeviceVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.VlanNetworkAffectingSsidVO;
import com.tplink.smb.omada.manager.configuration.api.web.network.lan.vlan.VlanNetworkIdListVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wired.lannetwork.LanNetworkVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceVO;
import com.tplink.smb.omada.manager.stack.api.internal.vo.VlanForPortDisplayGridVO;
import com.tplink.smb.omada.manager.stack.api.internal.vo.VlanNetworkAffectingDeviceDetailVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Wired Network (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class WiredNetworkTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WiredNetworkTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get LAN profile template list", description="Get LAN profile template list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    public DeferredResult<OperationResponse<GridVO<LanProfileOpenApiVO>>> getLanProfileTemplateList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new LAN profile template", description="Create new LAN profile template.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_REQUEST_PARAMS, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    public DeferredResult<ResponseIdVO> createLanProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody LanProfileConfigOpenApiVO lanProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify a LAN profile template", description="Modify a LAN profile template template.")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_REQUEST_PARAMS, b.PROFILE_IS_NOT_EXISTED, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    public DeferredResult<OperationResponseWithoutResult> modifyLanProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="lanProfileId") @PathVariable(name="profileId") String profileId, @RequestBody LanProfileConfigOpenApiVO lanProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing LAN profile template", description="Delete an existing LAN profile template.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_REQUEST_PARAMS, b.PROFILE_IS_NOT_EXISTED, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    public DeferredResult<OperationResponseWithoutResult> deleteLanProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="LAN profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get LAN network template list", description="Get LAN network template list.(Pagination)")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    public DeferredResult<OperationResponse<LanNetworkOpenApiV2GridVO<LanNetworkTemplateQueryOpenApiV2VO>>> getLanNetworkTemplateList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create LAN network template", description="Create lan network template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.PRO_LAN_NUM_EXCEED, b.INTERFACE_NUM_EXCEED, b.DUPLICATE_VLANID, b.OSG_VLAN_NUM_EXCEED, b.OSW_VLAN_NUM_EXCEED, b.DUPLICATE_NETWORK_NAME, b.DUPLICATE_PROFILE_NAME, b.DUPLICATE_PROFILE_NAME, b.DEVICE_NOT_SUPPORT_MULTI_VLAN, b.DEVICE_NOT_SUPPORT_RA, b.DEVICE_NOT_SUPPORT_CUSTOM_DHCP_OPTION, b.DEVICE_NOT_SUPPORT_DHCP_NEXT_SERVER, b.DEVICE_NOT_SUPPORT_ARP_DETECTION})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    public DeferredResult<ResponseIdVO> createLanNetworkTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody LanNetworkTemplateOpenApiVO lanNetworkOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify LAN network template", description="Modify LAN network template")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/{networkId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.NETWORK_IS_NOT_EXISTED, b.MODIFY_DEFAULT_NETWORK_VLAN_TYPE, b.MODIFY_DEFAULT_NETWORK_INTERFACE, b.INTERFACE_NUM_EXCEED, b.DUPLICATE_VLANID, b.DUPLICATE_NETWORK_NAME, b.DUPLICATE_PROFILE_NAME, b.ORIGIN_VLAN_USED_IN_OUI_BASED_VLAN, b.DUPLICATE_PROFILE_NAME, b.DEVICE_NOT_SUPPORT_MULTI_VLAN, b.DEVICE_NOT_SUPPORT_RA, b.DEVICE_NOT_SUPPORT_CUSTOM_DHCP_OPTION, b.DEVICE_NOT_SUPPORT_DHCP_NEXT_SERVER, b.DEVICE_NOT_SUPPORT_ARP_DETECTION})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    public DeferredResult<OperationResponseWithoutResult> modifyLanNetworkTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody LanNetworkTemplateOpenApiVO lanNetworkOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete LAN network template", description="Delete LAN network template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/{networkId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.NETWORK_IS_NOT_EXISTED, b.DELETE_LAN_NETWORK_FAILED_IN_IPS, b.DELETED_DEFAULT_NETWORK})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    public DeferredResult<OperationResponseWithoutResult> deleteLanNetworkTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get all \"single\"/\"multi\" interface lan network template", description="Get all \"single\"/\"multi\" interface lan network template")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/interface"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponse<ResponseDataVO<LanNetworkQueryOpenApiV2VO>>> getInterfaceLanNetworkV2(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="type", description="Interface vlan type. When \"type\" is 0, return \"single\" interface lan network, else return \"single\"/\"multi\" interface lan network") @RequestParam(name="type", required=false) Integer vlanType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch create vlans template", description="Batch create vlans template. Format support: 200, 1-100.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-vlans"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.DUPLICATE_VLANID, b.OSG_VLAN_NUM_EXCEED, b.OSW_VLAN_NUM_EXCEED, b.DUPLICATE_NETWORK_NAME, b.DUPLICATE_PROFILE_NAME})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponseWithoutResult> createVlans(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody VlanOpenApiVO vlanOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vlanOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Check template WAN-LAN status", description="Get gateway template basic info and template WAN/LAN list. Use this API to operate \"LanNetwork\".")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wan-lan-status"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    public DeferredResult<CheckWanLanStatusOpenApiVO> checkWanLanStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get site template internet basic info", description="Get site template basic info. All port and port-related configuration will take effect only the The parameter [preConfiguration] is true.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/internet/basic-info"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    public DeferredResult<OperationResponse<InternetBaseInfoTemplateOpenApiVO>> getInternetBasicPortInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=14)
    @Operation(summary="Modify site template internet basic configuration", description="Modify site template internet basic configuration.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/internet/basic-info"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.WANNETWORK_NOT_EXIST, b.WAN_IPV6_USED})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyInternetBasicPortInfo(@RequestBody InternetBaseConfigTemplateOpenApiVO configVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)configVO), request, response, omadacId);
    }

    @com.a.a.a.a.a(a=15)
    @Operation(summary="Get site template internet load balance config", description="Get site template internet load balance config.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/internet/load-balance"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<WanLoadBalanceOpenApiVO>> getInternetLoadBalance(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @com.a.a.a.a.a(a=16)
    @Operation(summary="Modify site template internet load balance config", description="Modify site template internet load balance config.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/internet/load-balance"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyInternetLoadBalance(@RequestBody WanLoadBalanceOpenApiVO configVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)configVO), request, response, omadacId);
    }

    @Operation(summary="Get valid site template vlanList for switch oui based vlan", description="Get valid site template vlanList for switch oui based vlan")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/switch-oui-rules/valid-vlans"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    public DeferredResult<GridVO<LanNetworkVlansOpenApiVO>> getAllValidVlansInSiteForSwitchOuiBasedVlan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Use LAN profile ES template list", description="Get Use LAN profile ES template list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles/{profileId}/es"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    public DeferredResult<OperationResponse<GridVO<UseProfileOswOpenApiVO>>> getUseLanProfileESTemplateList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="LAN profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get internet info", description="Get internet info On site template.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/internet"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=19)
    public DeferredResult<OperationResponse<InternetOpenApiVO>> getInternetTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify Wan Ports", description="modify wan ports for site template, Note that modify wan ports will cause gateway reboot. You need to configure a gateway in Device Template to use this function.")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/wan-ports"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=20)
    public DeferredResult<OperationResponseWithoutResult> modifyWanPortsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody WanPortsOpenApiVO wanPortsOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)wanPortsOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get wan ports max speed", description="Get max speed for certain wan ports for template,if ports doesn't exist, this interface will return default result")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/wan-max-speed"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=21)
    public DeferredResult<OperationResponse<WanMaxSpeedOpenApiVO>> getWanPortsMaxSpeed(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="wanId", description="WanId, can pass multiple wan ports using comma separator like '{portId1},{portId2}'.") @RequestParam(value="wanId") String wanId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get available wan ports", description="Get available wan ports for template")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/wan-ports"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=22)
    public DeferredResult<OperationResponse<AvailableWanResultOpenApiVO>> getAvailableWanPorts(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="function", description="function used for wan ports query. 0: ACL, 1: QOS, 2: IP_MAC_BLINDING, 3:IGMP_PROXY, 4: VIRTUAL_WAN") @RequestParam(name="function") Integer function) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get LAN Dns template list", description="Get LAN Dns template list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan/dns"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=23)
    public DeferredResult<OperationResponse<GridVO<LanDnsOpenApiVO>>> getLanDnsTemplateList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create LAN Dns template", description="Create lan Dns template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan/dns"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.LAN_DNS_DOES_NOT_EXIST, b.LAN_DNS_SIZE_LIMITED, b.LAN_DNS_IP_TYPE_SIZE_LIMITED, b.LAN_DNS_IP_ADDRESS_CANNOT_BE_EMPTY, b.LAN_DNS_HAS_DUPLICATE_IPV4_ADDRESS, b.LAN_DNS_HAS_DUPLICATE_IPV6_ADDRESS, b.LAN_DNS_CNAME_CANNOT_BE_EMPTY, b.LAN_DNS_DNS_SERVER_CANNOT_BE_EMPTY, b.LAN_DNS_HAS_DUPLICATE_DNS_SERVER, b.LAN_DNS_DOMAIN_AND_ALIAS_DUPLICATE, b.LAN_DNS_NOT_SUPPORT})
    @ResponseBody
    @com.a.a.a.a.a(a=24)
    public DeferredResult<OperationResponseWithoutResult> createLanDnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody LanDnsOpenApiVO lanDnsOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanDnsOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify LAN Dns template", description="Modify LAN Dns template")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan/dns/{dnsId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.LAN_DNS_DOES_NOT_EXIST, b.LAN_DNS_SIZE_LIMITED, b.LAN_DNS_IP_TYPE_SIZE_LIMITED, b.LAN_DNS_IP_ADDRESS_CANNOT_BE_EMPTY, b.LAN_DNS_HAS_DUPLICATE_IPV4_ADDRESS, b.LAN_DNS_HAS_DUPLICATE_IPV6_ADDRESS, b.LAN_DNS_CNAME_CANNOT_BE_EMPTY, b.LAN_DNS_DNS_SERVER_CANNOT_BE_EMPTY, b.LAN_DNS_HAS_DUPLICATE_DNS_SERVER, b.LAN_DNS_DOMAIN_AND_ALIAS_DUPLICATE, b.LAN_DNS_NOT_SUPPORT})
    @ResponseBody
    @com.a.a.a.a.a(a=25)
    public DeferredResult<OperationResponseWithoutResult> modifyLanDnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="dnsId", description="LAN DNS ID") @PathVariable(name="dnsId") String id, @RequestBody LanDnsOpenApiVO configOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)configOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete LAN Dns template", description="Delete LAN Dns template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan/dns/{dnsId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.LAN_DNS_DOES_NOT_EXIST, b.LAN_DNS_SIZE_LIMITED, b.LAN_DNS_IP_TYPE_SIZE_LIMITED, b.LAN_DNS_IP_ADDRESS_CANNOT_BE_EMPTY, b.LAN_DNS_HAS_DUPLICATE_IPV4_ADDRESS, b.LAN_DNS_HAS_DUPLICATE_IPV6_ADDRESS, b.LAN_DNS_CNAME_CANNOT_BE_EMPTY, b.LAN_DNS_DNS_SERVER_CANNOT_BE_EMPTY, b.LAN_DNS_HAS_DUPLICATE_DNS_SERVER, b.LAN_DNS_DOMAIN_AND_ALIAS_DUPLICATE})
    @ResponseBody
    @com.a.a.a.a.a(a=26)
    public DeferredResult<OperationResponseWithoutResult> deleteLanDnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="dnsId", description="LAN DNS ID") @PathVariable(name="dnsId") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query virtual WAN list template", description="Query virtual WAN list for template.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/virtual-wans"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=27)
    public DeferredResult<OperationResponse<VirtualWanGridOpenApiVO<VirtualWanInfoOpenApiVO>>> getGridVirtualWanTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query available virtual WAN list for template", description="Query available virtual WAN list for template.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/available-virtual-wans"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=28)
    public DeferredResult<OperationResponse<VirtualWanAvailablesOpenApiVO>> getAvailableVirtualWanTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create virtual WAN template", description="Create virtual WAN template.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/virtual-wans"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.VIRTUAL_WAN_VLAN_ID_DUPLICATE, b.VIRTUAL_WAN_EXCEED_LIMIT_PER_WAN, b.VIRTUAL_WAN_EXCEED_LIMIT_ADOPT, b.VIRTUAL_WAN_EXCEED_LIMIT_NOT_ADOPT, b.VIRTUAL_WAN_VLAN_NMAE_DUPLICATE, b.VIRTUAL_WAN_DSL_PARAMS_INVALID, b.VIRTUAL_WAN_NOT_SUPPORT, b.VIRTUAL_WAN_NOT_SUPPORT_MSS_CLAMPING, b.VIRTUAL_WAN_NOT_SUPPORT_PPPOR_MRU, b.VIRTUAL_WAN_NOT_SUPPORT_DHCP_OPTIONS, b.VIRTUAL_WAN_NOT_SUPPORT_DSL_MER, b.VIRTUAL_WAN_ONLY_DSL})
    @ResponseBody
    @com.a.a.a.a.a(a=29)
    private DeferredResult<OperationResponseWithoutResult> createVirtualWanTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody VirtualWanConfigOpenApiVO configOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)configOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify virtual WAN template", description="Modify virtual WAN template.")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/virtual-wans/{virtualWanId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.VIRTUAL_WAN_NOT_EXIST, b.VIRTUAL_WAN_VLAN_ID_DUPLICATE, b.VIRTUAL_WAN_EXCEED_LIMIT_PER_WAN, b.VIRTUAL_WAN_EXCEED_LIMIT_ADOPT, b.VIRTUAL_WAN_EXCEED_LIMIT_NOT_ADOPT, b.VIRTUAL_WAN_VLAN_NMAE_DUPLICATE, b.VIRTUAL_WAN_DSL_PARAMS_INVALID, b.VIRTUAL_WAN_NOT_SUPPORT, b.VIRTUAL_WAN_NOT_SUPPORT_MSS_CLAMPING, b.VIRTUAL_WAN_NOT_SUPPORT_PPPOR_MRU, b.VIRTUAL_WAN_NOT_SUPPORT_DHCP_OPTIONS, b.VIRTUAL_WAN_NOT_SUPPORT_DSL_MER, b.VIRTUAL_WAN_ONLY_DSL})
    @ResponseBody
    @com.a.a.a.a.a(a=30)
    public DeferredResult<OperationResponseWithoutResult> modifyVirtualWanTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="virtualWanId", description="Virtual WAN ID") @PathVariable(name="virtualWanId") String virtualWanId, @RequestBody VirtualWanConfigOpenApiVO configOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)configOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify virtual WAN status template", description="Modify virtual WAN status template.")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/virtual-wans/{virtualWanId}/status"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.VIRTUAL_WAN_NOT_EXIST})
    @ResponseBody
    @com.a.a.a.a.a(a=31)
    public DeferredResult<OperationResponseWithoutResult> modifyVirtualWanStatusTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="virtualWanId", description="Virtual WAN ID") @PathVariable(name="virtualWanId") String virtualWanId, @RequestBody VirtualWanStatusOpenApiVO configOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)configOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete virtual WAN template", description="Delete virtual WAN template.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/virtual-wans/{virtualWanId}"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=32)
    public DeferredResult<OperationResponseWithoutResult> deleteVirtualWan(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="virtualWanId", description="Virtual WAN ID") @PathVariable(name="virtualWanId") String virtualWanId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Check Virtual Wan Used", description="check configurations who have used current virtualWan")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/virtual-wans/delete-check"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=33)
    public DeferredResult<OperationResponse<VirtualWanIdUsedOpenApiVO>> checkVirtualWanUsed(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="virtualWanId", description="Virtual WAN ID") @RequestParam(value="virtualWanId") String virtualWanId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get all network templates for the omada id and site template id", description="Get all network templates for the omada id and site template id")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/all"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=34)
    public DeferredResult<OperationResponse<List<LanNetworkVO>>> getAllLanNetworksTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch isolate network", description="Batch isolate network.")
    @PostMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/batch-isolate"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_BUSY, b.INVALID_REQUEST_PARAMS, b.PROFILE_IS_NOT_EXISTED, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=35)
    public DeferredResult<OperationResponseWithoutResult> batchIsolateLanNetwork(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody BatchIsolateInterfaceOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get interface Grid", description="Get interface Grid.")
    @GetMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/isolate/interfaces"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=36)
    public DeferredResult<OperationResponse<List<InterfaceForBatchIsolateOpenApiVO>>> getAllInterfacesForBatchIsolate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="searchKey", description="Fuzzy query parameters, support field ") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="isolation_filter", description="non-isolation set 0; isolation set 1; don't filter isolation vlan set 2.") @RequestParam(name="isolation_filter", required=false) Integer isolation_filter) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device template list that can be dhcp server", description="Get device template list that can be dhcp server")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/devices"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=37)
    public DeferredResult<OperationResponse<GridVO<DeviceVO>>> getGridSupportVlanNetworkDevicesBySiteTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device template list that use the network", description="Get device template list that use the network")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/vlan/{vlan}/devices"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=38)
    public DeferredResult<OperationResponse<List<VlanNetworkAffectingDeviceVO>>> getVlanNetworkAffectedDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="Vlan ID") @PathVariable(name="vlan") String vlanStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get switch profile template list", description="Get switch profile template list.")
    @GetMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=39)
    public DeferredResult<OperationResponse<GridVO<LanProfileOpenApiVO>>> getOswLanProfileTemplateList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new switch profile template", description="Create new switch profile template.")
    @PostMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_REQUEST_PARAMS, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=40)
    public DeferredResult<ResponseIdVO> createOswLanProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody LanProfileConfigOpenApiVO lanProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify a switch profile template", description="Modify a switch profile template template.")
    @PatchMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_REQUEST_PARAMS, b.PROFILE_IS_NOT_EXISTED, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=41)
    public DeferredResult<OperationResponseWithoutResult> modifyOswLanProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="lanProfileId") @PathVariable(name="profileId") String profileId, @RequestBody LanProfileConfigOpenApiVO lanProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing switch profile template", description="Delete an existing switch profile template.")
    @DeleteMapping(value={"/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}/lan-profiles/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_REQUEST_PARAMS, b.PROFILE_IS_NOT_EXISTED, b.OK})
    @ResponseBody
    @com.a.a.a.a.a(a=42)
    public DeferredResult<OperationResponseWithoutResult> deleteOswLanProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="LAN profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Check basic parameters when creating network template", description="Check basic parameters when creating network template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/param-check"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=43)
    public DeferredResult<OperationResponse<LanNetworkQueryOpenApiV3VO>> checkNetworkTemplateParamWhenCreate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody LanNetworkOpenApiV3VO lanNetworkOpenApiV3VO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiV3VO), request, response, omadacId);
    }

    @Operation(summary="Check basic parameters when modifying the network", description="Check basic parameters when modifying the network.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/param-check"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=44)
    public DeferredResult<OperationResponse<LanNetworkQueryOpenApiV3VO>> checkNetworkTemplateParamWhenModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody LanNetworkOpenApiV3VO lanNetworkOpenApiV3VO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiV3VO), request, response, omadacId);
    }

    @Operation(summary="Get the port information of the selected device templates when creating network for site template", description="Get the port information of the selected device templates when creating network for site template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/devices/ports"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=45)
    public DeferredResult<OperationResponse<List<SelectDeviceForVlanTemplateVO>>> getSelectDeviceTemplatePortsInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody SelectMacsWithVlanVO selectMacsWithVlanVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)selectMacsWithVlanVO), request, response, omadacId);
    }

    @Operation(summary="Get the port information of the selected device templates when modifying the network for site template", description="Get the port information of the selected device templates when modifying the network for site template.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/devices/ports"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=46)
    public DeferredResult<OperationResponse<List<SelectDeviceForVlanTemplateVO>>> getSelectDeviceTemplatePortsInfoWhenModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody SelectMacsWithVlanVO selectMacsWithVlanVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)selectMacsWithVlanVO), request, response, omadacId);
    }

    @Operation(summary="Check selected ports when creating network for site template", description="Check selected ports when creating network for site template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/ports-check"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=47)
    public DeferredResult<OperationResponse<List<String>>> checkTemplatePortBindingParamWhenCreate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody SelectPortBindingVO selectPortBindingVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)selectPortBindingVO), request, response, omadacId);
    }

    @Operation(summary="Check port binding when modifying network for site template", description="Check port binding when modifying network for site template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/ports-check"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=48)
    public DeferredResult<OperationResponse<List<String>>> checkTemplatePortBindingParamWhenModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody SelectPortBindingVO selectPortBindingVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)selectPortBindingVO), request, response, omadacId);
    }

    @Operation(summary="Check Wan Loadbalance status", description="Check Wan Loadbalance weight modified or not")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/internet/load-balance/status"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=49)
    public DeferredResult<OperationResponse> getLoadBalanceWeightStatusTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the ports of devices template that use the network", description="Get the ports of devices template that use the network.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/vlan/{vlan}/ports"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=50)
    public DeferredResult<OperationResponse<VlanForPortDisplayGridVO<VlanNetworkAffectingDeviceDetailVO>>> getTemplateGridVlanNetworkAffectedDevicePorts(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="Vlan ID") @PathVariable(name="vlan") String vlanStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Check all parameters and generate configuration when creating network template", description="Check all parameters and generate configuration when creating network template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/check"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=51)
    public DeferredResult<OperationResponse<VlanPreConfigOpenApiVO>> checkTemplateParamAndGetPreConfig(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateVlanParamOpenApiVO createVlanParamOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createVlanParamOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Check all parameters and generate configuration when modifying the network template", description="Check all parameters and generate configuration when modifying the network template.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/check"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=52)
    public DeferredResult<OperationResponse<VlanPreConfigOpenApiVO>> checkTemplateParamAndGetPreConfigWhenModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody ModifyVlanParamOpenApiVO modifyVlanParamOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyVlanParamOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get grid devices templates that support ports config.", description="Get grid devices templates that support ports config.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/devicetemplates/support-ports"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=53)
    public DeferredResult<OperationResponse<List<DeviceTemplateForVlanVO>>> getSupportPortsDeviceTemplates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Confirm create lan network template", description="Confirm create lan network template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/confirm"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.PRO_LAN_NUM_EXCEED, b.VLAN_WITH_OSG_AS_DHCP_SERVER_NUM_EXCEED, b.DUPLICATE_VLANID, b.OSG_VLAN_NUM_EXCEED, b.OSW_VLAN_NUM_EXCEED, b.DUPLICATE_NETWORK_NAME, b.DUPLICATE_PROFILE_NAME})
    @ResponseBody
    @com.a.a.a.a.a(a=54)
    public DeferredResult<OperationResponse<VlanNetworkIdListVO>> confirmCreateVlanNetworkTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateVlanParamOpenApiVO createVlanParamOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createVlanParamOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Confirm modify lan network template", description="Confirm modify lan network template.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/confirm"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.PRO_LAN_NUM_EXCEED, b.VLAN_WITH_OSG_AS_DHCP_SERVER_NUM_EXCEED, b.OSG_VLAN_NUM_EXCEED, b.OSW_VLAN_NUM_EXCEED})
    @ResponseBody
    @com.a.a.a.a.a(a=55)
    public DeferredResult<OperationResponse<VlanNetworkIdListVO>> confirmModifyVlanNetworkTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody ModifyVlanParamOpenApiVO modifyVlanParamOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyVlanParamOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get LAN network template list", description="Get LAN network template list.(Pagination)")
    @GetMapping(value={"/openapi/v3/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=56)
    public DeferredResult<OperationResponse<LanNetworkOpenApiV3GridVO<LanNetworkTemplateQueryOpenApiV3VO>>> getLanNetworkTemplateListV3(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get LAN network template", description="Get LAN network template.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/lan-networks/{networkId}"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=57)
    public DeferredResult<OperationResponse<LanNetworkTemplateQueryOpenApiV3VO>> getLanNetworkTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid ssid template list that use the vlan", description="Get grid ssid template list that use the vlan")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/vlan/{vlan}/ssids"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=58)
    public DeferredResult<OperationResponse<GridVO<VlanNetworkAffectingSsidVO>>> getVlanNetworkAffectedSsid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @Parameter(name="vlan", description="Vlan ID") @PathVariable(name="vlan") String vlanStr) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get auto effect devices when creating network", description="Get auto effect devices when creating network.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/auto-effect-devices"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=59)
    public DeferredResult<OperationResponse<AutoEffectDevicesForVlanVO>> getAutoEffectDevicesTemplateWhenCreate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody LanNetworkOpenApiV3VO lanNetworkOpenApiV3VO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiV3VO), request, response, omadacId);
    }

    @Operation(summary="Get auto effect devices when modifying network", description="Get auto effect devices when modifying network.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/auto-effect-devices"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=60)
    public DeferredResult<OperationResponse<AutoEffectDevicesForVlanVO>> getAutoEffectDevicesTemplateWhenModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody LanNetworkOpenApiV3VO lanNetworkOpenApiV3VO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiV3VO), request, response, omadacId);
    }

    @Operation(summary="Get auto select devices when modifying network", description="Get auto select devices when modifying network.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/networks/{networkId}/auto-select-devices"})
    @a(b={k.SITE_TEMPLATE_READ}, a={})
    @ResponseBody
    @com.a.a.a.a.a(a=61)
    public DeferredResult<OperationResponse<AutoSelectDevicesForVlanVO>> getAutoSelectDevicesTemplateWhenModify(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="networkId", description="Network ID") @PathVariable(name="networkId") String networkId, @RequestBody LanNetworkOpenApiV3VO lanNetworkOpenApiV3VO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)lanNetworkOpenApiV3VO), request, response, omadacId);
    }
}

