/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.DnsCacheOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.SnmpSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.SshSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.UpnpSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.CreateDdnsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.DdnsOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.DdnsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnscache.DnsCacheQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsProxySettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsProxySettingQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IgmpTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.CreateMdnsRuleTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.MdnsRuleTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PortOrPoeScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.ResIdOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.RebootScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitetemplatesetting.schedule.RebootScheduleTemplateQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.servicesetting.dto.dnscache.DnsCacheInfoVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Service (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class ServiceSettingTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceSettingTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/ddns"})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    @Operation(summary="Get Dynamic DNS template list", description="Get Dynamic DNS template list of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<DdnsOpenApiGridVO<DdnsOpenApiVO>>> getDdnsGridTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.service", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.service", required=false) String sortsService, @Parameter(name="sorts.updateInterval", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.updateInterval", required=false) String sortsUpdateInterval, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortsStatus) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/ddns"})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    @Operation(summary="Create a new Dynamic DNS template entry", description="Create a new Dynamic DNS template entry with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.INVALID_DDNS_ITEM, b.DUPLICATE_USERNAME_DDNS_ITEM, b.INVALID_DDNS_DOMAIN})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createDdnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateDdnsOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/ddns/{ddnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    @Operation(summary="Modify an exist Dynamic DNS template entry", description="Modify an exist Dynamic DNS template entry with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.INVALID_DDNS_ITEM, b.DUPLICATE_USERNAME_DDNS_ITEM, b.INVALID_DDNS_DOMAIN})
    public DeferredResult<OperationResponseWithoutResult> modifyDdnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="ddnsId", description="Dynamic DNS entry ID") @PathVariable(name="ddnsId") String ddnsId, @RequestBody CreateDdnsOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/ddns/{ddnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    @Operation(summary="Delete an exist Dynamic DNS template entry", description="Delete an exist Dynamic DNS template entry with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> deleteDdnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="ddnsId", description="Dynamic DNS entry ID") @PathVariable(name="ddnsId") String ddnsId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/dns-cache"})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    @Operation(summary="Modify DNS cache setting", description="Modify DNS cache setting")
    @a(b={k.SITE_TEMPLATE_WRITE})
    public DeferredResult<OperationResponseWithoutResult> modifyDnsCacheSettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody DnsCacheOpenApiVO dnsCacheOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dnsCacheOpenApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/dns-cache-data/refresh"})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    @Operation(summary="Refresh dns cache list", description="Send refresh command to devices and refresh dns cache list.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.DNS_CACHE_IS_NOT_ENABLE, b.GATEWAY_DOES_NOT_EXIST, b.OSG_NOT_CONNECTED_QUERY_DNS_CACHE_INO})
    public DeferredResult<OperationResponse<GridVO<DnsCacheInfoVO>>> refreshDnsCacheListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody DnsCacheQueryOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/ddns/update-url"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    @Operation(summary="Get DDNS update url", description="Get global DDNS update url of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<String>> getGlobalDdnsUpdateUrlTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/snmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    @Operation(summary="Get SNMP template setting", description="Get SNMP template setting info of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<SnmpSettingOpenApiVO>> getSnmpSettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/snmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=14)
    @Operation(summary="Modify SNMP template setting", description="Modify SNMP template setting info of the site with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.SAME_SNMPV1V2V3_USERNAME})
    public DeferredResult<OperationResponseWithoutResult> modifySnmpSettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody SnmpSettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/dns-proxy"})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    @Operation(summary="Get DNS proxy template setting", description="Get DNS proxy template setting of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<DnsProxySettingQueryOpenApiVO>> getDnsProxyTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/dns-proxy"})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    @Operation(summary="Modify DNS proxy template setting", description="Modify DNS proxy template setting info of the site with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.DNS_SEC_SERVERS_EMPTY, b.DNS_SEC_SERVERS_REACH_LIMIT, b.DOH_SERVERS_EMPTY, b.DOT_SERVERS_EMPTY, b.EMPTY_NETWORK, b.DNS_OVERRIDE_NETWORK_NOT_EXISTS, b.NOT_SUPPORT_DNS_PROXY, b.NOT_SUPPORT_DNS_PROXY_OVERRIDE, b.INVALID_DNS_SERVER})
    public DeferredResult<OperationResponseWithoutResult> modifyDnsProxyTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody DnsProxySettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get UPnP template setting", description="Get UPnP template setting")
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/upnp"})
    @a(b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponse<UpnpSettingOpenApiVO>> getUpnpSettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify UPnP template setting", description="Modify UPnP template setting")
    @PutMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/upnp"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateUpnpSettingTemplate(@RequestBody UpnpSettingOpenApiVO upnpSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)upnpSetting), request, response, omadacId);
    }

    @Operation(summary="Get SSH template setting", description="Get SSH template setting")
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ssh"})
    @a(b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=19)
    @ResponseBody
    public DeferredResult<OperationResponse<SshSettingOpenApiVO>> getSshSettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SSH template setting", description="Modify SSH template setting")
    @PutMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ssh"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSshSettingTemplate(@RequestBody SshSettingOpenApiVO sshSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)sshSetting), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/iptv"})
    @ResponseBody
    @com.a.a.a.a.a(a=21)
    @Operation(summary="Get IPTV setting template", description="Get IPTV setting template of the site with the given omadacId and siteTemplateId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<IptvSettingOpenApiVO>> getIptvTemplateServerSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/iptv"})
    @ResponseBody
    @com.a.a.a.a.a(a=22)
    @Operation(summary="Modify IPTV setting template", description="Modify IPTV setting template with the given omadacId and siteTemplateId. There should be a gateway template model preconfigured, or else you cannot modify IPTV template setting.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.CURRENT_SITE_TEMPLATE_UNSUPPORT, b.DUPLICATE_NAME_IN_SITE_TEMPLATE})
    public DeferredResult<OperationResponseWithoutResult> modifyIptvTemplateServerSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody IptvSettingOpenApiVO iptvSettingOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)iptvSettingOpenApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/iptv/igmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=23)
    @Operation(summary="Get IGMP template setting", description="Get IGMP template setting of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<IgmpTemplateOpenApiVO>> getIgmpTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/iptv/igmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=24)
    @Operation(summary="Modify IGMP template setting", description="Modify IGMP template setting info of the site with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> modifyIgmpTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody IgmpTemplateOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/iptv/iptv"})
    @ResponseBody
    @com.a.a.a.a.a(a=25)
    @Operation(summary="Get IPTV template setting", description="Get IPTV template setting of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<IptvOpenApiVO>> getIptvTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/iptv/iptv"})
    @ResponseBody
    @com.a.a.a.a.a(a=26)
    @Operation(summary="Modify IPTV template setting", description="Modify IPTV template setting info of the site with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.IPTV_WITHOUT_INTERNET_PORT, b.DUPLICATE_VLANID_IN_IPTV, b.DUPLICATE_VLANID_WITH_NETWORK, b.DUPLICATE_VLANID})
    public DeferredResult<OperationResponseWithoutResult> modifyIptvTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody IptvConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/mdns"})
    @ResponseBody
    @com.a.a.a.a.a(a=27)
    @Operation(summary="Get mDNS template rule list", description="Get mDNS template rule list of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<GridVO<MdnsRuleTemplateOpenApiVO>>> getMdnsGridTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/mdns"})
    @ResponseBody
    @com.a.a.a.a.a(a=28)
    @Operation(summary="Create a new mDNS template rule", description="Create a new mDNS template rule with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.DUPLICATE_MDNS_RULE_NAME, b.OSG_MDNS_RULE_EXIST, b.MDNS_RULE_SIZE_LIMIT, b.AP_MDNS_RULE_EXIST, b.NOT_SUPPORT_MDNS})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createMdnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateMdnsRuleTemplateOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/mdns/{mdnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=29)
    @Operation(summary="Modify an exist mDNS template rule", description="Modify an exist mDNS template rule with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID, b.DUPLICATE_MDNS_RULE_NAME, b.MDNS_RULE_SIZE_LIMIT, b.NOT_SUPPORT_MDNS, b.MDNS_RULE_NOT_EXIST})
    public DeferredResult<OperationResponseWithoutResult> modifyMdnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="mdnsId", description="mDNS rule template ID") @PathVariable(name="mdnsId") String mdnsId, @RequestBody CreateMdnsRuleTemplateOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/mdns/{mdnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=30)
    @Operation(summary="Delete an exist mDNS template rule", description="Delete an exist mDNS template rule with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> deleteMdnsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="mdnsId", description="mDNS rule template ID") @PathVariable(name="mdnsId") String mdnsId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/rebootSchedules"})
    @ResponseBody
    @com.a.a.a.a.a(a=31)
    @Operation(summary="Get reboot schedule templates", description="Get reboot schedule templates with the given omadacId and siteTemplateId.")
    @a(b={k.SITE_TEMPLATE_READ})
    public DeferredResult<OperationResponse<List<RebootScheduleTemplateQueryOpenApiVO>>> getRebootScheduleList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/rebootSchedules/{rebootScheduleId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=32)
    @Operation(summary="Modify reboot schedule template", description="Modify a reboot schedule template")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.CURRENT_SITE_TEMPLATE_UNSUPPORT, b.DUPLICATE_NAME_IN_SITE_TEMPLATE})
    public DeferredResult<OperationResponseWithoutResult> modifyRebootScheduleTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="rebootScheduleId", description="Reboot Schedule ID") @PathVariable(name="rebootScheduleId") String rebootScheduleId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @RequestBody RebootScheduleOpenApiVO rebootScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)rebootScheduleOpenApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/rebootSchedules/{rebootScheduleId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=33)
    @Operation(summary="Remove reboot schedule template", description="Remove a reboot schedule template")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.CURRENT_SITE_TEMPLATE_UNSUPPORT})
    public DeferredResult<OperationResponseWithoutResult> removeRebootScheduleTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="rebootScheduleId", description="Reboot Schedule ID") @PathVariable(name="rebootScheduleId") String rebootScheduleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/port-schedules"})
    @ResponseBody
    @com.a.a.a.a.a(a=34)
    @Operation(summary="Get port Schedule list", description="Get port Schedule list with the given omadacId and siteTemplateId.")
    @a(b={k.SITE_TEMPLATE_READ})
    public DeferredResult<OperationResponse<List<PortOrPoeScheduleOpenApiVO>>> getPortScheduleListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/port-schedules"})
    @ResponseBody
    @com.a.a.a.a.a(a=35)
    @Operation(summary="Create a new Port Schedule Template", description="Create a new Port Schedule Template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponse> addPortScheduleTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody PortOrPoeScheduleOpenApiVO portScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portScheduleOpenApiVO), request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/port-schedules/{type}/{portScheduleId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=36)
    @Operation(summary="Modify a Port Schedule Template", description="Modify a Port Schedule Template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponseWithoutResult> modifyPortScheduleTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @PathVariable(value="type") String type, @PathVariable(value="portScheduleId") String portScheduleId, @RequestBody PortOrPoeScheduleOpenApiVO portScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portScheduleOpenApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/service/port-schedules/{type}/{portScheduleId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=37)
    @Operation(summary="Delete Port Schedule Template", description="Delete Port Schedule Template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponseWithoutResult> removePortScheduleTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @PathVariable(name="type") String type, @PathVariable(name="portScheduleId") String portScheduleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/dns-cache"})
    @ResponseBody
    @com.a.a.a.a.a(a=38)
    @Operation(summary="Get DNS cache setting template", description="Get DNS cache setting template of the site template with the given omadacId and siteTemplateId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponse<DnsCacheOpenApiVO>> getDnsCacheSettingTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

