/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.AutoCreatePSKOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiProfileQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiProfileSummaryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PPSKAutoTypeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PPSKProfileBriefInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PPSKProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile.ApnProfileConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile.ApnProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.CreateGroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.GroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.ResIdOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile.CreateLdapProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile.LdapProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.CreateRadiusProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.CreateRadiusUserOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusUserOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit.CreateRateLimitProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit.RateLimitProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit.UpdateRateLimitProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.timerange.CreateTimeRangeProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.timerange.TimeRangeProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.timerange.UpdateTimeRangeProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiGridVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Profiles (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class ProfileTemplateManagerOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileTemplateManagerOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/groups"})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    @Operation(summary="Get group profile template list", description="Get group profile template list of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<List<GroupOpenApiVO>>> getGroupProfilesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/groups/{groupType}"})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    @Operation(summary="Get group profile template list by type", description="Get a certain type of group profile template list of the site with the given omadacId and siteId and type.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<List<GroupOpenApiVO>>> getGroupProfilesByTypeTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="groupType", description="Type of group profile, 0:IP Group; 1:IP Port Group; 2\uff1aMac Group; 3:IPv6 Group; 4:IPv6 Port Group; 5:Country Group; 7:Domain Group.") @PathVariable(name="groupType") String groupType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/groups"})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    @Operation(summary="Create a new group profile template", description="Create a new group profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.DUPLICATE_GROUP_NAME, b.IPV6_GROUP_NUM_EXCEED, b.IP_GROUP_NUM_EXCEED, b.IP_PORT_NUM_EXCEED, b.MAC_FILTER_GROUP_NUM_EXCEED, b.DUPLICATE_MAC_FILTER_GROUP_NAME, b.DUPLICATE_MAC_FILTER_ADDRESS, b.IPV6_PORT_GROUP_NUM_EXCEED, b.COUNTRY_GROUP_NUM_EXCEED, b.DOMAIN_GROUP_NUM_EXCEED, b.IP_NUM_EXCEED_OF_IP_GROUP, b.IP_NUM_EXCEED_OF_IP_PORT_GROUP, b.PORT_NUM_EXCEED_OF_IP_PORT_GROUP, b.DOMAIN_NUM_EXCEED_OF_DOMAIN_GROUP, b.MAC_FILTER_ADDRESS_NUM_EXCEED, b.IP_NUM_EXCEED_OF_IPV6_GROUP, b.IP_NUM_EXCEED_OF_IPV6_PORT_GROUP, b.PORT_NUM_EXCEED_OF_IPV6_PORT_GROUP, b.INVALID_DOMAIN_OR_INVALID_FORMAT_DOMAIN_GROUP, b.INVALID_DOMAIN_TYPE_IN_DOMAIN_GROUP, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createGroupProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/groups/{groupType}/{groupId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    @Operation(summary="Modify an exist group profile template", description="Modify an exist group profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.DUPLICATE_GROUP_NAME, b.INVALID_DOMAIN_TYPE_IN_DOMAIN_GROUP, b.DUPLICATE_MAC_FILTER_GROUP_NAME, b.DUPLICATE_MAC_FILTER_ADDRESS, b.DEFAULT_IP_GROUP_NO_EDITING, b.DEFAULT_DOMAIN_GROUP_NO_EDITING, b.INVALID_DOMAIN_OR_INVALID_FORMAT_DOMAIN_GROUP, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponseWithoutResult> modifyGroupProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="groupType", description="Type of group profile, 0:IP Group; 1:IP Port Group; 2\uff1aMac Group; 3:IPv6 Group; 4:IPv6 Port Group; 5:Country Group; 7:Domain Group.") @PathVariable(name="groupType") String groupType, @Parameter(name="groupId", description="Group profile id.") @PathVariable(name="groupId") String groupId, @RequestBody CreateGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/groups/{groupType}/{groupId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    @Operation(summary="Delete an exist group profile template", description="Delete an exist group profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.MODIFY_GROUP_NOT_EXIST, b.IP_GROUP_USED_IN_QOS_CLASS_RULE, b.IP_PORT_GROUP_USED_IN_ACL, b.IP_PORT_GROUP_USED_IN_POLICY_ROUTING, b.DEFAULT_IP_GROUP_NO_EDITING, b.IP_GROUP_USED_IN_ACL, b.IP_GROUP_USED_IN_URLFILTERING, b.IP_GROUP_USED_IN_TRANSMISSION, b.GROUP_HAS_BEEN_USED_IN_SSID, b.MAC_GROUP_USED_IN_ACL, b.MAC_GROUP_USED_IN_MAC_FILTER, b.IPV6_GROUP_USED_CLASS_RULE, b.IPV6_GROUP_USED_IN_ACL, b.DELETE_GROUP_NOT_EXIST, b.IPV6_PORT_GROUP_USED_IN_ACL, b.COUNTRY_GROUP_USED_IN_ACL, b.DEFAULT_DOMAIN_GROUP_NO_EDITING, b.DOMAIN_GROUP_USED_IN_ACL, b.INVALID_SITE_TEMPLATE_ID})
    public DeferredResult<OperationResponseWithoutResult> deleteGroupProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="type", description="Type of group profile, 0:IP Group; 1:IP Port Group; 2\uff1aMac Group; 3:IPv6 Group; 4:IPv6 Port Group; 5:Country Group; 7:Domain Group.") @PathVariable(name="groupType") String groupType, @Parameter(name="groupId", description="Group profile id.") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get OUI profile template list", description="Get OUI profile template list.(Pagination)")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/oui-profiles"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    public DeferredResult<OperationResponse<OuiGridVO<OuiProfileQueryOpenApiVO>>> getOuiProfileListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get OUI profile template summary list", description="Get OUI profile template summary list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/oui-profiles/all"})
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    public DeferredResult<OperationResponse<List<OuiProfileSummaryOpenApiVO>>> getOuiProfileFullListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create OUI profile template", description="Create OUI profile template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/oui-profiles"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.OUI_NUM_EXCEED, b.DUPLICATE_OUI_IN_PROFILE, b.DUPLICATE_OUI_PROFILE_NAME})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    public DeferredResult<OperationResponse> createOuiProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody OuiProfileOpenApiVO ouiProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ouiProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify OUI Profile template", description="Modify OUI Profile template")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/oui-profiles/{ouiId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.OUI_NUM_EXCEED, b.DUPLICATE_OUI_IN_PROFILE, b.OUI_PROFILE_NOT_EXIST, b.DUPLICATE_OUI_PROFILE_NAME, b.OUI_NUM_EXCEED, b.DUPLICATE_OUI_IN_PROFILE, b.DEVICE_OUI_VLAN_COMBINE_LIMIT_EXCEED})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponseWithoutResult> modifyOuiProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="ouiId", description="OUI ID") @PathVariable(name="ouiId") String ouiId, @RequestBody OuiProfileOpenApiVO ouiProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ouiProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete OUI Profile template", description="Delete OUI Profile template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/oui-profiles/{ouiId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.OUI_PROFILE_NOT_EXIST, b.OUI_PROFILE_IN_USE_BY_OUI_BASED_VLAN, b.OUI_PROFILE_IN_USE_BY_MAC_FILTER})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponseWithoutResult> deleteOuiProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="ouiId", description="OUI ID") @PathVariable(name="ouiId") String ouiId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius"})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    @Operation(summary="Get Radius profile template list", description="Get Radius profile template list of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ})
    public DeferredResult<OperationResponse<List<RadiusProfileOpenApiVO>>> getRadiusProfileListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    @Operation(summary="Create a new Radius profile template", description="Create a new Radius profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.RADIUS_SERVER_IP_INVALID, b.RADIUS_SERVER_IP_INVALID, b.UPDATE_INTERVAL_INVALID, b.ACCOUNTING_PORT_INVALID, b.ACCOUNTING_PSW_INVALID, b.RADIUS_PROFILE_EXISTED, b.RADIUS_PROFILE_REACHED_LIMIT})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createRadiusProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateRadiusProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius/{radiusProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    @Operation(summary="Modify an exist Radius profile template", description="Modify an exist Radius profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.RADIUS_SERVER_IP_INVALID, b.RADIUS_SERVER_IP_INVALID, b.UPDATE_INTERVAL_INVALID, b.ACCOUNTING_PORT_INVALID, b.ACCOUNTING_PSW_INVALID, b.RADIUS_PROFILE_EXISTED, b.RADIUS_PROFILE_NOT_EXISTED, b.FAILED_TO_MODIFY_BUILT_IN_RADIUS_PROFILE, b.BUILT_IN_SERVER_IN_USED, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_SSL_VPN, b.RADIUS_SERVER_AUTH_NUM_LESS_THAN_ACC_NUM, b.FAIL_TO_MODIFY_RADIUS_PROFILE_USED_IN_DOT1X, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_NOT_SUPPORT_DOMAIN})
    public DeferredResult<OperationResponseWithoutResult> modifyRadiusProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="radiusProfileId", description="Radius profile Id") @PathVariable(name="radiusProfileId") String radiusProfileId, @RequestBody CreateRadiusProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius/{radiusProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=14)
    @Operation(summary="Delete an exist Radius profile template", description="Delete an exist Radius profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.FAILED_TO_DELETE_BUILT_IN_RADIUS_PROFILE, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_SSID, b.RADIUS_PROFILED_HAS_BEEN_USED_IN_MACAUTH, b.RADIUS_PROFILED_HAS_BEEN_USED_IN_PORTAL, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_DOT1X, b.SSL_VPN_RADIUS_USED})
    public DeferredResult<OperationResponseWithoutResult> deleteRadiusProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="radiusProfileId", description="Radius profile Id") @PathVariable(name="radiusProfileId") String radiusProfileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius-server/users"})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    @Operation(summary="Get Build-in Radius profile user template list", description="Get Build-in Radius profile user template list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.SITE_TEMPLATE_READ})
    public DeferredResult<OperationResponse<GridVO<RadiusUserOpenApiVO>>> getRadiusUserListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.username", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.username", required=false) String sortsUsername) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius-server/users"})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    @Operation(summary="Create a new Build-in Radius profile user template", description="Get Build-in Radius profile user template list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.RADIUS_USER_NAME_EXISTED, b.RADIUS_USER_NAME_EXISTED_IN_OTHER_SITES, b.RADIUS_USER_REACHED_LIMIT})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createRadiusUserTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateRadiusUserOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius-server/users/{userId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    @Operation(summary="Modify an exist Build-in Radius profile user template", description="Get Build-in Radius profile user template list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.RADIUS_USER_NOT_EXIST, b.RADIUS_USER_NAME_EXISTED, b.RADIUS_USER_NAME_EXISTED_IN_OTHER_SITES})
    public DeferredResult<OperationResponseWithoutResult> modifyRadiusUserTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="userId", description="Build-in Radius profile user Id") @PathVariable(name="userId") String userId, @RequestBody CreateRadiusUserOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/radius-server/users/{userId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    @Operation(summary="Delete an exist Build-in Radius profile user template", description="Get Build-in Radius profile user template list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    public DeferredResult<OperationResponseWithoutResult> deleteRadiusUserTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="userId", description="Build-in Radius profile user Id") @PathVariable(name="userId") String userId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get PPSK profile templates list", description="Get PPSK profile templates list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profiles"})
    @com.a.a.a.a.a(a=19)
    @a(b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<List<PPSKProfileBriefInfoOpenApiVO>>> getPPSKProfilesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="type", description="PPSK Profile type, should be a value as follows: 0: PPSK Without RADIUS; 1: PPSK With Built-In RADIUS") @RequestParam(name="type") Integer type) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create PPSK profile template", description="Create PPSK profile template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profile"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createPPSKProfileTemplate(@RequestBody PPSKProfileOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Modify PPSK profile template", description="Modify PPSK profile template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyPPSKProfileTemplate(@RequestBody PPSKProfileOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Auto Create PSK templates", description="Auto Create PSK templates")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profile/generate-psk"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    public DeferredResult<List<AutoCreatePSKOpenApiVO>> autoCreatePPSKTemplate(@RequestBody PPSKAutoTypeOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Delete PPSK profile template", description="Delete PPSK profile template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePPSKProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete All PPSK profile templates", description="Delete All PPSK profile templates")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profiles"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.FAILED_TO_DELETE_ALL_PPSK_PROFILES})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteAllPPSKProfilesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get PPSK profile template detail", description="Get PPSK profile template detail")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/ppsk-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponse<PPSKProfileVO>> getPPSKProfileDetailTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get time range profile template list", description="Get time range profile template list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/time-range-profiles"})
    @a(b={k.SITE_TEMPLATE_READ})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    public DeferredResult<OperationResponse<List<TimeRangeProfileOpenApiVO>>> getTimeRangeListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create time range profile template", description="Create time range profile template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/time-range-profiles"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.TIMERANGE_NOT_ALLOWED_EMPTY, b.PROFILE_TIME_LOGIC_ERROR, b.TIME_RANGE_SCHEDULE_PARAM_ERROR, b.DUPLICATE_SCHEDULER_PROFILE_NAME, b.SCHEDULE_NUM_EXCEED, b.TIME_RANGE_RULE_NUM_EXCEED})
    @com.a.a.a.a.a(a=27)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createTimeRangeProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateTimeRangeProfileOpenApiVO createTimeRangeProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createTimeRangeProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify time range profile template", description="Modify time range profile template")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/time-range-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.TIMERANGE_NOT_ALLOWED_EMPTY, b.PROFILE_TIME_LOGIC_ERROR, b.TIME_RANGE_SCHEDULE_PARAM_ERROR, b.DUPLICATE_SCHEDULER_PROFILE_NAME, b.TIME_RANGE_RULE_NUM_EXCEED})
    @com.a.a.a.a.a(a=28)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTimeRangeProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId, @RequestBody UpdateTimeRangeProfileOpenApiVO updateTimeRangeProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateTimeRangeProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete time range profile template", description="Delete time range profile template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/time-range-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.DELETE_SCHEDULER_PROFILE_NOT_EXIST, b.TIME_RANGE_HAS_BEEN_USED_IN_SSID, b.TIME_RANGE_HAS_BEEN_USED_IN_POESCH, b.TIME_RANGE_HAS_BEEN_USED_IN_PORTSCH, b.TIME_RANGE_HAS_BEEN_USED_IN_ACL, b.TIME_RANGE_HAS_BEEN_USED_IN_IPS, b.TIME_RANGE_HAS_BEEN_USED_IN_DPI})
    @com.a.a.a.a.a(a=29)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteTimeRangeProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get rate limit profile template list", description="Get rate limit profile template list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/rate-limit-profiles"})
    @a(b={k.SITE_TEMPLATE_READ}, a={b.INVALID_SITE_ID})
    @com.a.a.a.a.a(a=30)
    @ResponseBody
    public DeferredResult<OperationResponse<List<RateLimitProfileOpenApiVO>>> getRateLimitProfileListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create rate limit profile template", description="Create rate limit profile template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/rate-limit-profiles"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.DUPLICATE_RATE_LIMIT_NAME, b.RATE_LIMIT_NUM_EXCEED})
    @com.a.a.a.a.a(a=31)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createRateLimitProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateRateLimitProfileOpenApiVO createRateLimitProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createRateLimitProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify rate limit profile template", description="Modify rate limit profile template")
    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/rate-limit-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.RATE_LIMIT_NOT_EXIST, b.DUPLICATE_RATE_LIMIT_NAME})
    @com.a.a.a.a.a(a=32)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyRateLimitProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId, @RequestBody UpdateRateLimitProfileOpenApiVO updateRateLimitProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateRateLimitProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete rate limit profile template", description="Delete rate limit profile template")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/rate-limit-profile/{profileId}"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.RATE_LIMIT_NOT_EXIST, b.RATE_LIMIT_IS_DEFAULT, b.RATE_LIMIT_IN_USE_BY_LOCALUSER, b.RATE_LIMIT_IN_USE_BY_VOUCHER, b.RATE_LIMIT_IN_USE_BY_CLIENT})
    @com.a.a.a.a.a(a=33)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteRateLimitProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/ldap"})
    @ResponseBody
    @com.a.a.a.a.a(a=34)
    @Operation(summary="Get LDAP profile template list", description="Get LDAP profile template list of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<List<LdapProfileOpenApiVO>>> getLdapProfileListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/ldap"})
    @ResponseBody
    @com.a.a.a.a.a(a=35)
    @Operation(summary="Create a new LDAP profile template", description="Create a new LDAP profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.LDAP_PROFILE_NAME_EXISTED, b.LDAP_PROFILE_NOT_EXISTED})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createLdapProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody CreateLdapProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/ldap/{ldapProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=36)
    @Operation(summary="Modify an exist LDAP profile template", description="Modify an exist LDAP profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.LDAP_PROFILE_HAS_BEEN_USED_IN_VPN})
    public DeferredResult<OperationResponseWithoutResult> modifyLdapProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="ldapProfileId", description="LDAP profile ID.") @PathVariable(name="ldapProfileId") String ldapProfileId, @RequestBody CreateLdapProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/ldap/{ldapProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=37)
    @Operation(summary="Delete an exist LDAP profile template", description="Delete an exist LDAP profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    public DeferredResult<OperationResponseWithoutResult> deleteLdapProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="ldapProfileId", description="LDAP profile ID.") @PathVariable(name="ldapProfileId") String ldapProfileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/apn"})
    @ResponseBody
    @com.a.a.a.a.a(a=38)
    @Operation(summary="Get APN profile template list", description="Get APN profile template list of the site with the given omadacId and siteId.")
    @a(b={k.SITE_TEMPLATE_READ}, a={b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<List<ApnProfileOpenApiVO>>> getApnProfileListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/apn"})
    @ResponseBody
    @com.a.a.a.a.a(a=39)
    @Operation(summary="Create a new APN profile template", description="Create a new APN profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.APN_PROFILE_NUM_EXCEED, b.DUPLICATE_PROFILE_NAME, b.LTE_WAN_IPV6_ENABLE})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createApnProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody ApnProfileConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/apn/{profileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=40)
    @Operation(summary="Modify an exist APN profile template", description="Modify an exist APN profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.SITE_TEMPLATE_BUSY, b.APN_PROFILE_NUM_EXCEED, b.DUPLICATE_PROFILE_NAME, b.LTE_WAN_IPV6_ENABLE})
    public DeferredResult<OperationResponseWithoutResult> modifyApnProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="APN profile ID.") @PathVariable(name="profileId") String profileId, @RequestBody ApnProfileConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/profiles/apn/{profileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=41)
    @Operation(summary="Delete an exist APN profile template", description="Delete an exist APN profile template with the given params.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    public DeferredResult<OperationResponseWithoutResult> deleteApnProfileTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="profileId", description="APN profile ID.") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

