/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.cliTemplate.CliConfigTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.cliTemplate.CliTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.cliTemplate.DeleteCliTemplateOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.cliTemplate.ModifyCliTemplateOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="CLI (Template)")
@RestController
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class CliTemplateOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CliTemplateOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get the CLI template configuration list", description="Get the CLI template configuration list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/cli/configs/cli-type/{cliType}/device-type/{deviceType}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_TEMPLATE_BUSY}, b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<GridVO<CliTemplateOpenApiVO>>> getGridCliTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType, @Parameter(name="deviceType", description="Device Type. Supported type: switch.") @PathVariable(name="deviceType") String deviceType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the CLI template configuration content", description="Get the CLI template configuration content")
    @GetMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/cli/config/cli-type/{cliType}/config-id/{configId}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_TEMPLATE_BUSY}, b={k.SITE_TEMPLATE_READ})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<CliConfigTemplateOpenApiVO>> getCliConfigTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String sitetemplateId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType, @Parameter(name="configId", description="CLI Config ID") @PathVariable(name="configId") String configId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create a new CLI template configuration", description="Create a new CLI template configuration")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/cli/config/cli-type/{cliType}/save"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_TEMPLATE_BUSY}, b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> createCliConfigTemplate(@RequestBody ModifyCliTemplateOpenApiVO modifyCliTemplateOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyCliTemplateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify the CLI template configuration content", description="Modify the CLI template configuration content")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/cli/config/cli-type/{cliType}/config-id/{configId}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_TEMPLATE_BUSY}, b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> modifyCliConfigTemplate(@RequestBody ModifyCliTemplateOpenApiVO modifyCliTemplateOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType, @Parameter(name="configId", description="CLI Config ID") @PathVariable(name="configId") String configId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyCliTemplateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete the CLI template configuration", description="Delete the CLI template configuration")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/cli/configs/cli-type/{cliType}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_TEMPLATE_BUSY}, b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponseWithoutResult> deleteCliConfigTemplate(@RequestBody DeleteCliTemplateOpenApiVO deleteCliTemplateOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deleteCliTemplateOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Apply the CLI template configuration", description="Apply the CLI template configuration")
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/cli/configs/config-id/{configId}/apply"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_TEMPLATE_BUSY, b.DEVICE_BUSY}, b={k.SITE_TEMPLATE_WRITE})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponseWithoutResult> applyCliConfigTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="configId", description="CLI Config ID") @PathVariable(name="configId") String configId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

