/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sitetemplate.setting;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.SiteTemplateSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.MacAuthOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.UpdateMacAuthOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.WlanSimpleOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.PortalResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ImportedPortalPageResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalCustomizationPageResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalDetailResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalPictureOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.PortalPictureVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Authentication (Template)")
@RestController
@b
@Conditional(value={SiteTemplateSwaggerMatchCondition.class})
public class AuthenticationTemplateOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get portal list in a site template ", description="Get portal list with the given omadacId, siteTemplateId.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portals"})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<List<PortalResOpenApiVO>>> getPortalListTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Upload portal picture in a site template ", description="Upload portal picture in a site template ")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal/pics"}, consumes={"multipart/form-data"})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<PortalPictureVO>> uploadPortalPicTemplate(@Parameter(name="type", description="Portal picture type: background/logo/advertisement.") @RequestParam(name="type", required=true) String type, @RequestPart(value="file", required=false) @Parameter(name="file", description="Portal picture file.") MultipartFile file, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        PortalPictureOpenApiVO setting = new PortalPictureOpenApiVO();
        setting.setType(type);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setting), request, response, omadacId);
    }

    @Operation(summary="Import portal page in a site template", description="Import portal page in a site template")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal/page"}, consumes={"multipart/form-data"})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponse<ImportedPortalPageResOpenApiVO>> uploadPortalPageTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestPart(value="file") @Parameter(name="file", description="Portal page file.") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create portal template", description="Create new portal template")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal"})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createPortalTemplate(@RequestBody PortalSettingOpenApiVO setting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setting), request, response, omadacId);
    }

    @Operation(summary="Modify portal template", description="Modify the portal with the portal ID")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal/{portalId}"})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyPortalTemplate(@RequestBody PortalSettingOpenApiVO setting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setting), request, response, omadacId);
    }

    @Operation(summary="Delete portal template", description="Delete portal setting with the given portal ID")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal/{portalId}"})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePortalTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get portal template detail", description="Get portal template detail information with the given omadacId, siteTemplateId and portalId.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal/{portalId}"})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponse<PortalDetailResOpenApiVO>> getPortalTemplateDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get portal template customization", description="Get portal template customization information with the given omadacId, siteTemplateId and portalId.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/portal/{portalId}/customization"})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponse<PortalCustomizationPageResOpenApiVO>> getPortalTemplateCustomization(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/mac-auth"})
    @ResponseBody
    @a(a=13)
    @Operation(summary="Get site MAC-Based Authentication Template info", description="Get MAC-Based Authentication setting info of the siteTemplate with the given omadacId and siteTemplateId.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ}, a={com.tplink.smb.omada.common.g.b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<MacAuthOpenApiVO>> getMacAuthSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/mac-auth"})
    @ResponseBody
    @a(a=14)
    @Operation(summary="Update site MAC-Based Authentication Template info", description="Update MAC-Based Authentication setting info of the siteTemplate with the given parameters.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_WRITE}, a={com.tplink.smb.omada.common.g.b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponseWithoutResult> updateMacAuthSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @RequestBody UpdateMacAuthOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/mac-auth/ssids"})
    @ResponseBody
    @a(a=15)
    @Operation(summary="Get ssids that support MAC auth Template", description="Get ssid list that support MAC-Based Authentication Template with the given omadacId and siteTemplateId.")
    @com.tplink.smb.omada.common.m.a(b={k.SITE_TEMPLATE_READ}, a={com.tplink.smb.omada.common.g.b.SITE_TEMPLATE_BUSY})
    public DeferredResult<OperationResponse<List<WlanSimpleOpenApiVO>>> getMacAuthSsids(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

