/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting.transmission;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.UserInfoBriefDTO;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.annotation.ReqAttribute;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.BatchOspfInterfaceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.BatchOspfProcessOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfDeviceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfInterfaceConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfInterfaceOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfProcessConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.OspfProcessOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.ospf.dto.VlanInterfaceOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="OSPF")
@RestController
@b(a=50)
public class OspfOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get Ospf Process list", description="Get Ospf Process list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/process"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ}, a={})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<GridVO<OspfProcessOpenApiVO>>> getGridOspfProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Ospf Interface list", description="Get Ospf Interface list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/interface"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ}, a={})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<GridVO<OspfInterfaceOpenApiVO>>> getGridOspfInterface(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Ospf Device list", description="Get Ospf Device list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/device"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ}, a={})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponse<List<OspfDeviceOpenApiVO>>> getOspfDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Switch Vlan Interface list", description="Get Switch Vlan Interface list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/vlan-interface/switches/{switchMac}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ}, a={})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponse<List<VlanInterfaceOpenApiVO>>> getOswVlanIf(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="switchMac", description="Switch MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(value="switchMac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create Ospf Process", description="Create Ospf Process.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/process"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.OSPF_PROCESS_ROUTER_ID_INVALID, com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.DEVICE_DOES_NOT_SUPPORT_OSPF, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_SIZE_LIMITED, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_ID_EXISTED, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_AREA_TYPE_INVALID, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_AREA_ID_CANNOT_BE_DUPLICATE, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_NETWORK_IP_INVALID, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_NETWORK_DUPLICATE})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponseWithoutResult> createOspfProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody OspfProcessConfigOpenApiVO vo, @ReqAttribute UserInfoBriefDTO userInfoBriefDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Create Ospf Interface", description="Create Ospf Interface.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/interface"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.DEVICE_DOES_NOT_SUPPORT_OSPF, com.tplink.smb.omada.common.g.b.DEVICE_DOES_NOT_SUPPORT_LOOPBACK_INTERFACE, com.tplink.smb.omada.common.g.b.OSPF_INTERFACE_ID_EXISTED, com.tplink.smb.omada.common.g.b.OSPF_INTERFACE_DEAD_INTERVAL_CANNOT_BE_SMALLER_THAN_HELLO_INTERVAL})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponseWithoutResult> createOspfInterface(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody OspfInterfaceConfigOpenApiVO vo, @ReqAttribute UserInfoBriefDTO userInfoBriefDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Modify Ospf Process", description="Modify Ospf Process.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/process/{ospfProcessId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.OSPF_PROCESS_ROUTER_ID_INVALID, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_AREA_TYPE_INVALID, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_AREA_ID_CANNOT_BE_DUPLICATE, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_NETWORK_IP_INVALID, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_NETWORK_DUPLICATE, com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.DEVICE_DOES_NOT_SUPPORT_OSPF, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.DEVICE_NAME_CANNOT_BE_CHANGED, com.tplink.smb.omada.common.g.b.OSPF_PROCESS_ID_CANNOT_BE_MODIFIED})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponseWithoutResult> modifyOspfProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="ospfProcessId", description="Ospf Process ID") @PathVariable(value="ospfProcessId") String ospfProcessId, @RequestBody OspfProcessConfigOpenApiVO ospfProcessConfigOpenApiVO, @ReqAttribute UserInfoBriefDTO userInfoBriefDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ospfProcessConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify Ospf Interface", description="Modify Ospf Interface.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/interface/{ospfInterfaceId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.SWITCH_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.DEVICE_DOES_NOT_SUPPORT_OSPF, com.tplink.smb.omada.common.g.b.DEVICE_DOES_NOT_SUPPORT_LOOPBACK_INTERFACE, com.tplink.smb.omada.common.g.b.OSPF_INTERFACE_DOES_NOT_EXIST, com.tplink.smb.omada.common.g.b.DEVICE_NAME_CANNOT_BE_CHANGED, com.tplink.smb.omada.common.g.b.OSPF_INTERFACE_DEAD_INTERVAL_CANNOT_BE_SMALLER_THAN_HELLO_INTERVAL, com.tplink.smb.omada.common.g.b.OSPF_INTERFACE_ID_EXISTED})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponseWithoutResult> modifyOspfInterface(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="ospfInterfaceId", description="Ospf Interface ID") @PathVariable(value="ospfInterfaceId") String ospfInterfaceId, @RequestBody OspfInterfaceConfigOpenApiVO ospfInterfaceConfigOpenApiVO, @ReqAttribute UserInfoBriefDTO userInfoBriefDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ospfInterfaceConfigOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete Ospf Process", description="Delete Ospf Process.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/switches/{switchMac}/process/{ospfProcessId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={})
    @ResponseBody
    @a(a=9)
    public DeferredResult<OperationResponseWithoutResult> deleteOspfProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="switchMac", description="Switch MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(value="switchMac") String mac, @Parameter(name="ospfProcessId", description="Ospf Process ID") @PathVariable(value="ospfProcessId") String ospfProcessId, @ReqAttribute UserInfoBriefDTO userInfoBriefDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete Ospf Interface", description="Delete Ospf Interface.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/switches/{switchMac}/interface/{ospfInterfaceId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={})
    @ResponseBody
    @a(a=10)
    public DeferredResult<OperationResponseWithoutResult> deleteOspfInterface(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="switchMac", description="Switch MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(value="switchMac") String mac, @Parameter(name="ospfInterfaceId", description="Ospf Interface ID") @PathVariable(value="ospfInterfaceId") String ospfInterfaceId, @ReqAttribute UserInfoBriefDTO userInfoBriefDTO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Batch Delete Ospf Process", description="Batch Delete Ospf Process.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/process/batch-delete"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={})
    @ResponseBody
    @a(a=11)
    public DeferredResult<OperationResponseWithoutResult> batchDeleteOspfProcess(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody BatchOspfProcessOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Batch Delete Ospf Interface", description="Batch Delete Ospf Interface.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ospf/interface/batch-delete"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.DEVICES_WRITE}, a={})
    @ResponseBody
    @a(a=12)
    public DeferredResult<OperationResponseWithoutResult> batchDeleteOspfInterface(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody BatchOspfInterfaceOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }
}

