/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting.transmission;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.AlgOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.OtoNatInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.OtoNatOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.PortForwardingInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.transmission.nat.dto.PortForwardingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.dto.PortForwardingGridVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="NAT")
@RestController
public class NatOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NatOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get port forwarding list", description="Get port forwarding list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/port-forwardings"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<PortForwardingGridVO<PortForwardingInfoOpenApiVO>>> getPortForwardingList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new port forwarding", description="Create new port forwarding.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/port-forwardings"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.PF_UNSUPPORT_WAN_IP, b.PF_UNSUPPORT_VIRTUAL_WAN, b.LIMITED_IP_ADDRESS_CONFLICT, b.CONFLICT_PF, b.CONFLICT_PF_EXTERNAL_PORT, b.CONFLICT_PF_EXTERNAL_PORT_AND_WAN_PORT})
    @a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createPortForwarding(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody PortForwardingOpenApiVO portForwardingOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portForwardingOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify port forwarding", description="Modify port forwarding.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/port-forwardings/{portForwardingId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.PF_UNSUPPORT_WAN_IP, b.PF_UNSUPPORT_VIRTUAL_WAN, b.LIMITED_IP_ADDRESS_CONFLICT, b.CONFLICT_PF, b.CONFLICT_PF_EXTERNAL_PORT, b.CONFLICT_PF_EXTERNAL_PORT_AND_WAN_PORT})
    @a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyPortForwarding(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="portForwardingId") String portForwardingId, @RequestBody PortForwardingOpenApiVO portForwardingOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portForwardingOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete port forwarding", description="Delete port forwarding.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/port-forwardings/{portForwardingId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePortForwarding(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="portForwardingId") String portForwardingId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get ALG Info", description="Get ALG Info.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/alg"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse<AlgOpenApiVO>> getAlg(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify ALG setting", description="Modify ALG setting.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/alg"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyAlg(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody AlgOpenApiVO algOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)algOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get One-to-One NAT list", description="Get One-to-One NAT list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/one-to-one-nat"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<OtoNatInfoOpenApiVO>>> getGridOtoNats(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new One-to-One NAT", description="Create new One-to-One NAT.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/one-to-one-nat"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createOtoNat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody OtoNatOpenApiVO otoNatOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)otoNatOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify One-to-One NAT", description="Modify One-to-One NAT.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/one-to-one-nat/{otonatId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyOtoNat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="otonatId") String otonatId, @RequestBody OtoNatOpenApiVO otoNatOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)otoNatOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete One-to-One NAT", description="Delete One-to-One NAT.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/nat/one-to-one-nat/{otonatId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteOtoNat(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="otonatId") String otonatId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

