/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting.sim;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.SupportSmsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.mailserver.MailServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota.CorrectQuotaOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.quota.SimQuotaSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.ExportMessageOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.InboxMessageOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.OperateMessageOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.OutboxMessageOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.OutboxMessageOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.ReceiveMessageOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smsmessage.SendMessageOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smssettings.SmsPolicySettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.sim.dto.smssettings.SmsRouterCommandOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="SIM")
@RestController
@b(a=3)
public class SimManageOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimManageOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get support SMS", description="Get SIM card whether supports SMS.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/support"})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<SupportSmsOpenApiVO>> getSupportSms(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get SIM data setting", description="Get SIM data setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/quota"})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<SimQuotaSettingOpenApiVO>> querySimQuotaSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get one of Dual-SIM card's SIM data setting", description="Get SIM data setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/quota/{simCard}"})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponse<SimQuotaSettingOpenApiVO>> querySimCardQuotaSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="simCard", description="SIM card. 1: SIM1; 2: SIM2.") @PathVariable(name="simCard") String simCard) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SIM data setting", description="Modify SIM data setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/quota"})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> modifySimQuotaSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SimQuotaSettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Correct SIM data", description="Correct SIM data.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/correct"})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponseWithoutResult> correctSimQuota(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CorrectQuotaOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get SMS inbox message", description="Get SMS inbox message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/inbox"})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponse<GridVO<ReceiveMessageOpenApiVO>>> getGridSmsInboxMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get one of Dual-SIM card's SMS inbox message", description="Get SMS inbox message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/inbox/{simCard}"})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponse<GridVO<ReceiveMessageOpenApiVO>>> getGridSimCardSmsInboxMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="simCard", description="SIM card. 1: SIM1; 2: SIM2.") @PathVariable(name="simCard") String simCard) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get SMS outbox message", description="Get SMS outbox message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/outbox"})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponse<GridVO<ReceiveMessageOpenApiVO>>> getGridSmsOutboxMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get one of Dual-SIM card's SMS outbox message", description="Get SMS outbox message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/outbox/{simCard}"})
    @ResponseBody
    @a(a=9)
    public DeferredResult<OperationResponse<GridVO<ReceiveMessageOpenApiVO>>> getGridSimCardSmsOutboxMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="simCard", description="SIM card. 1: SIM1; 2: SIM2.") @PathVariable(name="simCard") String simCard) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Send SMS message", description="Send SMS message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.SIM_CANNOT_SEND, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY, com.tplink.smb.omada.common.g.b.GATEWAY_RESPONSE_FAIL}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/send"})
    @ResponseBody
    @a(a=10)
    public DeferredResult<OperationResponseWithoutResult> sendSmsMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SendMessageOpenApiVO sendMessageOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)sendMessageOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Operate SMS message", description="Operate SMS message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.SIM_CANNOT_SEND, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY, com.tplink.smb.omada.common.g.b.GATEWAY_RESPONSE_FAIL}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/operate"})
    @ResponseBody
    @a(a=11)
    public DeferredResult<OperationResponseWithoutResult> operateSmsMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody OperateMessageOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Export SMS message", description="Export SMS message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY, com.tplink.smb.omada.common.g.b.SIM_CANNOT_EXPORT, com.tplink.smb.omada.common.g.b.SIM_NO_SMS_CANNOT_EXPORT}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/export"})
    @ResponseBody
    @a(a=12)
    public DeferredResult<OperationResponseWithoutResult> exportSmsMessage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ExportMessageOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Query SMS policy setting", description="Query SMS policy setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/policy"})
    @ResponseBody
    @a(a=13)
    public DeferredResult<OperationResponse<SmsPolicySettingOpenApiVO>> querySmsPolicySetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SMS policy setting", description="Modify SMS policy setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.MAIL_SERVER_DOES_NOT_CONFIG, com.tplink.smb.omada.common.g.b.SETTING_OVERRIDE}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/policy"})
    @ResponseBody
    @a(a=14)
    public DeferredResult<OperationResponseWithoutResult> modifySmsPolicySetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SmsPolicySettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Query SMS router command", description="Query SMS router command.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/router-command"})
    @ResponseBody
    @a(a=15)
    public DeferredResult<OperationResponse<SmsRouterCommandOpenApiVO>> querySmsRouterCommand(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SMS router command", description="Modify SMS router command.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.SETTING_OVERRIDE}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/sim/sms/router-command"})
    @ResponseBody
    @a(a=16)
    public DeferredResult<OperationResponseWithoutResult> modifySmsRouterCommand(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SmsRouterCommandOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get mail server", description="Get mail server.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MAIL_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/mails"})
    @ResponseBody
    @a(a=17)
    public DeferredResult<OperationResponse<MailServerOpenApiVO>> getMailServer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create mail server", description="Create mail server.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MAIL_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.MAIL_SERVER_SIZE_LIMITED}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/mails"})
    @ResponseBody
    @a(a=18)
    public DeferredResult<OperationResponseWithoutResult> createMailServer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody MailServerOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify mail server", description="Modify mail server.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MAIL_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.MAIL_SERVER_DOES_NOT_EXIST}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/mails/{mailId}"})
    @ResponseBody
    @a(a=19)
    public DeferredResult<OperationResponseWithoutResult> modifyMailServer(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mailId", description="Mail ID") @PathVariable(name="mailId") String mailId, @RequestBody MailServerOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get support SMS", description="Get SIM card whether supports SMS.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/support"})
    @ResponseBody
    @a(a=20)
    public DeferredResult<OperationResponse<SupportSmsOpenApiVO>> getSupportSmsByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Query SMS policy setting by mac", description="Query SMS policy setting by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/policy"})
    @ResponseBody
    @a(a=21)
    public DeferredResult<OperationResponse<SmsPolicySettingOpenApiVO>> querySmsPolicySettingByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SMS policy setting", description="Modify SMS policy setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.MAIL_SERVER_DOES_NOT_CONFIG, com.tplink.smb.omada.common.g.b.SETTING_OVERRIDE}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/policy"})
    @ResponseBody
    @a(a=22)
    public DeferredResult<OperationResponseWithoutResult> modifySmsPolicySettingByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody SmsPolicySettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Query SMS router command by mac", description="Query SMS router command by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/router-command"})
    @ResponseBody
    @a(a=23)
    public DeferredResult<OperationResponse<SmsRouterCommandOpenApiVO>> querySmsRouterCommandByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SMS router command by mac", description="Modify SMS router command by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.SETTING_OVERRIDE}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/router-command"})
    @ResponseBody
    @a(a=24)
    public DeferredResult<OperationResponseWithoutResult> modifySmsRouterCommandByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody SmsRouterCommandOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get mail server by mac", description="Get mail server by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MAIL_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/mails"})
    @ResponseBody
    @a(a=25)
    public DeferredResult<OperationResponse<MailServerOpenApiVO>> getMailServerByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create mail server by mac", description="Create mail server by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.MAIL_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.MAIL_SERVER_SIZE_LIMITED}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/mails"})
    @ResponseBody
    @a(a=26)
    public DeferredResult<OperationResponseWithoutResult> createMailServerByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody MailServerOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get SIM data setting by mac", description="Get SIM data setting by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/quota"})
    @ResponseBody
    @a(a=27)
    public DeferredResult<OperationResponse<SimQuotaSettingOpenApiVO>> querySimQuotaSettingByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get one of Dual-SIM card's SIM data setting by mac", description="Get SIM data setting by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/quota/{simCard}"})
    @ResponseBody
    @a(a=28)
    public DeferredResult<OperationResponse<SimQuotaSettingOpenApiVO>> querySimCardQuotaSettingByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @Parameter(name="simCard", description="SIM card. 1: SIM1; 2: SIM2.") @PathVariable(name="simCard") String simCard) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SIM data setting by mac", description="Modify SIM data setting by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/quota"})
    @ResponseBody
    @a(a=29)
    public DeferredResult<OperationResponseWithoutResult> modifySimQuotaSettingByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody SimQuotaSettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get SMS inbox message by mac", description="Get SMS inbox message by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/inbox"})
    @ResponseBody
    @a(a=30)
    public DeferredResult<OperationResponse<GridVO<InboxMessageOpenApiVO>>> getGridSmsInboxMessageByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get one of Dual-SIM card's SMS inbox message by mac", description="Get SMS inbox message by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/inbox/{simCard}"})
    @ResponseBody
    @a(a=31)
    public DeferredResult<OperationResponse<GridVO<InboxMessageOpenApiVO>>> getGridSimCardSmsInboxMessageByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @Parameter(name="simCard", description="SIM card. 1: SIM1; 2: SIM2.") @PathVariable(name="simCard") String simCard) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get SMS outbox message by mac", description="Get SMS outbox message by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/outbox"})
    @ResponseBody
    @a(a=32)
    public DeferredResult<OperationResponse<OutboxMessageOpenApiGridVO<OutboxMessageOpenApiVO>>> getGridSmsOutboxMessageByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get one of Dual-SIM card's SMS outbox message by mac", description="Get SMS outbox message by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT}, b={k.NETWORK_READ, k.DEVICES_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/outbox/{simCard}"})
    @ResponseBody
    @a(a=33)
    public DeferredResult<OperationResponse<OutboxMessageOpenApiGridVO<OutboxMessageOpenApiVO>>> getGridSimCardSmsOutboxMessageByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @Parameter(name="simCard", description="SIM card. 1: SIM1; 2: SIM2.") @PathVariable(name="simCard") String simCard) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Send SMS message", description="Send SMS message.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.SIM_CANNOT_SEND, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY, com.tplink.smb.omada.common.g.b.GATEWAY_RESPONSE_FAIL}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/send"})
    @ResponseBody
    @a(a=34)
    public DeferredResult<OperationResponseWithoutResult> sendSmsMessageByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody SendMessageOpenApiVO sendMessageOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)sendMessageOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Operate SMS message by mac", description="Operate SMS message by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.SIM_CANNOT_SEND, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY, com.tplink.smb.omada.common.g.b.GATEWAY_RESPONSE_FAIL}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/operate"})
    @ResponseBody
    @a(a=35)
    public DeferredResult<OperationResponseWithoutResult> operateSmsMessageByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody OperateMessageOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Export SMS message by mac", description="Export SMS message by mac.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT, com.tplink.smb.omada.common.g.b.WANNETWORK_NOT_CONNECT, com.tplink.smb.omada.common.g.b.GATEWAY_NOT_SUPPORT_DUAL_SIM_STANDBY, com.tplink.smb.omada.common.g.b.SIM_CANNOT_EXPORT, com.tplink.smb.omada.common.g.b.SIM_NO_SMS_CANNOT_EXPORT}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/sms/export"})
    @ResponseBody
    @a(a=36)
    public DeferredResult<OperationResponseWithoutResult> exportSmsMessageBymac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody ExportMessageOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Correct SIM data", description="Correct SIM data.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.SIM_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/sim/correct"})
    @ResponseBody
    @a(a=37)
    public DeferredResult<OperationResponseWithoutResult> correctSimQuotaByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody CorrectQuotaOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }
}

