/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting.security;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.AddAllowListOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.BlockListOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.EditAllowListOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.IpsInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.IpsSignatureConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.ips.vo.IpsSignatureOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="IDS/IPS")
@RestController
@b(a=34)
public class IpsOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpsOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get site IDS/IPS config", description="Get site IDS/IPS config")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<IpsInfoOpenApiVO>> getIpsConfig(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify site IDS/IPS config", description="Modify site IDS/IPS config")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.IPS_NOT_SUPPORT})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse> modifyIpsConfig(@RequestBody IpsInfoOpenApiVO ipsVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ipsVO), request, response, omadacId);
    }

    @Operation(summary="Get signature list", description="Get signature list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/signature"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponse<GridVO<IpsSignatureOpenApiVO>>> getGridSignature(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify signature", description="Modify signature")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/signature/{signId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponse> modifySignature(@RequestBody IpsSignatureConfigOpenApiVO ipsSignatureConfigVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="signId", description="Unique Signature ID") @PathVariable(value="signId") String signId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ipsSignatureConfigVO), request, response, omadacId);
    }

    @Operation(summary="Delete signature", description="Delete signature")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/signature/{signId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponse> deleteSignature(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(value="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="signId", description="Unique Signature ID") @PathVariable(value="signId") String signId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid IPS block list", description="Obtain the grid IPS block list.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/grid/block-list"})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponse<GridVO<BlockListOpenApiVO>>> getGridBlockList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field Name/Source Ip/Destination") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete block list", description="Delete block list by entry id.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/block-list/{entryId}"})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponse> deleteBlockList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="entryId", description="Block entry ID") @PathVariable(name="entryId") String entryId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get grid ips allow list", description="Obtain grid allow list.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/grid/allow-list"})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponse> getGridAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field IP / Subnet") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new allow list", description="Create new allow list.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.ALLOW_LIST_REACHED_LIMIT, com.tplink.smb.omada.common.g.b.IPS_NOT_SUPPORT})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/allow-list"})
    @ResponseBody
    @a(a=9)
    public DeferredResult<OperationResponse> createAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody AddAllowListOpenApiVO addAllowListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)addAllowListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Edit allow list", description="Modify an allow list entry.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={com.tplink.smb.omada.common.g.b.IPS_NOT_SUPPORT})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/allow-list"})
    @ResponseBody
    @a(a=10)
    public DeferredResult<OperationResponse> editAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody EditAllowListOpenApiVO editAllowListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)editAllowListOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete allow list", description="Delete allow List by entry id.")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/network-security/ips/allow-list/{entryId}"})
    @ResponseBody
    @a(a=11)
    public DeferredResult<OperationResponse> deleteAllowList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="entryId", description="Allow entry ID") @PathVariable(name="entryId") String entryId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

