/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting.profiles;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo.CertProfileDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo.CertProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo.CertProfileRequestOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo.DeleteCertOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo.UploadCertRequestOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cert.vo.UploadCertResponseOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="CertProfiles")
@RestController
@b(a=69)
public class CertProfileOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertProfileOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/cert-profiles"})
    @ResponseBody
    @a(a=1)
    @Operation(summary="Get grid certificate profile list", description="Get grid certificate profile list.(Pagination).")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ})
    public DeferredResult<OperationResponse<CertProfileOpenApiVO>> getGridCertProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="filters.type", description="Filter query parameters, support field type, it should be a value as follows: 0: CA Cert; 1: Client Cert.") @RequestParam(name="filters.type", required=false) Integer filtersType, @Parameter(name="filters.status", description="Filter query parameters, support field status, it should be a value as follows: 0: Normal; 1: Expired Soon; 2: Expired") @RequestParam(name="filters.status", required=false) Integer filtersStatus, @Parameter(name="searchKey", description="Fuzzy query parameters, support field Name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/cert-profiles/{certId}"})
    @ResponseBody
    @a(a=2)
    @Operation(summary="Get a certificate profile detail", description="Get a certificate profile detail with the given params.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_READ, k.MSP_SETTINGS_READ, k.NETWORK_READ})
    public DeferredResult<OperationResponse<CertProfileDetailOpenApiVO>> getCertProfileDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="certId", description="Cert profile ID") @PathVariable(name="certId") String certId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/files/sites/{siteId}/setting/profiles/cert-profiles/ca-cert"})
    @ResponseBody
    @a(a=3)
    @Operation(summary="Upload CA profile file", description="Upload CA profile file of the omadac with the given omadacId.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SYSTEM_BUSY, com.tplink.smb.omada.common.g.b.CERT_FILE_TOO_LARGE, com.tplink.smb.omada.common.g.b.CERT_FILE_INVALID, com.tplink.smb.omada.common.g.b.ADD_CER_SAVE_FAIL})
    public DeferredResult<OperationResponse<UploadCertResponseOpenApiVO>> uploadCaCertFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="data", description="Certificate profile file name", required=true) @RequestParam(name="data") String fileName, @Parameter(name="file", description="Certificate profile file", required=true) @RequestParam(name="file") MultipartFile file) {
        UploadCertRequestOpenApiVO requestOpenApiVO = new UploadCertRequestOpenApiVO(fileName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)requestOpenApiVO), request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/files/sites/{siteId}/setting/profiles/cert-profiles/client-cert"})
    @ResponseBody
    @a(a=4)
    @Operation(summary="Upload client certificate profile file", description="Upload client certificate  profile file of the site with the given omadacId and siteId.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SITE_BUSY, com.tplink.smb.omada.common.g.b.CERT_FILE_TOO_LARGE, com.tplink.smb.omada.common.g.b.CERT_FILE_INVALID, com.tplink.smb.omada.common.g.b.ADD_CER_SAVE_FAIL})
    public DeferredResult<OperationResponse<UploadCertResponseOpenApiVO>> uploadClientCertFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="data", description="Certificate profile file name", required=true) @RequestParam(name="data") String fileName, @Parameter(name="file", description="Certificate profile file", required=true) @RequestParam(name="file") MultipartFile file) {
        UploadCertRequestOpenApiVO requestOpenApiVO = new UploadCertRequestOpenApiVO(fileName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)requestOpenApiVO), request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/files/sites/{siteId}/setting/profiles/cert-profiles/client-private-key"})
    @ResponseBody
    @a(a=5)
    @Operation(summary="Upload client private key file", description="Upload client private key file of the omadac with the given omadacId.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SYSTEM_BUSY, com.tplink.smb.omada.common.g.b.CERT_FILE_TOO_LARGE, com.tplink.smb.omada.common.g.b.CERT_FILE_INVALID, com.tplink.smb.omada.common.g.b.ADD_CER_SAVE_FAIL})
    public DeferredResult<OperationResponse<UploadCertResponseOpenApiVO>> uploadClientPrivateKeyFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="data", description="Certificate profile file name", required=true) @RequestParam(name="data") String fileName, @Parameter(name="file", description="Certificate profile file", required=true) @RequestParam(name="file") MultipartFile file) {
        UploadCertRequestOpenApiVO requestOpenApiVO = new UploadCertRequestOpenApiVO(fileName);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)requestOpenApiVO), request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/cert-profiles"})
    @ResponseBody
    @a(a=6)
    @Operation(summary="Create a new certificate profile", description="Create a new certificate profile with the given params.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SYSTEM_BUSY, com.tplink.smb.omada.common.g.b.DUPLICATE_CERT_PROFILE_NAME, com.tplink.smb.omada.common.g.b.CERT_PROFILE_NUM_EXCEED, com.tplink.smb.omada.common.g.b.CERT_FILE_INVALID})
    public DeferredResult<OperationResponseWithoutResult> createCertProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody CertProfileRequestOpenApiVO createCertProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createCertProfileOpenApiVO), request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/cert-profiles/{certId}"})
    @ResponseBody
    @a(a=7)
    @Operation(summary="Modify an exist certificate profile", description="Modify an exist certificate profile with the given params.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SYSTEM_BUSY, com.tplink.smb.omada.common.g.b.CERT_PROFILE_NOT_EXIST, com.tplink.smb.omada.common.g.b.CERT_FILE_INVALID})
    public DeferredResult<OperationResponseWithoutResult> modifyCertProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="certId", description="Certificate profile ID") @PathVariable(name="certId") String certId, @RequestBody CertProfileRequestOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/cert-profiles/{certId}"})
    @ResponseBody
    @a(a=8)
    @Operation(summary="Delete an exist certificate profile", description="Delete an exist certificate profile with the given params.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SYSTEM_BUSY})
    public DeferredResult<OperationResponse<DeleteCertOpenApiVO>> deleteCertProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="certId", description="Cert profile ID") @PathVariable(name="certId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/cert-profiles/delete-file/{fileId}"})
    @ResponseBody
    @a(a=9)
    @Operation(summary="Delete an exist certificate profile file", description="Delete an exist certificate profile file with the given params.")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SETTING_WRITE, k.MSP_SETTINGS_WRITE, k.NETWORK_WRITE}, a={com.tplink.smb.omada.common.g.b.SYSTEM_BUSY})
    public DeferredResult<OperationResponseWithoutResult> deleteCertProfileFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="fileId", description="Cert profile file ID") @PathVariable(name="fileId") String fileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/profiles/all-cert-profiles"})
    @ResponseBody
    @a(a=10)
    @Operation(summary="Get certificate profile list", description="Get certificate profile list.(Pagination).")
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ})
    public DeferredResult<OperationResponse<CertProfileOpenApiVO>> getAllCertProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

