/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.DnsCacheOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.SnmpSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.SshSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.UpnpSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.CreateDdnsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.DdnsOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.ddns.DdnsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.CreateDhcpReservationOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.DhcpReservationFilterVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.DhcpReservationOpenApiGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.DhcpReservationOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.DhcpUserFilterVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.DhcpUserGridVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.DhcpUserVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dhcp.ExportDhcpReservationOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnscache.DnsCacheQueryOpenApiV2VO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsProxySettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.dnsproxy.DnsProxySettingQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IgmpOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.iptv.IptvOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.CreateMdnsRuleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.servicesetting.vo.mdns.MdnsRuleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.ResIdOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Service")
@RestController
public class ServiceSettingOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceSettingOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp"})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    @Operation(summary="Get DHCP reservation list", description="Get DHCP reservation list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<DhcpReservationOpenApiGridVO<DhcpReservationOpenApiVO>>> getDhcpReservationGrid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.mac", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.mac", required=false) String sortsMac, @Parameter(name="sorts.ip", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.ip", required=false) String sortsIp, @Parameter(name="sorts.netName", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.netName", required=false) String sortsNetName, @Parameter(name="sorts.description", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.description", required=false) String sortsDescription, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortsStatus, @Parameter(name="searchKey", description="Fuzzy query parameters, support field : mac, ip, description.") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp"})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    @Operation(summary="Create a new DHCP reservation", description="Create a new DHCP reservation with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.DHCP_RESERVATION_NETWORK_IS_NULL, b.DHCP_RESERVATION_SIZE_LIMIT, b.NETWORK_IS_NOT_EXISTED, b.DHCP_IP_SETTING_NET_PURPOSE_WRONG, b.DHCP_IP_SETTING_IP_RANGE_INVALID, b.CONFLICT_IP_WITH_LAN_NETWORK, b.DUPLICATE_DHCP_RESERVATION_IP_SETTING, b.DUPLICATE_DHCP_RESERVATION_MAC_SETTING, b.DHCP_RESERVATION_IP_CONFLICT_WITH_IMB, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createDhcpReservation(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateDhcpReservationOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp/{mac}"})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    @Operation(summary="Modify an exist DHCP reservation", description="Modify an exist DHCP reservation with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.DHCP_RESERVATION_NETWORK_IS_NULL, b.DHCP_RESERVATION_SIZE_LIMIT, b.NETWORK_IS_NOT_EXISTED, b.DHCP_IP_SETTING_NET_PURPOSE_WRONG, b.DHCP_IP_SETTING_IP_RANGE_INVALID, b.CONFLICT_IP_WITH_LAN_NETWORK, b.DUPLICATE_DHCP_RESERVATION_IP_SETTING, b.DUPLICATE_DHCP_RESERVATION_MAC_SETTING, b.DHCP_RESERVATION_IP_CONFLICT_WITH_IMB, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> modifyDhcpReservation(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mac", description="MAC address of the DHCP reservation, format: AA-BB-CC-11-22-33.") @PathVariable(name="mac") String mac, @RequestBody CreateDhcpReservationOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp/{mac}"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    @Operation(summary="Delete an exist DHCP reservation", description="Delete an exist DHCP reservation with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> deleteDhcpReservation(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mac", description="MAC address of the DHCP reservation, format: AA-BB-CC-11-22-33.") @PathVariable(name="mac") String mac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp/{mac}/export"})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    @Operation(summary="Export DHCP reservation to IP_MAC Binding", description="Export an exist DHCP reservation to IP_MAC Binding.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.IMB_DUPLICATE_IP, b.CONFLICT_IMB_IP_WITH_LAN_NETWORK, b.IMB_IP_CONFLICT_WITH_DHCP_RESERVATION, b.IMB_NUM_EXCEED, b.NETWORK_IS_NOT_EXISTED, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> exportDhcpReservation(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ExportDhcpReservationOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/ddns"})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    @Operation(summary="Get Dynamic DNS list", description="Get Dynamic DNS list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_DEVICE_READ, k.DEVICES_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<DdnsOpenApiGridVO<DdnsOpenApiVO>>> getDdnsGrid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.service", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.service", required=false) String sortsService, @Parameter(name="sorts.updateInterval", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.updateInterval", required=false) String sortsUpdateInterval, @Parameter(name="sorts.status", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.status", required=false) String sortsStatus) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/ddns"})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    @Operation(summary="Create a new Dynamic DNS entry", description="Create a new Dynamic DNS entry with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.INVALID_DDNS_ITEM, b.DUPLICATE_USERNAME_DDNS_ITEM, b.INVALID_DDNS_DOMAIN, b.TPDDNS_EXIST, b.TPDDNS_DOMAIN_DIRTY, b.TPDDNS_ENDS_INVAILD, b.TPDDNS_DOAMIN_INVALID})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createDdns(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateDdnsOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/ddns/{ddnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    @Operation(summary="Modify an exist Dynamic DNS entry", description="Modify an exist Dynamic DNS entry with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.INVALID_DDNS_ITEM, b.DUPLICATE_USERNAME_DDNS_ITEM, b.INVALID_DDNS_DOMAIN, b.TPDDNS_DOMAIN_DIRTY, b.TPDDNS_ENDS_INVAILD, b.TPDDNS_DOAMIN_INVALID})
    public DeferredResult<OperationResponseWithoutResult> modifyDdns(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ddnsId", description="Dynamic DNS entry ID") @PathVariable(name="ddnsId") String ddnsId, @RequestBody CreateDdnsOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/ddns/{ddnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    @Operation(summary="Delete an exist Dynamic DNS entry", description="Delete an exist Dynamic DNS entry with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> deleteDdns(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ddnsId", description="Dynamic DNS entry ID") @PathVariable(name="ddnsId") String ddnsId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/mdns"})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    @Operation(summary="Get mDNS rule list", description="Get mDNS rule list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<GridVO<MdnsRuleOpenApiVO>>> getMdnsGrid(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/mdns"})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    @Operation(summary="Create a new mDNS rule", description="Create a new mDNS rule with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.DUPLICATE_MDNS_RULE_NAME, b.OSG_MDNS_RULE_EXIST, b.MDNS_RULE_SIZE_LIMIT, b.AP_MDNS_RULE_EXIST, b.NOT_SUPPORT_MDNS})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createMdns(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateMdnsRuleOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/mdns/{mdnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    @Operation(summary="Modify an exist mDNS rule", description="Modify an exist mDNS rule with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.DUPLICATE_MDNS_RULE_NAME, b.MDNS_RULE_SIZE_LIMIT, b.NOT_SUPPORT_MDNS, b.MDNS_RULE_NOT_EXIST})
    public DeferredResult<OperationResponseWithoutResult> modifyMdns(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mdnsId", description="mDNS rule ID") @PathVariable(name="mdnsId") String mdnsId, @RequestBody CreateMdnsRuleOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/mdns/{mdnsId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    @Operation(summary="Delete an exist mDNS rule", description="Delete an exist mDNS rule with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> deleteMdns(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="mdnsId", description="mDNS rule ID") @PathVariable(name="mdnsId") String mdnsId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/snmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=14)
    @Operation(summary="Get SNMP setting", description="Get SNMP setting info of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<SnmpSettingOpenApiVO>> getSnmpSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/snmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    @Operation(summary="Modify SNMP setting", description="Modify SNMP setting info of the site with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.SAME_SNMPV1V2V3_USERNAME})
    public DeferredResult<OperationResponseWithoutResult> modifySnmpSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody SnmpSettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dns-proxy"})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    @Operation(summary="Get DNS proxy setting", description="Get DNS proxy setting of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_DEVICE_READ, k.DEVICES_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<DnsProxySettingQueryOpenApiVO>> getDnsProxy(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dns-proxy"})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    @Operation(summary="Modify DNS proxy setting", description="Modify DNS proxy setting info of the site with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.DNS_SEC_SERVERS_EMPTY, b.DNS_SEC_SERVERS_REACH_LIMIT, b.DOH_SERVERS_EMPTY, b.DOT_SERVERS_EMPTY, b.NOT_SUPPORT_DNS_PROXY, b.NOT_SUPPORT_DNS_PROXY_OVERRIDE, b.EMPTY_NETWORK, b.DNS_OVERRIDE_NETWORK_NOT_EXISTS, b.INVALID_DNS_SERVER})
    public DeferredResult<OperationResponseWithoutResult> modifyDnsProxy(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DnsProxySettingOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Get UPnP setting", description="Get UPnP setting")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/upnp"})
    @a(b={k.NETWORK_READ, k.SITE_DEVICE_READ, k.DEVICES_READ})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponse<UpnpSettingOpenApiVO>> getUpnpSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify UPnP setting", description="Modify UPnP setting")
    @PutMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/upnp"})
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE})
    @com.a.a.a.a.a(a=19)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateUpnpSetting(@RequestBody UpnpSettingOpenApiVO upnpSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)upnpSetting), request, response, omadacId);
    }

    @Operation(summary="Get SSH setting", description="Get SSH setting")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/ssh"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponse<SshSettingOpenApiVO>> getSshSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify SSH setting", description="Modify SSH setting")
    @PutMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/ssh"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> updateSshSetting(@RequestBody SshSettingOpenApiVO sshSetting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)sshSetting), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/igmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=22)
    @Operation(summary="Get IGMP setting", description="Get IGMP setting of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<IgmpOpenApiVO>> getIgmp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/igmp"})
    @ResponseBody
    @com.a.a.a.a.a(a=23)
    @Operation(summary="Modify IGMP setting", description="Modify IGMP setting info of the site with the given params.")
    @a(b={k.NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> modifyIgmp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody IgmpOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/iptv"})
    @ResponseBody
    @com.a.a.a.a.a(a=24)
    @Operation(summary="Get IPTV setting", description="Get IPTV setting of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_DEVICE_READ, k.DEVICES_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<IptvOpenApiVO>> getIptv(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/iptv"})
    @ResponseBody
    @com.a.a.a.a.a(a=25)
    @Operation(summary="Modify IPTV setting", description="Modify IPTV setting info of the site with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID, b.IPTV_WITHOUT_INTERNET_PORT, b.DUPLICATE_VLANID_IN_IPTV, b.DUPLICATE_VLANID_WITH_NETWORK, b.DUPLICATE_VLANID})
    public DeferredResult<OperationResponseWithoutResult> modifyIptv(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody IptvConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/files/dhcp/export"})
    @ResponseBody
    @com.a.a.a.a.a(a=26)
    @Operation(summary="Export DHCP reservation list to file", description="Export existed DHCP reservation list to file.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_PERMISSION})
    public DeferredResult<OperationResponseWithoutResult> exportDhcpReservationListToFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/files/dhcp/import"})
    @ResponseBody
    @com.a.a.a.a.a(a=27)
    @Operation(summary="Import DHCP reservation list from file", description="Import DHCP reservation list from existed file.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.UPLOAD_FILTER_ADDRESS_FILE_EMPTY, b.DHCP_FILE_TYPE_INVALID, b.PROCESS_FILTER_ADDRESS_FILE_FAIL, b.ERROR_EXISTS_ON_IMPORTING_DHCP_LIST, b.DHCP_RESERVATION_REACH_LIMIT_WHEN_DHCP_IMPORT})
    public DeferredResult<OperationResponseWithoutResult> importDhcpReservationListFromFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="file", description="DHCP reservation file.") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/files/dhcp/import-result"})
    @ResponseBody
    @com.a.a.a.a.a(a=28)
    @Operation(summary="Download DHCP import result", description="Download DHCP import result.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.DHCP_IMPORT_RESULT_NOT_EXIST})
    public DeferredResult<OperationResponse> downloadDhcpImportResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dns-cache"})
    @ResponseBody
    @com.a.a.a.a.a(a=29)
    @Operation(summary="Get DNS cache", description="Get DNS cache setting of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_DEVICE_READ, k.DEVICES_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<DnsCacheOpenApiVO>> getDnsCacheSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dns-cache"})
    @ResponseBody
    @com.a.a.a.a.a(a=30)
    @Operation(summary="Modify DNS cache setting", description="Modify DNS cache setting")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponseWithoutResult> modifyDnsCacheSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DnsCacheOpenApiVO dnsCacheOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dnsCacheOpenApiVO), request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/dns-cache-data"})
    @ResponseBody
    @com.a.a.a.a.a(a=31)
    @Operation(summary="Get DNS cache list", description="Get DNS cache list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_DEVICE_READ, k.DEVICES_READ}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponse<DnsCacheOpenApiVO>> getDnsCacheList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody(required=false) DnsCacheQueryOpenApiV2VO dnsCacheQueryVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dnsCacheQueryVO), request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/dns-cache-data/clear"})
    @ResponseBody
    @com.a.a.a.a.a(a=32)
    @Operation(summary="Clear DNS cache list", description="Clear DNS cache list with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_DEVICE_WRITE, k.DEVICES_WRITE}, a={b.SITE_BUSY, b.INVALID_SITE_ID})
    public DeferredResult<OperationResponseWithoutResult> clearDnsCacheList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the dhcp user list of all servers", description="Get the dhcp user list of all servers.")
    @a(a={}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp/user-list"})
    @com.a.a.a.a.a(a=34)
    @ResponseBody
    public DeferredResult<OperationResponse<DhcpUserGridVO<DhcpUserVO>>> getGridAllDhcpUserList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Reservation From Dhcp User List", description="Reservation From Dhcp User List.")
    @a(a={}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/dhcp/user-list/reservation"})
    @com.a.a.a.a.a(a=35)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> reservationFromDhcpUserList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(value="siteId") String siteId, @RequestBody DhcpUserFilterVO filterVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)filterVO), request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/setting/service/files/dhcp/batch-export"})
    @ResponseBody
    @com.a.a.a.a.a(a=36)
    @Operation(summary="Batch Export DHCP reservation list to file", description="Batch Export DHCP reservation list to file.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY, b.INVALID_PERMISSION})
    public DeferredResult<OperationResponseWithoutResult> batchExportDhcpReservationListToFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DhcpReservationFilterVO filterVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)filterVO), request, response, omadacId);
    }
}

