/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PoeDeviceDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PoeScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PoeScheduleQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PortDeviceDetailOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PortScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PortScheduleQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.RebootScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.RebootScheduleQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.UpgradeScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.schedule.UpgradeScheduleQueryOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Schedule")
@RestController
public class ScheduleOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduleOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get PoE ports list", description="Get PoE ports list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/poe-ports"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<List<PoeDeviceDetailOpenApiVO>>> getPoePortsList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get PoE schedule list", description="Get poe schedule list.(Pagination)")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/poe-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<GridVO<PoeScheduleQueryOpenApiVO>>> getPoeScheduleList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new PoE Schedule", description="Create new Poe Schedule")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/poe-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.INVALID_SITE_ID, b.ITEM_NOT_EXISTED, b.DUPLICATE_NAME_IN_SITE})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> createPoeSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody PoeScheduleOpenApiVO poeScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)poeScheduleOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify PoE Schedule", description="Modify Poe Schedule")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/poe-schedules/{poeScheduleId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.ITEM_NOT_EXISTED, b.DUPLICATE_NAME_IN_SITE})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> modifyPoeSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="poeScheduleId", description="PoE Schedule ID") @PathVariable(name="poeScheduleId") String poeScheduleId, @RequestBody PoeScheduleOpenApiVO poeScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)poeScheduleOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete PoE Schedule", description="Delete Poe Schedule")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/poe-schedules/{poeScheduleId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.INVALID_SITE_ID})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponseWithoutResult> deletePoeSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="poeScheduleId", description="PoE Schedule ID") @PathVariable(name="poeScheduleId") String poeScheduleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device ports list supporting port schedule", description="Get device ports list supporting port schedule")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/port-status-ports"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponse<List<PortDeviceDetailOpenApiVO>>> getPortSchedulePorts(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get port schedule list", description="Get port schedule list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/port-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponse<GridVO<PortScheduleQueryOpenApiVO>>> getPortScheduleList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new Port Schedule", description="Create new Port Schedule.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/port-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_SITE_ID, b.PORT_SCH_SIZE_LIMIT, b.ITEM_NOT_EXISTED, b.DUPLICATE_NAME_IN_SITE})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponseWithoutResult> createPortSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody PortScheduleOpenApiVO portScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portScheduleOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify Port Schedule", description="Modify Port Schedule")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/port-schedules/{portScheduleId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.ITEM_NOT_EXISTED, b.DUPLICATE_NAME_IN_SITE})
    @ResponseBody
    @a(a=9)
    public DeferredResult<OperationResponseWithoutResult> modifyPortSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portScheduleId", description="Port Schedule ID") @PathVariable(name="portScheduleId") String portScheduleId, @RequestBody PortScheduleOpenApiVO portScheduleOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portScheduleOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete Port Schedule", description="Delete Port Schedule")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/port-schedules/{portScheduleId}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @a(a=10)
    public DeferredResult<OperationResponseWithoutResult> deletePortSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portScheduleId", description="Port Schedule ID") @PathVariable(name="portScheduleId") String portScheduleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get reboot schedule list", description="Get reboot schedule list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/reboot-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=11)
    public DeferredResult<OperationResponse<List<RebootScheduleQueryOpenApiVO>>> getRebootScheduleList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new reboot schedule", description="Create new reboot schedule")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/reboot-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.DUPLICATE_NAME_IN_SITE, b.REBOOT_SCH_SIZE_LIMIT})
    @ResponseBody
    @a(a=12)
    public DeferredResult<OperationResponseWithoutResult> createRebootSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody RebootScheduleOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Modify reboot schedule", description="Modify reboot schedule")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/reboot-schedules/{id}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.DUPLICATE_NAME_IN_SITE})
    @ResponseBody
    @a(a=13)
    public DeferredResult<OperationResponseWithoutResult> modifyRebootSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Reboot Schedule ID") @PathVariable(name="id") String id, @RequestBody RebootScheduleOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Delete reboot schedule", description="Delete reboot schedule")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/reboot-schedules/{id}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.INVALID_SITE_ID})
    @ResponseBody
    @a(a=14)
    public DeferredResult<OperationResponseWithoutResult> deleteRebootSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Reboot Schedule ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get upgrade schedule list", description="Get upgrade schedule list.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/upgrade-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=15)
    public DeferredResult<OperationResponse<List<UpgradeScheduleQueryOpenApiVO>>> getUpgradeScheduleList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new upgrade schedule", description="Create new upgrade schedule")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/upgrade-schedules"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.DUPLICATE_NAME_IN_SITE, b.UPGRADE_SCH_TIME_TOO_EARLY, b.NO_DEVICE_SELECT, b.UPGRADE_SCH_SIZE_LIMIT})
    @ResponseBody
    @a(a=16)
    public DeferredResult<OperationResponseWithoutResult> createUpgradeSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody UpgradeScheduleOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Modify upgrade schedule", description="Modify upgrade schedule")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/upgrade-schedules/{id}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.DUPLICATE_NAME_IN_SITE, b.UPGRADE_SCH_TIME_TOO_EARLY, b.NO_DEVICE_SELECT})
    @ResponseBody
    @a(a=17)
    public DeferredResult<OperationResponseWithoutResult> modifyUpgradeSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Upgrade Schedule ID") @PathVariable(name="id") String id, @RequestBody UpgradeScheduleOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Delete upgrade schedule", description="Delete upgrade schedule")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/upgrade-schedules/{id}"})
    @com.tplink.smb.omada.common.m.a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.INVALID_REQUEST_TYPE, b.INVALID_SITE_ID})
    @ResponseBody
    @a(a=18)
    public DeferredResult<OperationResponseWithoutResult> deleteUpgradeSchedule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="id", description="Upgrade Schedule ID") @PathVariable(name="id") String id) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

