/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.AddPSKsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.AutoCreatePSKOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DeletePSKsOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiProfileQueryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OuiProfileSummaryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PPSKAutoTypeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PPSKProfileBriefInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PPSKProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PpskProfileV2OpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile.ApnProfileConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile.ApnProfileGridOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.apnprofile.ApnProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.CreateGroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.GroupOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.groupprofile.ResIdOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile.CreateGoogleLdapProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile.CreateLdapProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ldapprofile.LdapProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.CreateRadiusProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.CreateRadiusUserOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.radiusprofile.RadiusUserOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit.CreateRateLimitProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit.RateLimitProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.ratelimit.UpdateRateLimitProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.timerange.CreateTimeRangeProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.timerange.TimeRangeProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.timerange.UpdateTimeRangeProfileOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.RateLimitProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.profile.dto.ppsk.PPSKProfileVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.transmission.ouibasedvlan.OuiGridVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Profiles")
@RestController
@com.a.a.a.a.b(a=15)
public class ProfileManagerOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileManagerOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/groups"})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    @Operation(summary="Get group profile list", description="Get group profile list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ, k.SITE_DEVICE_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<GroupOpenApiVO>>> getGroupProfiles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/groups/{groupType}"})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    @Operation(summary="Get group profile list by type", description="Get a certain type of group profile list of the site with the given omadacId and siteId and type.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ, k.SITE_DEVICE_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<GroupOpenApiVO>>> getGroupProfilesByType(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="groupType", description="Type of group profile, 0:IP Group; 1:IP Port Group; 2\uff1aMac Group; 3:IPv6 Group; 4:IPv6 Port Group; 5:Country Group; 7:Domain Group.") @PathVariable(name="groupType") String groupType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/groups"})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    @Operation(summary="Create a new group profile", description="Create a new group profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE, k.SITE_DEVICE_WRITE}, a={b.SITE_BUSY, b.DUPLICATE_GROUP_NAME, b.IPV6_GROUP_NUM_EXCEED, b.IP_GROUP_NUM_EXCEED, b.IP_PORT_NUM_EXCEED, b.MAC_FILTER_GROUP_NUM_EXCEED, b.DUPLICATE_MAC_FILTER_GROUP_NAME, b.DUPLICATE_MAC_FILTER_ADDRESS, b.IPV6_PORT_GROUP_NUM_EXCEED, b.COUNTRY_GROUP_NUM_EXCEED, b.DOMAIN_GROUP_NUM_EXCEED, b.IP_NUM_EXCEED_OF_IP_GROUP, b.IP_NUM_EXCEED_OF_IP_PORT_GROUP, b.PORT_NUM_EXCEED_OF_IP_PORT_GROUP, b.DOMAIN_NUM_EXCEED_OF_DOMAIN_GROUP, b.MAC_FILTER_ADDRESS_NUM_EXCEED, b.IP_NUM_EXCEED_OF_IPV6_GROUP, b.IP_NUM_EXCEED_OF_IPV6_PORT_GROUP, b.PORT_NUM_EXCEED_OF_IPV6_PORT_GROUP, b.INVALID_DOMAIN_OR_INVALID_FORMAT_DOMAIN_GROUP, b.INVALID_DOMAIN_TYPE_IN_DOMAIN_GROUP})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createGroupProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/groups/{groupType}/{groupId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    @Operation(summary="Modify an exist group profile", description="Modify an exist group profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.DUPLICATE_GROUP_NAME, b.INVALID_DOMAIN_TYPE_IN_DOMAIN_GROUP, b.DUPLICATE_MAC_FILTER_GROUP_NAME, b.DUPLICATE_MAC_FILTER_ADDRESS, b.DEFAULT_IP_GROUP_NO_EDITING, b.DEFAULT_DOMAIN_GROUP_NO_EDITING, b.INVALID_DOMAIN_OR_INVALID_FORMAT_DOMAIN_GROUP})
    public DeferredResult<OperationResponseWithoutResult> modifyGroupProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="groupType", description="Type of group profile, 0:IP Group; 1:IP Port Group; 2\uff1aMac Group; 3:IPv6 Group; 4:IPv6 Port Group; 5:Country Group; 7:Domain Group.") @PathVariable(name="groupType") String groupType, @Parameter(name="groupId", description="Group profile id.") @PathVariable(name="groupId") String groupId, @RequestBody CreateGroupOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/groups/{groupType}/{groupId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    @Operation(summary="Delete an exist group profile", description="Delete an exist group profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.MODIFY_GROUP_NOT_EXIST, b.IP_GROUP_USED_IN_QOS_CLASS_RULE, b.IP_PORT_GROUP_USED_IN_ACL, b.IP_PORT_GROUP_USED_IN_POLICY_ROUTING, b.DEFAULT_IP_GROUP_NO_EDITING, b.IP_GROUP_USED_IN_ACL, b.IP_GROUP_USED_IN_URLFILTERING, b.IP_GROUP_USED_IN_TRANSMISSION, b.GROUP_HAS_BEEN_USED_IN_SSID, b.MAC_GROUP_USED_IN_ACL, b.MAC_GROUP_USED_IN_MAC_FILTER, b.IPV6_GROUP_USED_CLASS_RULE, b.IPV6_GROUP_USED_IN_ACL, b.DELETE_GROUP_NOT_EXIST, b.IPV6_PORT_GROUP_USED_IN_ACL, b.COUNTRY_GROUP_USED_IN_ACL, b.DEFAULT_DOMAIN_GROUP_NO_EDITING, b.DOMAIN_GROUP_USED_IN_ACL})
    public DeferredResult<OperationResponseWithoutResult> deleteGroupProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="type", description="Type of group profile, 0:IP Group; 1:IP Port Group; 2\uff1aMac Group; 3:IPv6 Group; 4:IPv6 Port Group; 5:Country Group; 7:Domain Group.") @PathVariable(name="groupType") String groupType, @Parameter(name="groupId", description="Group profile id.") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get OUI profile list", description="Get OUI profile list.(Pagination)This interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/oui-profiles"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.SITE_DEVICE_READ}, a={b.OPEN_API_PRO_ONLY})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    public DeferredResult<OperationResponse<OuiGridVO<OuiProfileQueryOpenApiVO>>> getOuiProfileList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get OUI profile summary list", description="Get OUI profile summary list.This interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/oui-profiles/all"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.SITE_DEVICE_READ}, a={b.OPEN_API_PRO_ONLY})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    public DeferredResult<OperationResponse<List<OuiProfileSummaryOpenApiVO>>> getOuiProfileFullList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create OUI profile", description="Create OUI profileThis interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/oui-profiles"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.SITE_DEVICE_WRITE}, a={b.OUI_NUM_EXCEED, b.DUPLICATE_OUI_IN_PROFILE, b.DUPLICATE_OUI_PROFILE_NAME, b.OPEN_API_PRO_ONLY})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    public DeferredResult<OperationResponseWithoutResult> createOuiProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody OuiProfileOpenApiVO ouiProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ouiProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify OUI Profile", description="Modify OUI ProfileThis interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/oui-profiles/{ouiId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.SITE_DEVICE_WRITE}, a={b.OUI_NUM_EXCEED, b.DUPLICATE_OUI_IN_PROFILE, b.OUI_PROFILE_NOT_EXIST, b.DUPLICATE_OUI_PROFILE_NAME, b.OUI_NUM_EXCEED, b.DUPLICATE_OUI_IN_PROFILE, b.DEVICE_OUI_VLAN_COMBINE_LIMIT_EXCEED, b.OPEN_API_PRO_ONLY})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponseWithoutResult> modifyOuiProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ouiId", description="OUI ID") @PathVariable(name="ouiId") String ouiId, @RequestBody OuiProfileOpenApiVO ouiProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ouiProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete OUI Profile", description="Delete OUI ProfileThis interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/oui-profiles/{ouiId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.SITE_DEVICE_WRITE}, a={b.OUI_PROFILE_NOT_EXIST, b.OUI_PROFILE_IN_USE_BY_OUI_BASED_VLAN, b.OUI_PROFILE_IN_USE_BY_MAC_FILTER, b.OPEN_API_PRO_ONLY})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponseWithoutResult> deleteOuiProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ouiId", description="OUI ID") @PathVariable(name="ouiId") String ouiId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius"})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    @Operation(summary="Get Radius profile list", description="Get Radius profile list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    public DeferredResult<OperationResponse<List<RadiusProfileOpenApiVO>>> getRadiusProfileList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    @Operation(summary="Create a new Radius profile", description="Create a new Radius profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.RADIUS_SERVER_IP_INVALID, b.RADIUS_SERVER_IP_INVALID, b.UPDATE_INTERVAL_INVALID, b.ACCOUNTING_PORT_INVALID, b.ACCOUNTING_PSW_INVALID, b.RADIUS_PROFILE_EXISTED, b.RADIUS_PROFILE_REACHED_LIMIT})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createRadiusProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateRadiusProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius/{radiusProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    @Operation(summary="Modify an exist Radius profile", description="Modify an exist Radius profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.RADIUS_SERVER_IP_INVALID, b.RADIUS_SERVER_IP_INVALID, b.UPDATE_INTERVAL_INVALID, b.ACCOUNTING_PORT_INVALID, b.ACCOUNTING_PSW_INVALID, b.RADIUS_PROFILE_EXISTED, b.RADIUS_PROFILE_NOT_EXISTED, b.FAILED_TO_MODIFY_BUILT_IN_RADIUS_PROFILE, b.BUILT_IN_SERVER_IN_USED, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_PPSK, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_SSL_VPN, b.RADIUS_SERVER_AUTH_NUM_LESS_THAN_ACC_NUM, b.FAIL_TO_MODIFY_RADIUS_PROFILE_USED_IN_DOT1X, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_NOT_SUPPORT_DOMAIN})
    public DeferredResult<OperationResponseWithoutResult> modifyRadiusProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="radiusProfileId", description="Radius profile Id") @PathVariable(name="radiusProfileId") String radiusProfileId, @RequestBody CreateRadiusProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius/{radiusProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=14)
    @Operation(summary="Delete an exist Radius profile", description="Delete an exist Radius profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.FAILED_TO_DELETE_BUILT_IN_RADIUS_PROFILE, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_SSID, b.RADIUS_PROFILED_HAS_BEEN_USED_IN_MACAUTH, b.RADIUS_PROFILED_HAS_BEEN_USED_IN_PORTAL, b.RADIUS_PROFILE_HAS_BEEN_USED_IN_DOT1X, b.SSL_VPN_RADIUS_USED})
    public DeferredResult<OperationResponseWithoutResult> deleteRadiusProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="radiusProfileId", description="Radius profile Id") @PathVariable(name="radiusProfileId") String radiusProfileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius-server/users"})
    @ResponseBody
    @com.a.a.a.a.a(a=15)
    @Operation(summary="Get Build-in Radius profile user list", description="Get Build-in Radius profile user list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    public DeferredResult<OperationResponse<GridVO<RadiusUserOpenApiVO>>> getRadiusUserList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer currentPage, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer currentPageSize, @Parameter(name="sorts.username", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.username", required=false) String sortsUsername) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius-server/users"})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    @Operation(summary="Create a new Build-in Radius profile user", description="Get Build-in Radius profile user list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.RADIUS_USER_NAME_EXISTED, b.RADIUS_USER_NAME_EXISTED_IN_OTHER_SITES, b.RADIUS_USER_REACHED_LIMIT})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createRadiusUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateRadiusUserOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius-server/users/{userId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    @Operation(summary="Modify an exist Build-in Radius profile user", description="Get Build-in Radius profile user list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.RADIUS_USER_NOT_EXIST, b.RADIUS_USER_NAME_EXISTED, b.RADIUS_USER_NAME_EXISTED_IN_OTHER_SITES})
    public DeferredResult<OperationResponseWithoutResult> modifyRadiusUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="userId", description="Build-in Radius profile user Id") @PathVariable(name="userId") String userId, @RequestBody CreateRadiusUserOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/radius-server/users/{userId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    @Operation(summary="Delete an exist Build-in Radius profile user", description="Get Build-in Radius profile user list of the site with the given omadacId and siteId. Cloud Based Controller does not support built-in radius function, you cannot call this interface through openAPI on Cloud Based Controller.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    public DeferredResult<OperationResponseWithoutResult> deleteRadiusUser(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="userId", description="Build-in Radius profile user Id") @PathVariable(name="userId") String userId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get PPSK profiles list", description="Get PPSK profiles list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profiles"})
    @com.a.a.a.a.a(a=19)
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<List<PPSKProfileBriefInfoOpenApiVO>>> getPPSKProfiles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Deprecated
    @Operation(summary="Create PPSK profile", description="Create PPSK profile This interface has been deprecated. Please use the following interface instead: Create PPSK profile V2")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createPPSKProfile(@RequestBody PPSKProfileOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Create PPSK profile V2", description="Create PPSK profile")
    @PostMapping(value={"/openapi/v2/{omadacId}/sites/{siteId}/ppsk-profile"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createPPSKProfileV2(@RequestBody PpskProfileV2OpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Modify PPSK profile", description="Modify PPSK profile")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile/{profileId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyPPSKProfile(@RequestBody PPSKProfileOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Auto Create PSKs", description="Auto Create PSKs")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile/generate-psk"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    public DeferredResult<List<AutoCreatePSKOpenApiVO>> autoCreatePPSK(@RequestBody PPSKAutoTypeOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Delete PPSK profile", description="Delete PPSK profile")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile/{profileId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePPSKProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete All PPSK profiles", description="Delete All PPSK profiles")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profiles"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.FAILED_TO_DELETE_ALL_PPSK_PROFILES})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteAllPPSKProfiles(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get PPSK profile detail", description="Get PPSK profile detail")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile/{profileId}"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponse<PPSKProfileVO>> getPPSKProfileDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Add PSKs to PPSK profile", description="Add PSKs to a PPSK profile")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile/{profileId}/add-psk"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> addPSKsToPPSKProfile(@RequestBody AddPSKsOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Delete PSKs to PPSK profile", description="Delete PSKs to a PPSK profile")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/ppsk-profile/{profileId}/delete-psk"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePSKsToPPSKProfile(@RequestBody DeletePSKsOpenApiVO body, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="PPSK profile Id") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)body), request, response, omadacId);
    }

    @Operation(summary="Get time range profile list", description="Get time range profile list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/time-range-profiles"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ, k.SITE_DEVICE_READ})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    public DeferredResult<OperationResponse<List<TimeRangeProfileOpenApiVO>>> getTimeRangeList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create time range profile", description="Create time range profile")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/time-range-profiles"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE, k.SITE_DEVICE_WRITE}, a={b.TIMERANGE_NOT_ALLOWED_EMPTY, b.PROFILE_TIME_LOGIC_ERROR, b.TIME_RANGE_SCHEDULE_PARAM_ERROR, b.DUPLICATE_SCHEDULER_PROFILE_NAME, b.SCHEDULE_NUM_EXCEED, b.TIME_RANGE_RULE_NUM_EXCEED})
    @com.a.a.a.a.a(a=27)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createTimeRangeProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateTimeRangeProfileOpenApiVO createTimeRangeProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createTimeRangeProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify time range profile", description="Modify time range profile")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/time-range-profile/{profileId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE, k.SITE_NETWORK_WRITE}, a={b.TIMERANGE_NOT_ALLOWED_EMPTY, b.PROFILE_TIME_LOGIC_ERROR, b.TIME_RANGE_SCHEDULE_PARAM_ERROR, b.DUPLICATE_SCHEDULER_PROFILE_NAME, b.TIME_RANGE_RULE_NUM_EXCEED})
    @com.a.a.a.a.a(a=28)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTimeRangeProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId, @RequestBody UpdateTimeRangeProfileOpenApiVO updateTimeRangeProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateTimeRangeProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete time range profile", description="Delete time range profile")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/time-range-profile/{profileId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE, k.SITE_DEVICE_WRITE}, a={b.DELETE_SCHEDULER_PROFILE_NOT_EXIST, b.TIME_RANGE_HAS_BEEN_USED_IN_SSID, b.TIME_RANGE_HAS_BEEN_USED_IN_POESCH, b.TIME_RANGE_HAS_BEEN_USED_IN_PORTSCH, b.TIME_RANGE_HAS_BEEN_USED_IN_ACL, b.TIME_RANGE_HAS_BEEN_USED_IN_IPS, b.TIME_RANGE_HAS_BEEN_USED_IN_DPI})
    @com.a.a.a.a.a(a=29)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteTimeRangeProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get rate limit profile list", description="Get rate limit profile list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/rate-limit-profiles"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.INVALID_SITE_ID})
    @com.a.a.a.a.a(a=30)
    @ResponseBody
    public DeferredResult<OperationResponse<List<RateLimitProfileOpenApiVO>>> getRateLimitProfileList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create rate limit profile", description="Create rate limit profile")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/rate-limit-profiles"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.DUPLICATE_RATE_LIMIT_NAME, b.RATE_LIMIT_NUM_EXCEED})
    @com.a.a.a.a.a(a=31)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createRateLimitProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateRateLimitProfileOpenApiVO createRateLimitProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)createRateLimitProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify rate limit profile", description="Modify rate limit profile")
    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/rate-limit-profile/{profileId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.RATE_LIMIT_NOT_EXIST, b.DUPLICATE_RATE_LIMIT_NAME})
    @com.a.a.a.a.a(a=32)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyRateLimitProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId, @RequestBody UpdateRateLimitProfileOpenApiVO updateRateLimitProfileOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)updateRateLimitProfileOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete rate limit profile", description="Delete rate limit profile")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/rate-limit-profile/{profileId}"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.RATE_LIMIT_NOT_EXIST, b.RATE_LIMIT_IS_DEFAULT, b.RATE_LIMIT_IN_USE_BY_LOCALUSER, b.RATE_LIMIT_IN_USE_BY_VOUCHER, b.RATE_LIMIT_IN_USE_BY_CLIENT})
    @com.a.a.a.a.a(a=33)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteRateLimitProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="Profile ID") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap"})
    @ResponseBody
    @com.a.a.a.a.a(a=34)
    @Operation(summary="Get LDAP profile list", description="Get LDAP profile list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<LdapProfileOpenApiVO>>> getLdapProfileList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap"})
    @ResponseBody
    @com.a.a.a.a.a(a=35)
    @Operation(summary="Create a new LDAP profile", description="Create a new LDAP profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.LDAP_PROFILE_NAME_EXISTED, b.LDAP_PROFILE_NOT_EXISTED})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createLdapProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody CreateLdapProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap/{ldapProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=36)
    @Operation(summary="Modify an exist LDAP profile", description="Modify an exist LDAP profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.LDAP_PROFILE_HAS_BEEN_USED_IN_VPN})
    public DeferredResult<OperationResponseWithoutResult> modifyLdapProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ldapProfileId", description="LDAP profile ID.") @PathVariable(name="ldapProfileId") String ldapProfileId, @RequestBody CreateLdapProfileOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap/{ldapProfileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=37)
    @Operation(summary="Delete an exist LDAP profile", description="Delete an exist LDAP profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    public DeferredResult<OperationResponseWithoutResult> deleteLdapProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ldapProfileId", description="LDAP profile ID.") @PathVariable(name="ldapProfileId") String ldapProfileIdO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/apn"})
    @ResponseBody
    @com.a.a.a.a.a(a=38)
    @Operation(summary="Get APN profile list", description="Get APN profile list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<ApnProfileOpenApiVO>>> getApnProfileList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/apn"})
    @ResponseBody
    @com.a.a.a.a.a(a=39)
    @Operation(summary="Create a new APN profile", description="Create a new APN profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.APN_PROFILE_NUM_EXCEED, b.DUPLICATE_PROFILE_NAME, b.LTE_WAN_IPV6_ENABLE})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createApnProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ApnProfileConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/apn/{profileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=40)
    @Operation(summary="Modify an exist APN profile", description="Modify an exist APN profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.APN_PROFILE_NUM_EXCEED, b.DUPLICATE_PROFILE_NAME, b.LTE_WAN_IPV6_ENABLE})
    public DeferredResult<OperationResponseWithoutResult> modifyApnProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="APN profile ID.") @PathVariable(name="profileId") String profileId, @RequestBody ApnProfileConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/apn/{profileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=41)
    @Operation(summary="Delete an exist APN profile", description="Delete an exist APN profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    public DeferredResult<OperationResponseWithoutResult> deleteApnProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="APN profile ID.") @PathVariable(name="profileId") String profileId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap/google"})
    @ResponseBody
    @com.a.a.a.a.a(a=42)
    @Operation(summary="Get google LDAP profile list", description="Get google LDAP profile list of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<LdapProfileOpenApiVO>>> getGoogleLdapProfileList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap/google"}, consumes={"multipart/form-data"})
    @ResponseBody
    @com.a.a.a.a.a(a=43)
    @Operation(summary="Create a new google LDAP profile", description="Create a new google LDAP profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_GOOGLE_LDAP_AUTH_FILE, b.LDAP_PROFILE_NAME_EXISTED, b.LDAP_PROFILE_NOT_EXISTED, b.OSG_NOT_SUPPORT_GOOGLE_LDAP})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createGoogleLdapProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestPart(value="config") @Parameter(name="config", description="Configuration of google LDAP profile, need to specify Content-Type of this form part as application/json.") CreateGoogleLdapProfileOpenApiVO openApiVO, @RequestPart(value="file") @Parameter(name="file", description="Google LDAP certificate file.") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @PutMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap/google/{profileId}"}, consumes={"multipart/form-data"})
    @ResponseBody
    @com.a.a.a.a.a(a=44)
    @Operation(summary="Modify an exist google LDAP profile", description="Modify an exist google LDAP profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.INVALID_GOOGLE_LDAP_AUTH_FILE, b.LDAP_PROFILE_HAS_BEEN_USED_IN_VPN, b.OSG_NOT_SUPPORT_GOOGLE_LDAP})
    public DeferredResult<OperationResponseWithoutResult> modifyGoogleLdapProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="LDAP profile ID.") @PathVariable(name="profileId") String ldapProfileId, @RequestPart(value="config") @Parameter(name="config", description="Configuration of google LDAP profile, need to specify Content-Type of this form part as application/json.") CreateGoogleLdapProfileOpenApiVO openApiVO, @RequestPart(value="file", required=false) @Parameter(name="file", description="Google LDAP certificate file.") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/profiles/ldap/google/{profileId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=45)
    @Operation(summary="Delete an exist google LDAP profile", description="Delete an exist google LDAP profile with the given params.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY, b.LDAP_PROFILE_HAS_BEEN_USED_IN_VPN})
    public DeferredResult<OperationResponseWithoutResult> deleteGoogleLdapProfile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="profileId", description="google LDAP profile ID.") @PathVariable(name="profileId") String ldapProfileIdO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/hotspot/sites/{siteId}/setting/profiles/rateLimits"})
    @ResponseBody
    @com.a.a.a.a.a(a=46)
    @Operation(summary="get the rate limit list", description="Query the rate limit list.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<RateLimitProfileVO>>> listRateLimitForHotspot(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/profiles/apns"})
    @ResponseBody
    @com.a.a.a.a.a(a=47)
    @Operation(summary="Get APN profile list by mac for ippt", description="Get APN profile list of the site with the given omadacId, siteId and mac for ippt.")
    @a(b={k.NETWORK_READ, k.DEVICES_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<ApnProfileGridOpenApiVO>> getApnProfilesForIppt(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/gateways/{gatewayMac}/profiles/apns"})
    @ResponseBody
    @com.a.a.a.a.a(a=48)
    @Operation(summary="Create a new APN profile by mac", description="Create a new APN profile by mac with the given params.")
    @a(b={k.NETWORK_WRITE, k.DEVICES_READ}, a={b.SITE_BUSY, b.APN_PROFILE_NUM_EXCEED, b.DUPLICATE_PROFILE_NAME, b.LTE_WAN_IPV6_ENABLE})
    public DeferredResult<OperationResponse<ResIdOpenApiVO>> createApnProfileByMac(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="gatewayMac", description="Device MAC address, like AA-BB-CC-DD-EE-FF") @PathVariable(name="gatewayMac") String deviceMac, @RequestBody ApnProfileConfigOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }
}

