/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xBasicInfoEapOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xEapInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xEapOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xSwitchInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xSwitchOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.Dot1xSwitchResOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.MacAuthOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.PortalCandidatesOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.PortalCandidatesResOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.UpdateMacAuthOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.authentication.WlanSimpleOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.PortalResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.GlobalPortalDomainOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.ImportedPortalPageResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalCustomizationPageResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalDetailResOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalPictureOpenApiVO;
import com.tplink.smb.omada.portal.api.openapi.vo.portal.PortalSettingOpenApiVO;
import com.tplink.smb.omada.portal.api.web.vo.PortalPictureVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="Authentication")
@RestController
@com.a.a.a.a.b
public class AuthenticationOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dot1x"})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    @Operation(summary="Get site switch 802.1x setting", description="Get switch 802.1x setting of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<Dot1xSwitchResOpenApiVO>> getSwitchDot1xSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dot1x"})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    @Operation(summary="Modify site switch 802.1x setting", description="Modify switch 802.1x setting of the site with the given parameters.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SWITCH_DOES_NOT_EXIST, b.SITE_BUSY})
    public DeferredResult<OperationResponseWithoutResult> updateSwitchDot1xSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody Dot1xSwitchOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dot1x/candidates"})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    @Operation(summary="Get site switch 802.1x setting candidates", description="Get switch 802.1x setting candidates of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<Dot1xSwitchInfoOpenApiVO>>> getSwitchDot1xCandidates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dot1x/eap"})
    @ResponseBody
    @com.a.a.a.a.a(a=4)
    @Operation(summary="Get site eap 802.1x setting", description="Get eap 802.1x setting of the site with the given omadacId and siteId.MAB is enabled by default.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<Dot1xBasicInfoEapOpenApiVO>> getEapDot1xSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dot1x/eap"})
    @ResponseBody
    @com.a.a.a.a.a(a=5)
    @Operation(summary="Modify site EAP 802.1x setting", description="Modify EAP 802.1x setting of the site with the given parameters.MAB is enabled by default.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponseWithoutResult> updateEapDot1xSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody Dot1xEapOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dot1x/eap/candidates"})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    @Operation(summary="Get site EAP 802.1x setting candidates", description="Get EAP 802.1x setting candidates of the site with the given omadacId and siteId. ")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<Dot1xEapInfoOpenApiVO>>> getEapDot1xCandidates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/mac-auth"})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    @Operation(summary="Get site MAC-Based Authentication info", description="Get MAC-Based Authentication setting info of the site with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<MacAuthOpenApiVO>> getMacAuthSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/mac-auth"})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    @Operation(summary="Update site MAC-Based Authentication info", description="Update MAC-Based Authentication setting info of the site with the given parameters.")
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponseWithoutResult> updateMacAuthSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody UpdateMacAuthOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/mac-auth/ssids"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    @Operation(summary="Get ssids that support MAC auth", description="Get ssid list that support MAC-Based Authentication with the given omadacId and siteId.")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.SITE_BUSY})
    public DeferredResult<OperationResponse<List<WlanSimpleOpenApiVO>>> getMacAuthSsids(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get portal list in a site", description="Get portal list with the given omadacId, siteId.")
    @a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portals"})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponse<List<PortalResOpenApiVO>>> getPortalList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Upload portal picture", description="Upload portal picture")
    @a(b={k.HOTSPOT_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/portal/pics"}, consumes={"multipart/form-data"})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    public DeferredResult<OperationResponse<PortalPictureVO>> uploadPortalPic(@Parameter(name="type", description="Portal picture type: background/logo/advertisement.") @RequestParam(name="type", required=true) String type, @RequestPart(value="file", required=false) @Parameter(name="file", description="Portal picture file.") MultipartFile file, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        PortalPictureOpenApiVO setting = new PortalPictureOpenApiVO();
        setting.setType(type);
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setting), request, response, omadacId);
    }

    @Operation(summary="Import portal page", description="Import portal page")
    @a(b={k.HOTSPOT_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/portal/page"}, consumes={"multipart/form-data"})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    public DeferredResult<OperationResponse<ImportedPortalPageResOpenApiVO>> uploadPortalPage(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestPart(value="file") @Parameter(name="file", description="Portal page file.") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Add portal", description="Add new portal")
    @a(b={k.HOTSPOT_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portal"})
    @com.a.a.a.a.a(a=13)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> addPortal(@RequestBody PortalSettingOpenApiVO setting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setting), request, response, omadacId);
    }

    @Operation(summary="Modify portal", description="Modify the portal with the portal ID")
    @a(b={k.HOTSPOT_WRITE})
    @PatchMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portal/{portalId}"})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyPortal(@RequestBody PortalSettingOpenApiVO setting, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)setting), request, response, omadacId);
    }

    @Operation(summary="Delete portal", description="Delete portal setting with the given portalId")
    @a(b={k.HOTSPOT_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portal/{portalId}"})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deletePortal(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get portal detail", description="Get portal detail information with the given omadacId, siteId and portalId.")
    @a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portal/{portalId}"})
    @ResponseBody
    @com.a.a.a.a.a(a=16)
    public DeferredResult<OperationResponse<PortalDetailResOpenApiVO>> getPortalDetail(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get portal customization", description="Get portal customization information with the given omadacId, siteId and portalId.")
    @a(b={k.HOTSPOT_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portal/{portalId}/customization"})
    @ResponseBody
    @com.a.a.a.a.a(a=17)
    public DeferredResult<OperationResponse<PortalCustomizationPageResOpenApiVO>> getPortalCustomization(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="portalId", description="Portal ID") @PathVariable(name="portalId") String portalId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get Portal Domain", description="Get portal domain setting with the given omadacId and siteId.")
    @a(b={k.SITE_NETWORK_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portal/setting/domain"})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    public DeferredResult<OperationResponse<GlobalPortalDomainOpenApiVO>> getGlobalPortalDomainSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get portal SSIDs and networks", description="Get SSIDs and network of the portals")
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/hotspot/portal/candidates"})
    @ResponseBody
    @com.a.a.a.a.a(a=19)
    public DeferredResult<OperationResponse<PortalCandidatesResOpenApiVO>> getPortalCandidates(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody PortalCandidatesOpenApiVO portalCandidatesOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)portalCandidatesOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Gets a list of logout enabled portals on the site", description="Gets a list of logout enabled portals on the site")
    @a(b={k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/portals/logout-enabled"})
    @ResponseBody
    @com.a.a.a.a.a(a=20)
    public DeferredResult<OperationResponse<List<String>>> getPortalListWithLogoutEnabled(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

