/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.setting;

import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.client.dpi.api.web.dto.ApplicationGridVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.ApplicationStatTrafficOpenApiVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.ApplicationTrafficOpenApiVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.CategoryTrafficOpenApiVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.ClientTrafficWithApplicationOpenApiVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.DpiOpenApiQueryDataVO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.ApplicationOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.DpiSettingsOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.FamilyOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.FilterAddOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.FilterEditOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.FilterResultOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.RestrictionOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.RestrictionResultOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.RuleAddOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.RuleEditOpenApiVO;
import com.tplink.smb.omada.manager.dpi.api.web.dto.vo.RuleResultOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Application Control")
@RestController
@com.a.a.a.a.b(a=19)
public class ApplicationControlOpenApiController {
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get application control general settings", description="Get application control general settings with the given omadacId, siteId.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/status"})
    @com.a.a.a.a.a(a=1)
    @ResponseBody
    public DeferredResult<OperationResponse<DpiSettingsOpenApiVO>> getApplicationControlStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify application control general settings", description="Modify application control general settings.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/status"})
    @com.a.a.a.a.a(a=2)
    @ResponseBody
    public DeferredResult<OperationResponse> editApplicationControlStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DpiSettingsOpenApiVO dpiSettingsVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dpiSettingsVO), request, response, omadacId);
    }

    @Operation(summary="Get application control assigned restriction list", description="Get application control assigned restriction list with the given omadacId, siteId.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/restrictions"})
    @com.a.a.a.a.a(a=3)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<RestrictionResultOpenApiVO>>> getAssignRestrictions(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new restriction assigned to lan network", description="Create new restriction assigned to lan network.")
    @a(a={b.DPI_RESTRICTIONS_REACH_LIMITS, b.DPI_LAN_NETWORK_APPLIED_RESTRICTION}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/restrictions"})
    @com.a.a.a.a.a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponse<RestrictionResultOpenApiVO>> addAssignRestriction(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody RestrictionOpenApiVO restrictionVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)restrictionVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing restriction", description="Modify an existing restriction.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/restrictions/{restrictionId}"})
    @com.a.a.a.a.a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse> editAssignRestrictions(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="restrictionId", description="Restriction ID") @PathVariable(name="restrictionId") String restrictionId, @RequestBody RestrictionOpenApiVO restrictionVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)restrictionVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing restriction", description="Delete an existing restriction.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/restrictions/{restrictionId}"})
    @com.a.a.a.a.a(a=6)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteAssignRestrictions(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="restrictionId", description="Restriction ID") @PathVariable(name="restrictionId") String restrictionId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get filter list", description="Get filter list.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/filters"})
    @com.a.a.a.a.a(a=7)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<FilterResultOpenApiVO>>> getFilters(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field filter name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new filter", description="Create new filter.")
    @a(a={b.DPI_FILTERS_REACH_LIMITS, b.DPI_FILTER_NAME_EXIST, b.DPI_RULES_EMPTY, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/filters"})
    @com.a.a.a.a.a(a=8)
    @ResponseBody
    public DeferredResult<OperationResponse<FilterResultOpenApiVO>> addFilter(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody FilterAddOpenApiVO filterAddVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)filterAddVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing filter", description="Modify an existing filter.")
    @a(a={b.DPI_FILTER_NAME_EXIST, b.DPI_RULES_EMPTY, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/filters/{filterId}"})
    @com.a.a.a.a.a(a=9)
    @ResponseBody
    public DeferredResult<OperationResponse> editFilters(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filterId", description="Filter ID") @PathVariable(name="filterId") String filterId, @RequestBody FilterEditOpenApiVO filterEditVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)filterEditVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing filter", description="Delete an existing filter.")
    @a(a={b.FILTER_DELETE_FAIL, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/filters/{filterId}"})
    @com.a.a.a.a.a(a=10)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteFilters(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="filterId", description="Filter ID") @PathVariable(name="filterId") String filterId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get rule list", description="Get rule list.")
    @a(a={b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/rules"})
    @com.a.a.a.a.a(a=11)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<RuleResultOpenApiVO>>> getRules(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field rule name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new rule", description="Create new rule.")
    @a(a={b.DPI_RULES_REACH_LIMITS, b.DPI_RULE_NAME_EXIST, b.DPI_APPLICATIONS_EMPTY, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/rules"})
    @com.a.a.a.a.a(a=12)
    @ResponseBody
    public DeferredResult<OperationResponse<RuleResultOpenApiVO>> addRule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody RuleAddOpenApiVO ruleAddVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ruleAddVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing rule", description="Modify an existing rule.")
    @a(a={b.DPI_RULE_NAME_EXIST, b.DPI_APPLICATIONS_EMPTY, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/rules/{ruleId}"})
    @com.a.a.a.a.a(a=13)
    @ResponseBody
    public DeferredResult<OperationResponse> editRule(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ruleId", description="Rule ID") @PathVariable(name="ruleId") String ruleId, @RequestBody RuleEditOpenApiVO ruleEditOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ruleEditOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing rule", description="Delete an existing rule.")
    @a(a={b.RULE_DELETE_FAIL, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/rules/{ruleId}"})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteRules(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="ruleId", description="Rule ID") @PathVariable(name="ruleId") String ruleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get application list", description="Get application list.")
    @a(a={b.DPI_PROTOCOLS_UPDATING, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/applications"})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<ApplicationOpenApiVO>>> getApplications(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field application name") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="filtersFamilyId", description="Filter query parameters, support field 0") @RequestParam(name="filtersFamilyId", required=false) Integer filtersFamilyId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get family list", description="Get family list.")
    @a(a={b.DPI_PROTOCOLS_UPDATING, b.DPI_GATEWAY_NOT_EXISTED, b.DPI_GATEWAY_NOT_SUPPORT}, b={k.NETWORK_READ, k.SITE_NETWORK_READ, k.DEVICES_READ, k.STATICS_READ, k.CLIENTS_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/applicationControl/families"})
    @com.a.a.a.a.a(a=16)
    @ResponseBody
    public DeferredResult<OperationResponse<List<FamilyOpenApiVO>>> getFamilies(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Clear DPI data", description="Clear all DPI data.")
    @a(b={k.NETWORK_WRITE, k.STATICS_WRITE, k.SITE_NETWORK_WRITE, k.DEVICES_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/stat/dpi"})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponse<List<FamilyOpenApiVO>>> clearDpiData(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody DpiOpenApiQueryDataVO dpiOpenApiQueryDataVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dpiOpenApiQueryDataVO), request, response, omadacId);
    }

    @Operation(summary="Get most active applications", description="Get most active applications.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/mostActiveAppTraffic"})
    @com.a.a.a.a.a(a=34)
    @ResponseBody
    public DeferredResult<OperationResponse<List<ApplicationTrafficOpenApiVO>>> getMostActiveApplications(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get category info", description="Get category info.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/categoryInfo"})
    @com.a.a.a.a.a(a=35)
    @ResponseBody
    public DeferredResult<OperationResponse<ApplicationGridVO<CategoryTrafficOpenApiVO>>> getCategoryInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get allow app", description="Get allow app.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/allowApp"})
    @com.a.a.a.a.a(a=36)
    @ResponseBody
    public DeferredResult<OperationResponse<ApplicationGridVO<ApplicationStatTrafficOpenApiVO>>> getAllowApp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get block app", description="Get block app.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/blockApp"})
    @com.a.a.a.a.a(a=37)
    @ResponseBody
    public DeferredResult<OperationResponse<ApplicationGridVO<ApplicationStatTrafficOpenApiVO>>> getBlockApp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get clients traffic", description="Get clients traffic.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/clientTraffic"})
    @com.a.a.a.a.a(a=38)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<ClientTrafficWithApplicationOpenApiVO>>> getClientTraffic(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get app traffic in specific category", description="Get app traffic in specific category.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/categoryAppInfo/{familyId}"})
    @com.a.a.a.a.a(a=39)
    @ResponseBody
    public DeferredResult<OperationResponse<List<ApplicationStatTrafficOpenApiVO>>> getCategoryAppInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="familyId", description="Family Id") @PathVariable(name="siteId") String familyId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get client traffic in specific category", description="Get client traffic in specific category.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/categoryUserInfo/{familyId}"})
    @com.a.a.a.a.a(a=40)
    @ResponseBody
    public DeferredResult<OperationResponse<List<ClientTrafficWithApplicationOpenApiVO>>> getCategoryUserInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="familyId", description="Family Id") @PathVariable(name="familyId") String familyId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get client traffic in specific app", description="Get client traffic in specific app.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/specificAppInfo/{applicationId}"})
    @com.a.a.a.a.a(a=41)
    @ResponseBody
    public DeferredResult<OperationResponse<List<ClientTrafficWithApplicationOpenApiVO>>> getSpecificAppInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="applicationId", description="Application Id") @PathVariable(name="applicationId") String applicationId, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get app traffic in specific client", description="Get app traffic in specific client.")
    @a(b={k.DASHBOARD_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/dashboard/specificClientInfo/{clientMac}"})
    @com.a.a.a.a.a(a=42)
    @ResponseBody
    public DeferredResult<OperationResponse<List<ApplicationStatTrafficOpenApiVO>>> getSpecificClientInfo(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="clientMac", description="Client Mac") @PathVariable(name="clientMac") String clientMac, @Parameter(name="start", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="start") Long start, @Parameter(name="end", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="end") Long end, @Parameter(name="sorts", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts", required=false) LinkedHashMap<String, String> sorts) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get application control general settings", description="Get application control general settings with the given omadacId, siteId.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/status"})
    @com.a.a.a.a.a(a=18)
    @ResponseBody
    public DeferredResult<OperationResponse<DpiSettingsOpenApiVO>> getApplicationControlStatusTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Modify application control general settings", description="Modify application control general settings.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/status"})
    @com.a.a.a.a.a(a=19)
    @ResponseBody
    public DeferredResult<OperationResponse> editApplicationControlStatusTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @RequestBody DpiSettingsOpenApiVO dpiSettingsVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)dpiSettingsVO), request, response, omadacId);
    }

    @Operation(summary="Get application control assigned restriction list", description="Get application control assigned restriction list with the given omadacId, siteId.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/restrictions"})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<RestrictionResultOpenApiVO>>> getAssignRestrictionsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new restriction assigned to lan network", description="Create new restriction assigned to lan network.")
    @a(a={b.DPI_RESTRICTIONS_REACH_LIMITS, b.DPI_LAN_NETWORK_APPLIED_RESTRICTION}, b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/restrictions"})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OperationResponse<RestrictionResultOpenApiVO>> addAssignRestrictionTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @RequestBody RestrictionOpenApiVO restrictionVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)restrictionVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing restriction", description="Modify an existing restriction.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/restrictions/{restrictionId}"})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    public DeferredResult<OperationResponse> editAssignRestrictionsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="restrictionId", description="Restriction ID") @PathVariable(name="restrictionId") String restrictionId, @RequestBody RestrictionOpenApiVO restrictionVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)restrictionVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing restriction", description="Delete an existing restriction.")
    @a(b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/restrictions/{restrictionId}"})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteAssignRestrictionsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="restrictionId", description="Restriction ID") @PathVariable(name="restrictionId") String restrictionId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get filter list", description="Get filter list.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/filters"})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<FilterResultOpenApiVO>>> getFiltersTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field filter name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new filter", description="Create new filter.")
    @a(a={b.DPI_FILTERS_REACH_LIMITS, b.DPI_FILTER_NAME_EXIST, b.DPI_RULES_EMPTY}, b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/filters"})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponse<FilterResultOpenApiVO>> addFilterTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @RequestBody FilterAddOpenApiVO filterAddVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)filterAddVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing filter", description="Modify an existing filter.")
    @a(a={b.DPI_FILTER_NAME_EXIST, b.DPI_RULES_EMPTY}, b={k.SITE_TEMPLATE_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/filters/{filterId}"})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    public DeferredResult<OperationResponse> editFiltersTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="filterId", description="Filter ID") @PathVariable(name="filterId") String filterId, @RequestBody FilterEditOpenApiVO filterEditVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)filterEditVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing filter", description="Delete an existing filter.")
    @a(a={b.FILTER_DELETE_FAIL}, b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/filters/{filterId}"})
    @com.a.a.a.a.a(a=27)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteFiltersTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="filterId", description="Filter ID") @PathVariable(name="filterId") String filterId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get rule list", description="Get rule list.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/rules"})
    @com.a.a.a.a.a(a=28)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<RuleResultOpenApiVO>>> getRulesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field rule name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new rule", description="Create new rule.")
    @a(a={b.DPI_RULES_REACH_LIMITS, b.DPI_RULE_NAME_EXIST, b.DPI_APPLICATIONS_EMPTY}, b={k.SITE_TEMPLATE_WRITE})
    @PostMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/rules"})
    @com.a.a.a.a.a(a=29)
    @ResponseBody
    public DeferredResult<OperationResponse<RuleResultOpenApiVO>> addRuleTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @RequestBody RuleAddOpenApiVO ruleAddVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ruleAddVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing rule", description="Modify an existing rule.")
    @a(a={b.DPI_RULE_NAME_EXIST, b.DPI_APPLICATIONS_EMPTY}, b={k.SITE_TEMPLATE_WRITE})
    @PutMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/rules/{ruleId}"})
    @com.a.a.a.a.a(a=30)
    @ResponseBody
    public DeferredResult<OperationResponse> editRulesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="ruleId", description="Rule ID") @PathVariable(name="ruleId") String ruleId, @RequestBody RuleEditOpenApiVO ruleEditOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)ruleEditOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing rule", description="Delete an existing rule.")
    @a(a={b.RULE_DELETE_FAIL}, b={k.SITE_TEMPLATE_WRITE})
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/rules/{ruleId}"})
    @com.a.a.a.a.a(a=31)
    @ResponseBody
    public DeferredResult<OperationResponse> deleteRulesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="ruleId", description="Rule ID") @PathVariable(name="ruleId") String ruleId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get family list", description="Get family list.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/families"})
    @com.a.a.a.a.a(a=32)
    @ResponseBody
    public DeferredResult<OperationResponse<List<FamilyOpenApiVO>>> getFamiliesTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get application list", description="Get application list.")
    @a(b={k.SITE_TEMPLATE_READ})
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/applicationControl/applications"})
    @com.a.a.a.a.a(a=33)
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<ApplicationOpenApiVO>>> getApplicationsTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field application name") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="filtersFamilyId", description="Filter query parameters, support field 0") @RequestParam(name="filtersFamilyId", required=false) Integer filtersFamilyId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

