/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.site.cli;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.annotation.SupportStream;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.CliConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.DeleteCliOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.ExportCliVarOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.ImportCliVarOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.cli.ModifyCliOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.CliDeviceListVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.CliVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.ModelAndModelVersionVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.cliconfig.dto.SupportCliDeviceVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="CLI")
@RestController
public class CliOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CliOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get the CLI configuration list", description="Get the CLI configuration list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/configs/cli-type/{cliType}/device-type/{deviceType}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_BUSY}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<GridVO<CliVO>>> getCliList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType, @Parameter(name="deviceType", description="Device Type. Supported type: switch.") @PathVariable(name="deviceType") String deviceType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the CLI configuration content", description="Get the CLI configuration content")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/config/cli-type/{cliType}/config-id/{configId}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_BUSY}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<CliConfigOpenApiVO>> getCliConfig(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType, @Parameter(name="configId", description="CLI Config ID") @PathVariable(name="configId") String configId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create a new CLI configuration", description="Create a new CLI configuration")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/config/cli-type/{cliType}/save"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_BUSY}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> createCliConfig(@RequestBody ModifyCliOpenApiVO modifyCliOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyCliOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify the CLI configuration content", description="Modify the CLI configuration content")
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/config/cli-type/{cliType}/config-id/{configId}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_BUSY}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> modifyCliConfig(@RequestBody ModifyCliOpenApiVO modifyCliOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType, @Parameter(name="configId", description="CLI Config ID") @PathVariable(name="configId") String configId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)modifyCliOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete the CLI configuration", description="Delete the CLI configuration")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/configs/cli-type/{cliType}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_BUSY}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponseWithoutResult> deleteCliConfig(@RequestBody DeleteCliOpenApiVO deleteCliOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="cliType", description="CLI type should be a value as follows: 0: site CLI; 1: device CLI\uff1b 2\uff1amodel CLI. Site template only supports site CLI. Site template only supports site CLI.") @PathVariable(name="cliType") String cliType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deleteCliOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Apply the CLI configuration", description="Apply the CLI configuration")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/configs/config-id/{configId}/apply"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS, b.SITE_BUSY, b.DEVICE_BUSY}, b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponseWithoutResult> applyCliConfig(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="configId", description="CLI Config ID") @PathVariable(name="configId") String configId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device list when creating CLI", description="Get device list when creating CLI")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/config/devices/device-type/{deviceType}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=7)
    public DeferredResult<OperationResponse<List<CliDeviceListVO>>> getCliDeviceByType(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device Type. Supported type: switch.") @PathVariable(name="deviceType") String deviceType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get device list when importing device configuration", description="Get device list when importing device configuration")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/config/devices"})
    @com.tplink.smb.omada.common.m.a(a={}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=8)
    public DeferredResult<OperationResponse<List<SupportCliDeviceVO>>> getCliDevice(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Export CLI variable", description="Export CLI variable,filename is a UTF-8 string encoded by URL Encoder")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/export/variable"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_TYPE, b.INVALID_REQUEST_PARAMS, b.PROCESS_FILTER_ADDRESS_FILE_FAIL, b.INVALID_SITE_ID}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @SupportStream
    @a(a=9)
    public DeferredResult<OperationResponseWithoutResult> exportCliVariableToFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestBody ExportCliVarOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Import CLI variable", description="Import CLI variable")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/import/variable"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_TYPE, b.INVALID_PERMISSION, b.INVALID_REQUEST_PARAMS, b.HOT_SPOT_LOGIN_AUTH_FAIL, b.OPERATOR_NOT_EXIST, b.RESTORE_FILE_ILLEGAL, b.PROCESS_FILTER_ADDRESS_FILE_FAIL}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=10)
    public DeferredResult<OperationResponse<ImportCliVarOpenApiVO>> importCliVariableToFile(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @RequestPart(value="file") @Parameter(name="file", description="File must be a file in .csv or .json form") MultipartFile file) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get model and version for model CLI.", description="Get model and version for model CLI.")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/cli/models/device-type/{deviceType}"})
    @com.tplink.smb.omada.common.m.a(a={b.INVALID_REQUEST_PARAMS}, b={k.NETWORK_READ, k.SITE_NETWORK_READ})
    @ResponseBody
    @a(a=11)
    public DeferredResult<OperationResponse<List<ModelAndModelVersionVO>>> getModelAndVersionListByType(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId, @Parameter(name="deviceType", description="Device Type. Supported type: switch.") @PathVariable(name="deviceType") String deviceType) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

