/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.security;

import com.a.a.a.a.a;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.BlockedCountryOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.DeleteGlobalThreatOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.GetThreatMapOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.IpsThreatOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.OperateGlobalThreatOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.OpsBlockedCountryOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.QueryCountryThreatListOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.QueryThreatMapOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.SiteListOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.ThreatMapCategoryOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.ThreatSeverityOpenApiVO;
import com.tplink.smb.omada.monitor.api.openapi.vo.security.Top5ThreatNumOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Global Security")
@RestController
public class GlobalSecurityOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalSecurityOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @a(a=1)
    @Operation(summary="Get Global Threat List", description="Get the global view threat management list")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/security/threat-management"})
    @ResponseBody
    DeferredResult<OperationResponse<GridVO<IpsThreatOpenApiVO>>> getGlobalThreatList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteList", description="sites are separated by ','. If no value is passed, all sites are selected by default.") @RequestParam(name="siteList", required=false) String siteList, @Parameter(name="archived", description="archived") @RequestParam(name="archived") Boolean archived, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="filters.startTime", description="Start timestamp, in seconds, such as 1682000000") @RequestParam(name="filters.startTime") Long filtersStartTime, @Parameter(name="filters.endTime", description="End timestamp, in seconds, such as 1682000000") @RequestParam(name="filters.endTime") Long filtersEndTime, @Parameter(name="filters.severity", description="Threat Severity, such as 0:Critical, 1: Major, 2:Moderate, 3:Minor, 4:Low") @RequestParam(name="filters.severity", required=false) Integer filtersSeverity, @Parameter(name="sorts.time", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.time", required=false) String sortsTime, @Parameter(name="searchKey", description="Fuzzy query parameters, support field Threat Description/Classification/Classification Description") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=2)
    @Operation(summary="Get Global Top Threat List", description="Get the number of threats in the global view top5")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/security/threat-management/top"})
    @ResponseBody
    DeferredResult<OperationResponse<Top5ThreatNumOpenApiVO>> getGlobalTopThreatList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="startTime", description="Start Time") @RequestParam(name="startTime") Long startTime, @Parameter(name="endTime", description="End Time") @RequestParam(name="endTime") Long endTime) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=3)
    @Operation(summary="Get Blocked Countries", description="Get the list of blocked countries")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/security/blocked-country"})
    @ResponseBody
    DeferredResult<OperationResponse<BlockedCountryOpenApiVO>> getBlockedCountries(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody SiteListOpenApiVO siteListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)siteListOpenApiVO), request, response, omadacId);
    }

    @a(a=4)
    @Operation(summary="Operate Global Threats", description="Perform operations on threats in batches")
    @com.tplink.smb.omada.common.m.a(a={b.SYSTEM_BUSY}, b={k.GLOBAL_SECURITY_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/ips/threat/ops"})
    @ResponseBody
    DeferredResult<OperationResponse> operateGlobalThreats(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody OperateGlobalThreatOpenApiVO operateGlobalThreatOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)operateGlobalThreatOpenApiVO), request, response, omadacId);
    }

    @a(a=5)
    @Operation(summary="Delete Global Threat List", description="Delete archived threats in batches")
    @com.tplink.smb.omada.common.m.a(a={b.SYSTEM_BUSY}, b={k.GLOBAL_SECURITY_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/ips/threat"})
    @ResponseBody
    DeferredResult<OperationResponse> deleteGlobalThreatList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody DeleteGlobalThreatOpenApiVO deleteGlobalThreatOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deleteGlobalThreatOpenApiVO), request, response, omadacId);
    }

    @a(a=6)
    @Operation(summary="Delete blocked countries.", description="Delete blocked countries.")
    @com.tplink.smb.omada.common.m.a(a={b.SYSTEM_BUSY}, b={k.GLOBAL_SECURITY_WRITE})
    @DeleteMapping(value={"/openapi/v1/{omadacId}/security/blocked-country"})
    @ResponseBody
    DeferredResult<OperationResponse> delBlockedCountry(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody OpsBlockedCountryOpenApiVO opsBlockedCountryOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)opsBlockedCountryOpenApiVO), request, response, omadacId);
    }

    @a(a=7)
    @Operation(summary="Add Blocked Country", description="Add blocked countries to list")
    @com.tplink.smb.omada.common.m.a(a={b.SYSTEM_BUSY}, b={k.GLOBAL_SECURITY_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/security/blocked-country/add"})
    @ResponseBody
    DeferredResult<OperationResponse> addBlockedCountry(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody OpsBlockedCountryOpenApiVO opsBlockedCountryOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)opsBlockedCountryOpenApiVO), request, response, omadacId);
    }

    @a(a=8)
    @Operation(summary="Get Threat Count", description="Get the global view of the number of threats by severity level")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/security/threat-management/severity"})
    @ResponseBody
    DeferredResult<OperationResponse<ThreatSeverityOpenApiVO>> getThreatCount(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="startTime", description="Start Time") @RequestParam(name="startTime") Long startTime, @Parameter(name="endTime", description="End Time") @RequestParam(name="endTime") Long endTime) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @a(a=9)
    @Operation(summary="Get Global Category", description="The number of threats to attack countries is displayed in categories")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/security/threat-map/threat-count"})
    @ResponseBody
    DeferredResult<OperationResponse<ThreatMapCategoryOpenApiVO>> getGlobalCategory(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody QueryThreatMapOpenApiVO queryThreatMapOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryThreatMapOpenApiVO), request, response, omadacId);
    }

    @a(a=10)
    @Operation(summary="Get Global Threat Map", description="Get the data for the initial page of the threat map")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/security/threat-map"})
    @ResponseBody
    DeferredResult<OperationResponse<GetThreatMapOpenApiVO>> getGlobalThreatMap(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody QueryThreatMapOpenApiVO queryThreatMapOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryThreatMapOpenApiVO), request, response, omadacId);
    }

    @a(a=11)
    @Operation(summary="Get Country Threats", description="Get threats from individual countries")
    @com.tplink.smb.omada.common.m.a(b={k.GLOBAL_SECURITY_READ})
    @PostMapping(value={"/openapi/v1/{omadacId}/security/threat-map/threats"})
    @ResponseBody
    DeferredResult<OperationResponse<GridVO<IpsThreatOpenApiVO>>> getCountryThreats(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody QueryCountryThreatListOpenApiVO queryCountryThreatListOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)queryCountryThreatListOpenApiVO), request, response, omadacId);
    }
}

