/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.sdwan;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.BatchAutoSelectWanPortReqOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.BatchAutoSelectWanPortResultOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.LanNetworkBriefOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.QuerySdWanCandidateDeviceOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanCandidateDeviceOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanCurrentSelectedDeviceInfoOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanGroupDetailOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanGroupOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanGroupTunnelStatusOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanIpPoolRangeOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanSelectedLanNetworkOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="SD-WAN")
@RestController
@b(a=50)
public class SdWanOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SdWanOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get SD-WAN Group Grid.", description="Get all SD-WAN Group.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group"})
    @a(a=1)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<SdWanGroupDetailOpenApiVO>>> getGridSdWanGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create SD-WAN Group.", description="Create SD-WAN Group.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group"})
    @a(a=2)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> createSdWanGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody SdWanGroupOpenApiVO sdWanGroupOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)sdWanGroupOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify SD-WAN Group.", description="Modify SD-WAN Group.")
    @PutMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/{groupId}"})
    @a(a=3)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifySdWanGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="groupId", description="The ID of a SD-WAN Group") @PathVariable(name="groupId") String groupId, @RequestBody SdWanGroupOpenApiVO sdWanGroupOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)sdWanGroupOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get SD-WAN Group.", description="Get SD-WAN Group.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/{groupId}"})
    @a(a=4)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<SdWanGroupOpenApiVO>> getCurrentSdWanGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="groupId", description="The ID of a SD-WAN Group") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Delete SD-WAN Group.", description="Delete SD-WAN Group.")
    @DeleteMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/{groupId}"})
    @a(a=5)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteSdWanGroup(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="groupId", description="The ID of a SD-WAN Group") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get SD-WAN candidate devices.", description="Get SD-WAN candidate devices.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/candidate/devices"})
    @a(a=6)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<GridVO<SdWanCandidateDeviceOpenApiVO>>> getGridSdWanGroupDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody QuerySdWanCandidateDeviceOpenApiVO vo) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)vo), request, response, omadacId);
    }

    @Operation(summary="Get current SD-WAN devices.", description="Get current SD-WAN devices that participate in the networking.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/saved/devices/{groupId}"})
    @a(a=7)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<SdWanCurrentSelectedDeviceInfoOpenApiVO>> getSdWanGroupDevices(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="groupId", description="The ID of a SD-WAN Group") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="First check SD-WAN group connection.", description="First check the connection between devices in the SD-WAN group.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/{groupId}/firstCheck"})
    @a(a=8)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<SdWanGroupTunnelStatusOpenApiVO>> firstCheckConnection(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="groupId", description="The ID of a SD-WAN Group") @PathVariable(name="groupId") String groupId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Check SD-WAN IP pool conflict.", description="Check whether the IP pool conflicts with the IP pool of other SD-WAN groups.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/ipPool/check"})
    @a(a=9)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> checkSdWanGroupIpPool(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody SdWanIpPoolRangeOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Auto recommend WAN port.", description="Get the result of recommended WAN port with Auto Select.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/recommend/wans"})
    @a(a=10)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<BatchAutoSelectWanPortResultOpenApiVO>> autoSelectWanPortRecommendResult(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody BatchAutoSelectWanPortReqOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Check whether selected lanNetwork conflict.", description="Check whether selected lanNetwork conflict.")
    @PostMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/lan/check"})
    @a(a=11)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_READ})
    @ResponseBody
    public DeferredResult<OperationResponse<SdWanSelectedLanNetworkOpenApiVO>> checkSelectedLanNetworkConflict(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody SdWanSelectedLanNetworkOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify selected LanNetwork IP.", description="Modify selected LanNetwork IP.")
    @PutMapping(path={"/openapi/v1/{omadacId}/sdwan/sdwan-group/lan/modify"})
    @a(a=12)
    @com.tplink.smb.omada.common.m.a(b={k.SD_WAN_WRITE})
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyLanIpRange(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody LanNetworkBriefOpenApiVO openApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)openApiVO), request, response, omadacId);
    }
}

