/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.organization;

import com.tplink.smb.eventcenter.api.util.JsonUtils;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.m.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.maintenance.openapi.api.vo.BatchSiteCopyVO;
import com.tplink.smb.omada.maintenance.openapi.api.vo.BatchSiteImportVO;
import com.tplink.smb.omada.maintenance.openapi.api.vo.CreateSiteByTemplateOpenApiVO;
import com.tplink.smb.omada.maintenance.openapi.api.vo.SiteResultVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.CreateSiteEntityOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.CreateSiteTagOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.DeleteSiteTagOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.ScenarioOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.SiteEntityOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.SiteSummaryOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.SiteSummaryStatisticOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.SiteTagOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.siteentity.UpdateSiteEntityOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.DeviceAccountSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.PlacedSiteOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.SiteAvailableBindOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.SiteGridOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.UnplacedSiteGridOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.UnplacedSiteOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.informurl.SiteUrlOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.dto.ScenarioDifferenceVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.sitesetting.dto.GetSiteStatisticVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Site")
@RestController
@com.a.a.a.a.b(a=24)
public class SiteManageOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SiteManageOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get site list", description="Get site list")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites"})
    @a(b={})
    @ResponseBody
    @com.a.a.a.a.a(a=1)
    public DeferredResult<OperationResponse<GridVO<SiteSummaryOpenApiVO>>> getSiteList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.name", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.name", required=false) String sortName, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name") @RequestParam(name="searchKey", required=false) String searchKey, @Parameter(name="filters.tag", description="Filter query parameters, support field tag ID") @RequestParam(name="filters.tag", required=false) String filterTagId, @Parameter(name="filters.type", description="Filter query parameters, support field site type. 0: basic site; 1: pro site.") @RequestParam(name="filters.type", required=false) String type) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get site info", description="Get site info")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}"})
    @a(a={b.GET_SITE_FAILED}, b={k.GLOBAL_DASHBOARD_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=2)
    public DeferredResult<OperationResponse<SiteEntityOpenApiVO>> getSiteEntity(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new site", description="Create new site")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites"})
    @a(a={b.DUPLICATE_SITE_NAME, b.REACHED_MAX_SITE_NUM}, b={k.GLOBAL_DASHBOARD_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=3)
    public DeferredResult<OperationResponse> createNewSite(@RequestBody CreateSiteEntityOpenApiVO siteEntity, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)siteEntity), request, response, omadacId);
    }

    @Operation(summary="Batch create sites by copying from existing site", description="Batch create sites by copying from existing site")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/copy"})
    @a(a={b.RESTORE_ERROR, b.RESTORE_RUNNING, b.SYSTEM_BUSY}, b={k.DASHBOARD_WRITE})
    @com.a.a.a.a.a(a=4)
    @ResponseBody
    public DeferredResult<OperationResponse<SiteResultVO>> batchSiteCopy(@RequestBody BatchSiteCopyVO batchSiteCopyVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(JsonUtils.bean2Json((Object)batchSiteCopyVO), request, response, omadacId);
    }

    @Operation(summary="Batch create sites by importing site backup files from file server", description="Batch create sites by importing site backup files from file server.")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/multi-import"})
    @a(a={b.RESTORE_ERROR, b.RESTORE_RUNNING, b.SYSTEM_BUSY}, b={k.DASHBOARD_WRITE})
    @com.a.a.a.a.a(a=5)
    @ResponseBody
    public DeferredResult<OperationResponse<SiteResultVO>> batchSiteImport(@RequestBody BatchSiteImportVO batchSiteImportVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(JsonUtils.bean2Json((Object)batchSiteImportVO), request, response, omadacId);
    }

    @Operation(summary="Create new site from site template", description="Create new site from site template")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/template"})
    @a(a={b.DUPLICATE_SITE_NAME, b.REACHED_MAX_SITE_NUM}, b={k.GLOBAL_DASHBOARD_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=6)
    public DeferredResult<OperationResponse> createNewSiteByTemplate(@RequestBody CreateSiteByTemplateOpenApiVO siteEntity, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)siteEntity), request, response, omadacId);
    }

    @Operation(summary="Modify an existing site", description="Modify an existing site")
    @RequestMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}"}, method={RequestMethod.PUT})
    @a(a={b.GET_SITE_FAILED, b.DUPLICATE_SITE_NAME, b.REACHED_MAX_SITE_NUM, b.SCENARIO_DOES_NOT_EXIST}, b={k.GLOBAL_DASHBOARD_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=7)
    public DeferredResult<OperationResponseWithoutResult> updateSiteEntity(@RequestBody UpdateSiteEntityOpenApiVO siteEntity, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)siteEntity), request, response, omadacId);
    }

    @Operation(summary="Delete an existing site", description="Delete an existing site")
    @RequestMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}"}, method={RequestMethod.DELETE})
    @a(b={k.GLOBAL_DASHBOARD_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=8)
    public DeferredResult<OperationResponseWithoutResult> deleteSite(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get scenario list", description="Get scenario list")
    @GetMapping(value={"/openapi/v1/{omadacId}/scenarios"})
    @ResponseBody
    @com.a.a.a.a.a(a=9)
    public DeferredResult<OperationResponse<List<String>>> getScenarioList(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new scenario", description="Create new scenario")
    @PostMapping(value={"/openapi/v1/{omadacId}/scenarios"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=10)
    public DeferredResult<OperationResponse<List<String>>> addScenario(@RequestBody ScenarioOpenApiVO scenarioOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)scenarioOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete site scenario", description="Delete site scenario")
    @DeleteMapping(value={"/openapi/v1/{omadacId}/scenarios"})
    @a(b={k.NETWORK_WRITE, k.SITE_NETWORK_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=11)
    public DeferredResult<OperationResponseWithoutResult> deleteScenario(@RequestBody ScenarioOpenApiVO scenarioOpenApiVO, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)scenarioOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get site device account setting", description="Get site device account setting")
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/{siteId}/device-account"})
    @a(a={b.GET_SITE_FAILED}, b={k.GLOBAL_DASHBOARD_READ})
    @ResponseBody
    @com.a.a.a.a.a(a=12)
    public DeferredResult<OperationResponse<DeviceAccountSettingOpenApiVO>> getSiteDeviceAccountSetting(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Update site device account setting", description="Update site device account settin")
    @RequestMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/device-account"}, method={RequestMethod.PUT})
    @a(a={b.GET_SITE_FAILED}, b={k.NETWORK_WRITE, k.GLOBAL_DASHBOARD_WRITE})
    @ResponseBody
    @com.a.a.a.a.a(a=13)
    public DeferredResult<OperationResponseWithoutResult> updateSiteDeviceAccountSetting(@RequestBody DeviceAccountSettingOpenApiVO deviceAccount, HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)deviceAccount), request, response, omadacId);
    }

    @Operation(summary="Get site tag list", description="Get site tag list.")
    @a(b={k.GLOBAL_DASHBOARD_READ})
    @GetMapping(value={"/openapi/v1/{omadacId}/sites/tags"})
    @com.a.a.a.a.a(a=14)
    @ResponseBody
    public DeferredResult<List<SiteTagOpenApiVO>> getTags(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Create new site tag", description="Create new site tag.")
    @a(b={k.GLOBAL_DASHBOARD_WRITE})
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/tags"})
    @com.a.a.a.a.a(a=15)
    @ResponseBody
    public DeferredResult<SiteTagOpenApiVO> addTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody CreateSiteTagOpenApiVO tagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Modify an existing site tag", description="Modify an existing site tag.")
    @a(b={k.GLOBAL_DASHBOARD_WRITE})
    @PatchMapping(value={"/openapi/v1/{omadacId}/sites/tags"})
    @com.a.a.a.a.a(a=16)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> modifyTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody SiteTagOpenApiVO tagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Delete an existing site tag", description="Delete an existing site tag.")
    @a(b={k.GLOBAL_DASHBOARD_WRITE})
    @DeleteMapping(value={"/openapi/v1/{omadacId}/sites/tags"})
    @com.a.a.a.a.a(a=17)
    @ResponseBody
    public DeferredResult<OperationResponseWithoutResult> deleteTag(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody DeleteSiteTagOpenApiVO tagOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)tagOpenApiVO), request, response, omadacId);
    }

    @Operation(summary="Get scenario list difference", description="Get a list of default scenarios for differentiation")
    @GetMapping(value={"/openapi/v1/{omadacId}/scenarios/difference"})
    @ResponseBody
    @com.a.a.a.a.a(a=18)
    public DeferredResult<OperationResponse<Set<ScenarioDifferenceVO>>> getScenarioListDifference(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get sites statistic", description="Get sites statistic")
    @PostMapping(value={"/openapi/v1/{omadacId}/sites/statistic"})
    @a(b={})
    @ResponseBody
    @com.a.a.a.a.a(a=19)
    public DeferredResult<OperationResponse<SiteSummaryStatisticOpenApiVO>> getSiteSummaryStatisticByOpenApi(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @RequestBody GetSiteStatisticVO getSiteStatisticVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)getSiteStatisticVO), request, response, omadacId);
    }

    @Operation(summary="Get site url", description="Get site url")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/url"})
    @a(b={k.NETWORK_READ, k.SITE_NETWORK_READ}, a={b.DEVICE_MANAGEMENT_HOST_NOT_ENABLE})
    @com.a.a.a.a.a(a=20)
    @ResponseBody
    public DeferredResult<OperationResponse<SiteUrlOpenApiVO>> getSiteUrlByOpenApi(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get available site to bind template", description="Get available site to bind template.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/available-bind"})
    @a(b={k.SITE_TEMPLATE_WRITE}, a={b.INVALID_SITE_TEMPLATE_ID})
    @com.a.a.a.a.a(a=21)
    @ResponseBody
    public DeferredResult<OperationResponse<SiteGridOpenApiVO<SiteAvailableBindOpenApiVO>>> getAvailableSiteToBind(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get ntp server status", description="Get ntp server status.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/setting/ntp"})
    @a(b={k.ANOMALY_READ}, a={b.GET_SITE_FAILED})
    @com.a.a.a.a.a(a=22)
    @ResponseBody
    public DeferredResult<OperationResponse> getNtpServerStatus(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get template ntp server status", description="Get template ntp server status.")
    @GetMapping(path={"/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}/setting/ntp"})
    @a(b={k.SITE_TEMPLATE_READ}, a={b.GET_SITE_FAILED})
    @com.a.a.a.a.a(a=23)
    @ResponseBody
    public DeferredResult<OperationResponse> getNtpServerStatusTemplate(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteTemplateId", description="Site Template ID") @PathVariable(name="siteTemplateId") String siteTemplateId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Obtain the geographic location information of Placed Sites", description="Obtain the geographic location information of Placed Sites in batches.")
    @GetMapping(path={"/openapi/v1/{omadacId}/placed-site-position"})
    @a(b={k.GLOBAL_DASHBOARD_READ})
    @com.a.a.a.a.a(a=24)
    @ResponseBody
    public DeferredResult<OperationResponse<List<PlacedSiteOpenApiVO>>> getPlacedSitePositions(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Get the details of a site", description="Get the details of a site in the Dashboard - site map")
    @GetMapping(path={"/openapi/v1/{omadacId}/sites/{siteId}/global-dashboard/site-map/abnormal"})
    @a(b={k.GLOBAL_DASHBOARD_READ})
    @com.a.a.a.a.a(a=25)
    @ResponseBody
    public DeferredResult<OperationResponse> getSiteInfoForAbnormal(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="siteId", description="Site ID") @PathVariable(name="siteId") String siteId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }

    @Operation(summary="Obtain the geographic location information of unplaced Sites", description="Obtain the geographic location information of unplaced Sites.")
    @GetMapping(path={"/openapi/v1/{omadacId}/unplaced-site-position"})
    @a(b={k.GLOBAL_DASHBOARD_READ})
    @com.a.a.a.a.a(a=26)
    @ResponseBody
    public DeferredResult<OperationResponse<UnplacedSiteGridOpenApiVO<UnplacedSiteOpenApiVO>>> getUnplacedSitePositions(HttpServletRequest request, HttpServletResponse response, @Parameter(name="omadacId", description="Omada ID") @PathVariable(name="omadacId") String omadacId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="searchKey", description="Fuzzy query parameters, support field name") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, omadacId);
    }
}

