/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp.webhook;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.OpenApiWebhookDispatchLogVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.OpenApiWebhookSettingAddVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.OpenApiWebhookSettingEditVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.OpenApiWebhookSettingTestVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.OpenApiWebhookSettingVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Msp Webhook Setting")
@RestController
@b(a=13)
@Conditional(value={MspSwaggerMatchCondition.class})
public class MspWebhookManageOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspWebhookManageOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get MSP webhook setting list", description="Get all MSP webhook setting.")
    @GetMapping(path={"/openapi/v1/msp/{mspId}/webhook/settings"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_WEBHOOK_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<List<OpenApiWebhookSettingVO>>> getWebhookForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Create MSP webhook setting", description="Create MSP webhook setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.WEBHOOK_REACH_LIMIT, com.tplink.smb.omada.common.g.b.DUPLICATE_WEBHOOK_NAME, com.tplink.smb.omada.common.g.b.ILLEGAL_WEBHOOK_URL_LIST}, b={k.MSP_WEBHOOK_WRITE})
    @PostMapping(path={"/openapi/v1/msp/{mspId}/webhook/settings"})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponseWithoutResult> createWebhookForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody OpenApiWebhookSettingAddVO webhookSettingAddVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)webhookSettingAddVO), request, response, mspId);
    }

    @Operation(summary="Modify MSP webhook setting", description="Modify MSP webhook setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.ILLEGAL_WEBHOOK_ENTRY, com.tplink.smb.omada.common.g.b.ILLEGAL_WEBHOOK_URL_LIST}, b={k.MSP_WEBHOOK_WRITE})
    @PatchMapping(path={"/openapi/v1/msp/{mspId}/webhook/settings/{webhookId}"})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> modifyWebhookForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="webhookId", description="Webhook ID") @PathVariable(name="webhookId") String webhookId, @RequestBody OpenApiWebhookSettingEditVO webhookSettingEditVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)webhookSettingEditVO), request, response, mspId);
    }

    @Operation(summary="Delete MSP webhook setting", description="Delete MSP webhook setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.ILLEGAL_WEBHOOK_ENTRY}, b={k.MSP_WEBHOOK_WRITE})
    @DeleteMapping(path={"/openapi/v1/msp/{mspId}/webhook/settings/{webhookId}"})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponseWithoutResult> deleteWebhookForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="webhookId", description="Webhook ID") @PathVariable(name="webhookId") String webhookId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Test MSP webhook setting", description="Test MSP webhook setting.")
    @com.tplink.smb.omada.common.m.a(a={com.tplink.smb.omada.common.g.b.ILLEGAL_WEBHOOK_URL_LIST}, b={k.MSP_WEBHOOK_WRITE})
    @PostMapping(path={"/openapi/v1/msp/{mspId}/webhook/settings/{webhookId}"})
    @ResponseBody
    @a(a=5)
    public DeferredResult<OperationResponseWithoutResult> testWebhookFormsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="webhookId", description="Webhook ID") @PathVariable(name="webhookId") String webhookId, @RequestBody OpenApiWebhookSettingTestVO webhookSettingTestVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)webhookSettingTestVO), request, response, mspId);
    }

    @Operation(summary="Get MSP webhook dispatch log list", description="Get MSP webhook dispatch log list.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/webhook/settings/dispatch-logs"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_WEBHOOK_READ})
    @ResponseBody
    @a(a=6)
    public DeferredResult<OperationResponse<GridVO<OpenApiWebhookDispatchLogVO>>> getWebhookLogsForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", required=true, description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", required=true, description="Number of entries per page. It should be within the range of 1\u20131000.") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="filters.webhookId", description="Filter query parameters, support field d66aed17ea7238154ba610710d9a2890") @RequestParam(name="filters.webhookId") String filtersWebhookId, @Parameter(name="filters.timeStart", description="Filter query parameters, support field 1679297710438") @RequestParam(name="filters.timeStart") Long filtersTimeStart, @Parameter(name="filters.timeEnd", description="Filter query parameters, support field 1681889710438") @RequestParam(name="filters.timeEnd") Long filtersTimeEnd) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }
}

