/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.openapi.controller.msp.log;

import com.a.a.a.a.a;
import com.a.a.a.a.b;
import com.tplink.smb.omada.apigateway.openapi.OpenApiHandler;
import com.tplink.smb.omada.apigateway.openapi.configuration.MspSwaggerMatchCondition;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.OperationResponseWithoutResult;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.logmanager.api.external.openapi.AuditLogOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.audit.AuditLogNotificationSettingEditOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.audit.AuditLogNotificationSettingOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.ExportMspLogOpenApiVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@Tag(name="Msp Log")
@RestController
@b(a=1)
@Conditional(value={MspSwaggerMatchCondition.class})
public class MspAuditLogManageOpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspAuditLogManageOpenApiController.class);
    @Autowired
    private OpenApiHandler openApiHandler;

    @Operation(summary="Get MSP audit log list", description="Get audit logs in msp audit page.This interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/audit-logs"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_LOG_READ})
    @ResponseBody
    @a(a=1)
    public DeferredResult<OperationResponse<GridVO<AuditLogOpenApiVO>>> getAuditLogsForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @Parameter(name="page", description="Start page number. Start from 1.") @RequestParam(name="page") Integer page, @Parameter(name="pageSize", description="Number of entries per page. It should be within the range of 1\u20131000.(value:10,15,20,30,50,100)") @RequestParam(name="pageSize") Integer pageSize, @Parameter(name="sorts.time", description="Sort parameter may be one of asc or desc. Optional parameter. If it is not carried, it means it is not sorted by this field. When there are more than one, the first one takes effect") @RequestParam(name="sorts.time", required=false) String sortsTime, @Parameter(name="filters.result", description="Filter query parameters, support field result,it should be a value as follows: 0: successful; 1: failed,example:0") @RequestParam(name="filters.result", required=false) Integer filtersResult, @Parameter(name="filters.level", description="Filter query parameters, support field level,it should be a value as follows: Error; Warning; Information, example:Error") @RequestParam(name="filters.level", required=false) String filtersLevel, @Parameter(name="filters.auditTypes", description="Filter query parameters, support field auditTypes, for the values of auditLog type, refer to section 5.2.2 of the Open API Access Guide, example:Log,Cloud Access,User Interface.") @RequestParam(name="filters.auditTypes", required=false) String filtersAuditTypes, @Parameter(name="filters.times", description="Filter query parameters, support field times, example:[{\"timeStart\":1678060800000,\"timeEnd\":1678665599999}](UrlEncode:%5B%7B%22timeStart%22%3A1678060800000%2C%22timeEnd%22%3A1678665599999%7D%5D).If this parameter is not specified (not included or empty array), the interface will query data within the default time period: [{\"timeStart\":  Current timestamp minus milliseconds of 7 days,\"timeEnd\": Current timestamp}].") @RequestParam(name="filters.times", required=false) String filtersTimes, @Parameter(name="searchKey", description="Fuzzy query parameters, support field content") @RequestParam(name="searchKey", required=false) String searchKey) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Get MSP audit log notification", description="Get msp audit log notification.This interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @GetMapping(value={"/openapi/v1/msp/{mspId}/audit-notification"})
    @com.tplink.smb.omada.common.m.a(b={k.MSP_LOG_READ})
    @ResponseBody
    @a(a=2)
    public DeferredResult<OperationResponse<AuditLogNotificationSettingOpenApiVO>> getAuditLogSettingForMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(null, request, response, mspId);
    }

    @Operation(summary="Modify MSP audit log notification", description="Modify MSP audit log notification.This interface applies to the Omada Pro Controller only. Please do not use it for non-Pro controllers.")
    @com.tplink.smb.omada.common.m.a(b={k.MSP_LOG_WRITE})
    @PatchMapping(path={"/openapi/v1/msp/{mspId}/audit-notification"})
    @ResponseBody
    @a(a=3)
    public DeferredResult<OperationResponseWithoutResult> modifyAuditLogSettingMsp(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody AuditLogNotificationSettingEditOpenApiVO auditLogSettingEditVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)auditLogSettingEditVO), request, response, mspId);
    }

    @Operation(summary="Export audit log list in MSP view", description="Export audit log list in MSP view.")
    @com.tplink.smb.omada.common.m.a(b={k.MSP_DATA_EXPORT})
    @PostMapping(value={"/openapi/v1/msp/{mspId}/logs/audit/export"})
    @ResponseBody
    @a(a=4)
    public DeferredResult<OperationResponse> exportAuditLogListForGlobal(HttpServletRequest request, HttpServletResponse response, @Parameter(name="mspId", description="MSP ID") @PathVariable(name="mspId") String mspId, @RequestBody ExportMspLogOpenApiVO exportMspLogOpenApiVO) {
        return (DeferredResult)this.openApiHandler.handleOpenApi(x.a((Object)exportMspLogOpenApiVO), request, response, mspId);
    }
}

